/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.ui.composites;

import javax.vecmath.Matrix3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.provider.MathEditUtils;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TransformMatrixComposite
extends Composite {
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Matrix4x4 matrix;
    private final Tuple3dComposite translationComposite;
    private final Tuple3dComposite rotationComposite;
    private Tuple3d positionTuple3d;
    private Tuple3d orientationTuple3d;
    private Adapter matrixAdapter;
    private boolean disableEvent = false;
    private Adapter positionTuple3dAdapter;
    private Adapter orientationTuple3dAdapter;
    private EditingDomain editingDomain;

    public TransformMatrixComposite(Composite parent, int style, EditingDomain editingDomain) {
        this(parent, style);
        this.editingDomain = editingDomain;
    }

    public TransformMatrixComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Section translationSection = this.toolkit.createSection((Composite)this, 320);
        translationSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        translationSection.setText("Translation (x,y,z)");
        this.translationComposite = new Tuple3dComposite((Composite)translationSection, 0, "0.0000");
        this.translationComposite.setBackground(this.getDisplay().getSystemColor(1));
        translationSection.setClient((Control)this.translationComposite);
        Section rotationSection = this.toolkit.createSection((Composite)this, 320);
        rotationSection.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        rotationSection.setText("Rotation (rx,ry,rz)");
        this.rotationComposite = new Tuple3dComposite((Composite)rotationSection, 0, "0.000");
        this.rotationComposite.setBackground(this.getDisplay().getSystemColor(1));
        rotationSection.setClient((Control)this.rotationComposite);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TransformMatrixComposite.this.setMatrix4x4(null);
                TransformMatrixComposite.this.toolkit.dispose();
            }
        });
    }

    public void setMatrix4x4(Matrix4x4 matrix) {
        this.getPositionTuple3d().eAdapters().remove((Object)this.getPositionTuple3dAdapter());
        this.getOrientationTuple3d().eAdapters().remove((Object)this.getOrientationTuple3dAdapter());
        if (this.getMatrix() != null) {
            this.getMatrix().eAdapters().remove((Object)this.getMatrixAdapter());
        }
        this.matrix = matrix;
        if (this.getMatrix() != null) {
            this.translationComposite.setTuple3d(this.getPositionTuple3d());
            this.rotationComposite.setTuple3d(this.getOrientationTuple3d());
            this.updatePositionAndOrientationTuples(this.getMatrix(), this.getPositionTuple3d(), this.getOrientationTuple3d());
            this.getMatrix().eAdapters().add((Object)this.getMatrixAdapter());
            this.getPositionTuple3d().eAdapters().add((Object)this.getPositionTuple3dAdapter());
            this.getOrientationTuple3d().eAdapters().add((Object)this.getOrientationTuple3dAdapter());
        }
    }

    private Adapter getMatrixAdapter() {
        if (this.matrixAdapter == null) {
            this.matrixAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (!TransformMatrixComposite.this.disableEvent) {
                        TransformMatrixComposite.this.updatePositionAndOrientationTuples(TransformMatrixComposite.this.getMatrix(), TransformMatrixComposite.this.getPositionTuple3d(), TransformMatrixComposite.this.getOrientationTuple3d());
                    }
                }
            };
        }
        return this.matrixAdapter;
    }

    public Matrix4x4 getMatrix() {
        return this.matrix;
    }

    private void updatePositionAndOrientationTuples(Matrix4x4 matrix, Tuple3d position, Tuple3d orientation) {
        this.disableEvent = true;
        Tuple3d result = ApogyCommonMathFacade.INSTANCE.extractPosition(matrix);
        position.setX(result.getX());
        position.setY(result.getY());
        position.setZ(result.getZ());
        result = ApogyCommonMathFacade.INSTANCE.extractOrientation(matrix);
        orientation.setX(Math.toDegrees(result.getX()));
        orientation.setY(Math.toDegrees(result.getY()));
        orientation.setZ(Math.toDegrees(result.getZ()));
        this.disableEvent = false;
    }

    protected void checkSubclass() {
    }

    private Tuple3d getPositionTuple3d() {
        if (this.positionTuple3d == null) {
            this.positionTuple3d = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        }
        return this.positionTuple3d;
    }

    private Adapter getPositionTuple3dAdapter() {
        if (this.positionTuple3dAdapter == null) {
            this.positionTuple3dAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (!TransformMatrixComposite.this.disableEvent) {
                        TransformMatrixComposite.this.disableEvent = true;
                        if (msg.getEventType() == 1) {
                            switch (msg.getFeatureID(Tuple3d.class)) {
                                case 0: {
                                    if (TransformMatrixComposite.this.editingDomain == null) {
                                        TransformMatrixComposite.this.getMatrix().setM03(TransformMatrixComposite.this.getPositionTuple3d().getX());
                                        break;
                                    }
                                    TransformMatrixComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TransformMatrixComposite.this.editingDomain, (Object)TransformMatrixComposite.this.getMatrix(), (Object)ApogyCommonMathPackage.Literals.MATRIX4X4__M03, (Object)TransformMatrixComposite.this.positionTuple3d.getX()));
                                    break;
                                }
                                case 1: {
                                    if (TransformMatrixComposite.this.editingDomain == null) {
                                        TransformMatrixComposite.this.getMatrix().setM13(TransformMatrixComposite.this.getPositionTuple3d().getY());
                                        break;
                                    }
                                    TransformMatrixComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TransformMatrixComposite.this.editingDomain, (Object)TransformMatrixComposite.this.getMatrix(), (Object)ApogyCommonMathPackage.Literals.MATRIX4X4__M13, (Object)TransformMatrixComposite.this.positionTuple3d.getY()));
                                    break;
                                }
                                case 2: {
                                    if (TransformMatrixComposite.this.editingDomain == null) {
                                        TransformMatrixComposite.this.getMatrix().setM23(TransformMatrixComposite.this.getPositionTuple3d().getZ());
                                        break;
                                    }
                                    TransformMatrixComposite.this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)TransformMatrixComposite.this.editingDomain, (Object)TransformMatrixComposite.this.getMatrix(), (Object)ApogyCommonMathPackage.Literals.MATRIX4X4__M23, (Object)TransformMatrixComposite.this.positionTuple3d.getZ()));
                                }
                            }
                        }
                        TransformMatrixComposite.this.disableEvent = false;
                    }
                }
            };
        }
        return this.positionTuple3dAdapter;
    }

    private Tuple3d getOrientationTuple3d() {
        if (this.orientationTuple3d == null) {
            this.orientationTuple3d = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        }
        return this.orientationTuple3d;
    }

    private Adapter getOrientationTuple3dAdapter() {
        if (this.orientationTuple3dAdapter == null) {
            this.orientationTuple3dAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (!TransformMatrixComposite.this.disableEvent) {
                        TransformMatrixComposite.this.disableEvent = true;
                        if (msg.getEventType() == 1) {
                            Matrix3d matrix3d = GeometricUtils.packXYZ((double)Math.toRadians(TransformMatrixComposite.this.getOrientationTuple3d().getX()), (double)Math.toRadians(TransformMatrixComposite.this.getOrientationTuple3d().getY()), (double)Math.toRadians(TransformMatrixComposite.this.getOrientationTuple3d().getZ()));
                            MathEditUtils.updateOrientation((Matrix4x4)TransformMatrixComposite.this.getMatrix(), (Matrix3x3)ApogyCommonMathFacade.INSTANCE.createMatrix3x3(matrix3d), (EditingDomain)TransformMatrixComposite.this.editingDomain);
                        }
                        TransformMatrixComposite.this.disableEvent = false;
                    }
                }
            };
        }
        return this.orientationTuple3dAdapter;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

