/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.impl;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.Arrays;
import org.eclipse.apogy.common.math.impl.PolynomialImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class PolynomialCustomImpl
extends PolynomialImpl {
    private boolean isDirty;

    @Override
    public int getDegree() {
        if (this.getCoeffs() == null || this.getCoeffs().length == 0) {
            return -1;
        }
        return this.getCoeffs().length - 1;
    }

    @Override
    public void setCoeffs(double[] newCoeffs) {
        double[] oldCoeffs = this.coeffs;
        this.coeffs = newCoeffs;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldCoeffs, (Object)this.coeffs));
        }
        this.isDirty = true;
    }

    @Override
    public double[] getRealRoots() {
        if (this.isDirty) {
            this.roots();
        }
        return this.realRoots;
    }

    @Override
    public double[] getImaginaryRoots() {
        if (this.isDirty) {
            this.roots();
        }
        return this.imaginaryRoots;
    }

    private void roots() {
        double[] a = this.getCoeffs();
        int m = a.length - 1;
        Matrix hess = new Matrix(m + 1, m + 1);
        int k = 1;
        while (k <= m) {
            if (a[m] == 0.0) {
                System.err.println("division by 0");
            }
            hess.set(1, k, -a[m - k] / a[m]);
            int j = 2;
            while (j <= m) {
                hess.set(j, k, 0.0);
                ++j;
            }
            if (k != m) {
                hess.set(k + 1, k, 1.0);
            }
            ++k;
        }
        EigenvalueDecomposition eig = new EigenvalueDecomposition(hess);
        this.realRoots = Arrays.copyOf(eig.getRealEigenvalues(), eig.getRealEigenvalues().length);
        this.imaginaryRoots = Arrays.copyOf(eig.getImagEigenvalues(), eig.getRealEigenvalues().length);
        this.isDirty = false;
    }
}

