/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.impl;

import org.eclipse.apogy.examples.lander.LanderLegExtension;
import org.eclipse.apogy.examples.lander.impl.LanderStubImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanderStubCustomImpl
extends LanderStubImpl {
    private static final Logger Logger = LoggerFactory.getLogger(LanderStubImpl.class);
    private static final String DEGREE_SYM = "\u00b0";

    @Override
    public double getGravitationalPull() {
        return 0.0;
    }

    @Override
    public double getMass() {
        return 1.0;
    }

    @Override
    public boolean init() {
        Logger.info("Just a stub: The necessary initialization for the lander would have taken place.");
        return true;
    }

    @Override
    public void commandLegPosition(LanderLegExtension legAExtension, LanderLegExtension legBExtension, LanderLegExtension legCExtension) {
        Logger.info(".commandLegPosition(LanderLegPosition." + legAExtension.getName() + ", LanderLegPosition." + legBExtension.getName() + ", LanderLegPosition." + legCExtension.getName() + "): Just a stub - " + "the legs of the lander would have extended / " + "retracted to match the specified leg extensions");
    }

    @Override
    public void commandAngularVelocities(double xAngularVelocity, double yAngularVelocity) {
        Logger.info(".commandAngularVelocities(" + Math.toDegrees(xAngularVelocity) + " (" + DEGREE_SYM + "/s), " + Math.toDegrees(yAngularVelocity) + " (" + DEGREE_SYM + "/s)): Just a stub - " + "the lander's angular velocities would have been " + "appropriately updated.");
    }

    @Override
    public void commandThrust(double thrustLevel) {
        Logger.info(".commandThrust(" + thrustLevel + "): Just a stub - " + "the lander's thrust level would have been " + "appropriately updated.");
    }

    @Override
    public void changeThrustBy(double thrustOffset) {
        Logger.info(".changeThrustBy(" + thrustOffset + "): Just a stub - " + "the lander's thrust level would have been " + "increased / decreased accordingly.");
    }

    @Override
    public void startFlying(boolean logStateChanges) {
        Logger.info(".startFlying(" + logStateChanges + "): Just a stub - " + "the lander would be able to start flying.");
    }

    @Override
    public void stopFlying() {
        Logger.info("Just a stub - the lander would stop flying and land immediately.");
    }

    @Override
    public void moveTo(double x, double y, double z) {
        Logger.info("moveTo(" + x + ", " + y + ", " + z + "): " + "Just a stub - the lander would move to the " + "specified Cartesian coordinates.");
    }

    @Override
    public void changeAttitude(double xAngle, double yAngle, double zAngle) {
        Logger.info("changeAttitude(" + Math.toDegrees(xAngle) + DEGREE_SYM + ", " + Math.toDegrees(yAngle) + DEGREE_SYM + ", " + Math.toDegrees(zAngle) + DEGREE_SYM + "): Just a stub - " + "the lander would change its attitude / orientation " + "to reflect the specified angles.");
    }

    @Override
    public void resetAttitude() {
        Logger.info("resetAttitude(): Just a stub - the lander would reset its attitude / orientation.");
    }

    @Override
    public void dispose() {
        Logger.info("dispose(): Just a stub - the lander would perform the required disposal operations.");
    }
}

