/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.JApplet;
import javax.swing.JFrame;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgrapht.DirectedGraph;
import org.jgrapht.ext.JGraphModelAdapter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.DirectedMultigraph;

public class JGraphAdapterDemo
extends JApplet {
    private static final long serialVersionUID = 3256444702936019250L;
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter<String, DefaultEdge> jgAdapter;

    public static void main(String[] args) {
        JGraphAdapterDemo applet = new JGraphAdapterDemo();
        applet.init();
        JFrame frame = new JFrame();
        frame.getContentPane().add(applet);
        frame.setTitle("JGraphT Adapter to JGraph Demo");
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void init() {
        ListenableDirectedMultigraph<String, DefaultEdge> g = new ListenableDirectedMultigraph<String, DefaultEdge>(DefaultEdge.class);
        this.jgAdapter = new JGraphModelAdapter(g);
        JGraph jgraph = new JGraph(this.jgAdapter);
        this.adjustDisplaySettings(jgraph);
        this.getContentPane().add((Component)jgraph);
        this.resize(DEFAULT_SIZE);
        String v1 = "v1";
        String v2 = "v2";
        String v3 = "v3";
        String v4 = "v4";
        g.addVertex(v1);
        g.addVertex(v2);
        g.addVertex(v3);
        g.addVertex(v4);
        g.addEdge(v1, v2);
        g.addEdge(v2, v3);
        g.addEdge(v3, v1);
        g.addEdge(v4, v3);
        this.positionVertexAt(v1, 130, 40);
        this.positionVertexAt(v2, 60, 200);
        this.positionVertexAt(v3, 310, 230);
        this.positionVertexAt(v4, 380, 70);
    }

    private void adjustDisplaySettings(JGraph jg) {
        jg.setPreferredSize(DEFAULT_SIZE);
        Color c = DEFAULT_BG_COLOR;
        String colorStr = null;
        try {
            colorStr = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (colorStr != null) {
            c = Color.decode(colorStr);
        }
        jg.setBackground(c);
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = this.jgAdapter.getVertexCell(vertex);
        AttributeMap attr = cell.getAttributes();
        Rectangle2D bounds = GraphConstants.getBounds((Map)attr);
        Rectangle2D.Double newBounds = new Rectangle2D.Double(x, y, bounds.getWidth(), bounds.getHeight());
        GraphConstants.setBounds((Map)attr, (Rectangle2D)newBounds);
        AttributeMap cellAttr = new AttributeMap();
        cellAttr.put((Object)cell, (Object)attr);
        this.jgAdapter.edit((Map)cellAttr, null, null, null);
    }

    private static class ListenableDirectedMultigraph<V, E>
    extends DefaultListenableGraph<V, E>
    implements DirectedGraph<V, E> {
        private static final long serialVersionUID = 1L;

        ListenableDirectedMultigraph(Class<E> edgeClass) {
            super(new DirectedMultigraph(edgeClass));
        }
    }
}

