/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.generate;

import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.VertexFactory;
import org.jgrapht.generate.GraphGenerator;

public class StarGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    public static final String CENTER_VERTEX = "Center Vertex";
    private int order;

    public StarGraphGenerator(int order) {
        this.order = order;
    }

    @Override
    public void generateGraph(Graph<V, E> target, VertexFactory<V> vertexFactory, Map<String, V> resultMap) {
        if (this.order < 1) {
            return;
        }
        V centerVertex = vertexFactory.createVertex();
        target.addVertex(centerVertex);
        if (resultMap != null) {
            resultMap.put(CENTER_VERTEX, centerVertex);
        }
        int i = 0;
        while (i < this.order - 1) {
            V newVertex = vertexFactory.createVertex();
            target.addVertex(newVertex);
            ++i;
        }
        for (V v : target.vertexSet()) {
            if (v == centerVertex) continue;
            target.addEdge(v, centerVertex);
        }
    }
}

