/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.tree;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.details.tree.XSDTreeNode;
import org.eclipse.xsd.XSDSchema;

public class XSDSchemaTreeNode
extends XSDTreeNode {
    public XSDSchemaTreeNode(XSDSchema schema, boolean isCondensed) {
        super(schema, isCondensed);
    }

    @Override
    public boolean isNodeFlattenable() {
        return true;
    }

    @Override
    public Object[] getChildren() {
        XSDSchema schema = (XSDSchema)this.modelObject;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        this.addNodes(list, (List)schema.getElementDeclarations());
        this.addNodes(list, (List)schema.getTypeDefinitions());
        return list.toArray();
    }

    @Override
    public boolean hasChildren() {
        XSDSchema schema = (XSDSchema)this.modelObject;
        return schema.getElementDeclarations().size() > 0 || schema.getTypeDefinitions().size() > 0;
    }

    @Override
    public String getLabel() {
        XSDSchema schema = (XSDSchema)this.modelObject;
        schema.getTargetNamespace();
        String tns = schema.getTargetNamespace();
        if (tns == null) {
            return Messages.XSDSchemaTreeNode_0;
        }
        return MessageFormat.format(Messages.XSDSchemaTreeNode_1, tns);
    }

    @Override
    public String getLabelSuffix() {
        return super.getLabelSuffix();
    }
}

