/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.common.ui.assist.FieldAssistAdapter;
import org.eclipse.bpel.common.ui.details.IOngoingChange;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.common.ui.flatui.FlatFormLayout;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.FromPart;
import org.eclipse.bpel.model.FromParts;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.Receive;
import org.eclipse.bpel.model.Reply;
import org.eclipse.bpel.model.ToPart;
import org.eclipse.bpel.model.ToParts;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddFromPartCommand;
import org.eclipse.bpel.ui.commands.AddToPartCommand;
import org.eclipse.bpel.ui.commands.AddVariableCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.SetVariableCommand;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.VariableContentProvider;
import org.eclipse.bpel.ui.details.providers.VariableFilter;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.ChangeTracker;
import org.eclipse.bpel.ui.proposal.providers.ModelContentProposalProvider;
import org.eclipse.bpel.ui.proposal.providers.RunnableProposal;
import org.eclipse.bpel.ui.proposal.providers.Separator;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.BatchedMultiObjectAdapter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.NameDialog;
import org.eclipse.bpel.ui.util.PartMappingUtil;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.xsd.XSDElementDeclaration;

public class InvokeVariableSection
extends BPELPropertySection {
    private VariableFilter fInputVariableFilter = new VariableFilter();
    private VariableFilter fOutputVariableFilter = new VariableFilter();
    private IControlContentAdapter fTextContentAdapter = new TextContentAdapter(){

        public void insertControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.insertControlContents(control, text, cursorPosition);
            }
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            if (text != null) {
                super.setControlContents(control, text, cursorPosition);
            }
        }
    };
    private Button inputVariableButton;
    private Composite inputVariableComposite;
    private Label inputVariableLabel;
    private Text inputVariableText;
    private Composite nonPartMappingComposite;
    private Widget operationLabel;
    private Button outputVariableButton;
    private Composite outputVariableComposite;
    private Label outputVariableLabel;
    private Text outputVariableText;
    private Composite parentComposite;
    private Composite partMappingComposite;
    private Button usePartMappingCheckbox;

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        try {
            FromParts fromParts = ModelHelper.getFromParts(this.getModel());
            if (fromParts != null) {
                this.fAdapters[0].addToObject((Notifier)fromParts);
                if (fromParts.getChildren() != null) {
                    for (FromPart fromPart : fromParts.getChildren()) {
                        this.fAdapters[0].addToObject((Notifier)fromPart);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            ToParts toParts = ModelHelper.getToParts(this.getModel());
            if (toParts != null) {
                this.fAdapters[0].addToObject((Notifier)toParts);
                if (toParts.getChildren() != null) {
                    for (ToPart toPart : toParts.getChildren()) {
                        this.fAdapters[0].addToObject((Notifier)toPart);
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.usePartMappingCheckbox.setSelection(this.shouldUsePartMapping((EObject)this.getModel()));
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new BatchedMultiObjectAdapter(){

            @Override
            public void finish() {
                InvokeVariableSection.this.refresh();
            }

            @Override
            public void notify(Notification n) {
                if ((ModelHelper.isVariableAffected(InvokeVariableSection.this.getInput(), n, 1) || ModelHelper.isVariableAffected(InvokeVariableSection.this.getInput(), n, 0)) && n.getEventType() == 1 && n.getNewValue() != null) {
                    InvokeVariableSection.this.usePartMappingCheckbox.setSelection(false);
                    try {
                        ModelHelper.setToParts(InvokeVariableSection.this.getInput(), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    try {
                        ModelHelper.setFromParts(InvokeVariableSection.this.getInput(), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }};
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createWidgets(composite);
    }

    private Composite createInputVariableWidgets(Composite top, Composite parent) {
        Composite composite = this.inputVariableComposite = this.createFlatFormComposite(parent);
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.inputVariableLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplSection_7);
        this.inputVariableText = this.fWidgetFactory.createText(composite, "");
        this.inputVariableButton = this.fWidgetFactory.createButton(composite, "", 0x1000404);
        RunnableProposal proposal = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_10;
            }

            @Override
            public void run() {
                InvokeVariableSection.this.createVariable((EObject)BPELUtils.getProcess(InvokeVariableSection.this.getInput()), null, InvokeVariableSection.this.isInvoke() ? 0 : 1);
            }
        };
        RunnableProposal proposal2 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_11;
            }

            @Override
            public void run() {
                InvokeVariableSection.this.createVariable(InvokeVariableSection.this.getInput(), null, InvokeVariableSection.this.isInvoke() ? 0 : 1);
            }
        };
        RunnableProposal proposal3 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_12;
            }

            @Override
            public void run() {
                int direction = InvokeVariableSection.this.isInvoke() ? 0 : 1;
                InvokeVariableSection.this.getCommandFramework().execute((Command)new SetVariableCommand((EObject)InvokeVariableSection.this.getInput(), null, direction));
            }
        };
        VariableContentProvider provider = new VariableContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return InvokeVariableSection.this.getInput();
            }
        }, provider, this.fInputVariableFilter);
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(proposal);
        proposalProvider.addProposalToEnd(proposal2);
        proposalProvider.addProposalToEnd(proposal3);
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.inputVariableText, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal3);
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                Variable variable = null;
                try {
                    variable = (Variable)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                SetVariableCommand cmd = new SetVariableCommand((EObject)InvokeVariableSection.this.getInput(), variable);
                InvokeVariableSection.this.getCommandFramework().execute((Command)cmd);
            }
        });
        this.inputVariableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        this.inputVariableText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    InvokeVariableSection.this.findAndSetOrCreateVariable(InvokeVariableSection.this.inputVariableText.getText(), InvokeVariableSection.this.isInvoke() ? 0 : 1);
                }
            }
        });
        this.inputVariableText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
            }

            public void focusLost(FocusEvent arg0) {
                InvokeVariableSection.this.findAndSetOrCreateVariable(InvokeVariableSection.this.inputVariableText.getText(), InvokeVariableSection.this.isInvoke() ? 0 : 1);
            }
        });
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.inputVariableText, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.inputVariableText, -2, 1024);
        this.inputVariableButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth(this.operationLabel, 105));
        data.right = new FlatFormAttachment((Control)this.inputVariableButton, 0);
        this.inputVariableText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.inputVariableText, -5);
        data.top = new FlatFormAttachment((Control)this.inputVariableText, 0, 0x1000000);
        this.inputVariableLabel.setLayoutData((Object)data);
        return composite;
    }

    private Composite createOutputVariableWidgets(Composite top, Composite parent) {
        Composite composite = this.outputVariableComposite = this.createFlatFormComposite(parent);
        if (this.isReceive()) {
            return composite;
        }
        FlatFormData data = new FlatFormData();
        data.top = top == null ? new FlatFormAttachment(0, 4) : new FlatFormAttachment((Control)top, 4);
        data.left = new FlatFormAttachment(0, 5);
        data.right = new FlatFormAttachment(55, -15);
        composite.setLayoutData((Object)data);
        this.outputVariableLabel = this.fWidgetFactory.createLabel(composite, Messages.InvokeImplSection_13);
        this.outputVariableText = this.fWidgetFactory.createText(composite, "");
        this.outputVariableButton = this.fWidgetFactory.createButton(composite, "", 0x1000404);
        RunnableProposal proposal = new RunnableProposal(){

            @Override
            public String getLabel() {
                return Messages.InvokeImplSection_16;
            }

            @Override
            public void run() {
                InvokeVariableSection.this.createVariable((EObject)BPELUtils.getProcess(InvokeVariableSection.this.getInput()), null, InvokeVariableSection.this.isInvoke() ? 1 : 0);
            }
        };
        RunnableProposal proposal2 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return "Create Local Output Variable";
            }

            @Override
            public void run() {
                InvokeVariableSection.this.createVariable(InvokeVariableSection.this.getInput(), null, InvokeVariableSection.this.isInvoke() ? 1 : 0);
            }
        };
        RunnableProposal proposal3 = new RunnableProposal(){

            @Override
            public String getLabel() {
                return "Clear Output Variable";
            }

            @Override
            public void run() {
                InvokeVariableSection.this.getCommandFramework().execute((Command)new SetVariableCommand((EObject)InvokeVariableSection.this.getInput(), null, InvokeVariableSection.this.isInvoke() ? 1 : 0));
            }
        };
        VariableContentProvider provider = new VariableContentProvider();
        ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

            @Override
            public Object value() {
                return InvokeVariableSection.this.getInput();
            }
        }, provider, this.fOutputVariableFilter);
        proposalProvider.addProposalToEnd(new Separator());
        proposalProvider.addProposalToEnd(proposal);
        proposalProvider.addProposalToEnd(proposal2);
        proposalProvider.addProposalToEnd(proposal3);
        final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)this.outputVariableText, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
        contentAssist.setLabelProvider((ILabelProvider)new ModelLabelProvider());
        contentAssist.setPopupSize(new Point(300, 100));
        contentAssist.setFilterStyle(3);
        contentAssist.setProposalAcceptanceStyle(2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal2);
        contentAssist.addContentProposalListener((IContentProposalListener)proposal3);
        contentAssist.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal chosenProposal) {
                if (chosenProposal.getContent() == null) {
                    return;
                }
                Variable variable = null;
                try {
                    variable = (Variable)((Adapter)chosenProposal).getTarget();
                }
                catch (Throwable throwable) {
                    return;
                }
                SetVariableCommand cmd = new SetVariableCommand((EObject)InvokeVariableSection.this.getInput(), variable, 1);
                InvokeVariableSection.this.getCommandFramework().execute((Command)cmd);
            }
        });
        this.outputVariableButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                contentAssist.openProposals();
            }
        });
        this.outputVariableText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 13) {
                    InvokeVariableSection.this.findAndSetOrCreateVariable(InvokeVariableSection.this.outputVariableText.getText(), 1);
                }
            }
        });
        data = new FlatFormData();
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.outputVariableText, 2, 128);
        data.bottom = new FlatFormAttachment((Control)this.outputVariableText, -2, 1024);
        this.outputVariableButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth(this.operationLabel, 105));
        data.right = new FlatFormAttachment((Control)this.outputVariableButton, 0);
        this.outputVariableText.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment((Control)this.outputVariableText, -5);
        data.top = new FlatFormAttachment((Control)this.outputVariableText, 0, 0x1000000);
        this.outputVariableLabel.setLayoutData((Object)data);
        return composite;
    }

    private void createPartMappingRows(ILabelProvider labelProvider, final EObject model, List<Part> messageParts, Group refGroup, EObject fromPartsOrToParts, final boolean isFromParts) {
        CLabel ref = null;
        for (final Part part : messageParts) {
            FlatFormData data;
            boolean isFirst = ref == null;
            final Text text = this.fWidgetFactory.createText((Composite)refGroup, "");
            Variable var = null;
            if (isFromParts) {
                FromParts fromParts = (FromParts)fromPartsOrToParts;
                if (fromParts != null && !fromParts.getChildren().isEmpty()) {
                    for (FromPart fromPart : fromParts.getChildren()) {
                        if (fromPart.getPart() == null || !fromPart.getPart().equals(part)) continue;
                        var = fromPart.getToVariable();
                        break;
                    }
                }
            } else {
                ToParts toParts = (ToParts)fromPartsOrToParts;
                if (toParts != null && !toParts.getChildren().isEmpty()) {
                    for (ToPart toPart : toParts.getChildren()) {
                        if (toPart.getPart() == null || !toPart.getPart().equals(part)) continue;
                        var = toPart.getFromVariable();
                        break;
                    }
                }
            }
            if (var != null) {
                text.setText(var.getName());
            } else {
                text.setText("");
            }
            Button button = null;
            if (!(model instanceof OnEvent)) {
                text.setEditable(false);
                button = this.fWidgetFactory.createButton((Composite)refGroup, "", 0x1000404);
                data = new FlatFormData();
                data.right = new FlatFormAttachment(100, -5);
                data.top = new FlatFormAttachment((Control)text, 2, 128);
                data.bottom = new FlatFormAttachment((Control)text, -2, 1024);
                button.setLayoutData((Object)data);
            }
            data = new FlatFormData();
            data.top = isFirst ? new FlatFormAttachment(0, 4) : new FlatFormAttachment(ref, 4);
            data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth(ref, 157));
            data.right = button == null ? new FlatFormAttachment(100, -5) : new FlatFormAttachment((Control)button, -5);
            text.setLayoutData((Object)data);
            ref = new CLabel((Composite)refGroup, 16384);
            ref.setText(labelProvider.getText((Object)part));
            ref.setImage(labelProvider.getImage((Object)part));
            ref.setBackground(refGroup.getBackground());
            data = new FlatFormData();
            data.left = new FlatFormAttachment(0, 5);
            data.right = new FlatFormAttachment((Control)text, -5);
            data.top = new FlatFormAttachment((Control)text, 0, 0x1000000);
            ref.setLayoutData((Object)data);
            RunnableProposal proposal1 = new RunnableProposal(){

                @Override
                public String getLabel() {
                    return "Create global Variable";
                }

                @Override
                public void run() {
                    InvokeVariableSection.this.createVariableForPartMapping((EObject)BPELUtils.getProcess((Object)model), model, part, isFromParts);
                }
            };
            RunnableProposal proposal2 = new RunnableProposal(){

                @Override
                public String getLabel() {
                    return "Create local Variable";
                }

                @Override
                public void run() {
                    InvokeVariableSection.this.createVariableForPartMapping(model, model, part, isFromParts);
                }
            };
            RunnableProposal proposal3 = new RunnableProposal(){

                @Override
                public String getLabel() {
                    return "Clear Variable";
                }

                @Override
                public void run() {
                    AutoUndoCommand cmd = null;
                    cmd = isFromParts ? new AddFromPartCommand(model, null, part) : new AddToPartCommand(model, null, part);
                    InvokeVariableSection.this.getCommandFramework().execute((Command)cmd);
                }
            };
            VariableFilter filter = new VariableFilter();
            if (part.getElementDeclaration() != null) {
                filter.setType(part.getElementDeclaration());
            } else if (part.getTypeDefinition() != null) {
                filter.setType(part.getTypeDefinition());
            }
            VariableContentProvider provider = new VariableContentProvider();
            ModelContentProposalProvider proposalProvider = new ModelContentProposalProvider(new ModelContentProposalProvider.ValueProvider(){

                @Override
                public Object value() {
                    return InvokeVariableSection.this.getInput();
                }
            }, provider, filter);
            proposalProvider.addProposalToEnd(new Separator());
            proposalProvider.addProposalToEnd(proposal1);
            proposalProvider.addProposalToEnd(proposal2);
            proposalProvider.addProposalToEnd(proposal3);
            final FieldAssistAdapter contentAssist = new FieldAssistAdapter((Control)text, this.fTextContentAdapter, (IContentProposalProvider)proposalProvider, null, null, true);
            contentAssist.setLabelProvider(labelProvider);
            contentAssist.setPopupSize(new Point(300, 100));
            contentAssist.setFilterStyle(3);
            contentAssist.setProposalAcceptanceStyle(2);
            contentAssist.addContentProposalListener((IContentProposalListener)proposal1);
            contentAssist.addContentProposalListener((IContentProposalListener)proposal2);
            contentAssist.addContentProposalListener((IContentProposalListener)proposal3);
            contentAssist.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal proposal) {
                    if (proposal.getContent() == null) {
                        return;
                    }
                    Variable variable = null;
                    try {
                        variable = (Variable)((Adapter)proposal).getTarget();
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                    AutoUndoCommand cmd = null;
                    cmd = isFromParts ? new AddFromPartCommand(model, variable, part) : new AddToPartCommand(model, variable, part);
                    InvokeVariableSection.this.getCommandFramework().execute((Command)cmd);
                }
            });
            if (button != null) {
                button.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        contentAssist.openProposals();
                    }
                });
                continue;
            }
            if (!(model instanceof OnEvent)) continue;
            IOngoingChange change = new IOngoingChange(){

                public Command createApplyCommand() {
                    OnEvent onEvent = (OnEvent)model;
                    String s = text.getText();
                    if ("".equals(s)) {
                        s = null;
                    }
                    CompoundCommand ccmd = new CompoundCommand();
                    FromParts fromParts = onEvent.getFromParts();
                    FromPart fromPart = null;
                    Variable variable = null;
                    if (fromParts != null && fromParts.getChildren() != null) {
                        for (FromPart fp : fromParts.getChildren()) {
                            if (!part.equals(fp.getPart())) continue;
                            fromPart = fp;
                        }
                    }
                    if (s != null) {
                        if (fromPart != null) {
                            variable = fromPart.getToVariable();
                        }
                        if (variable == null) {
                            variable = BPELFactory.eINSTANCE.createVariable();
                            variable.setType(part.getTypeDefinition());
                            variable.setXSDElement(part.getElementDeclaration());
                        }
                        variable.setName(s);
                        ccmd.add((Command)new AddFromPartCommand((EObject)onEvent, variable, part));
                    } else {
                        ccmd.add((Command)new AddFromPartCommand((EObject)onEvent, null, part));
                    }
                    return ccmd;
                }

                public String getLabel() {
                    return IBPELUIConstants.CMD_SELECT_VARIABLE;
                }

                public void restoreOldState() {
                    InvokeVariableSection.this.updatePartMappingWidgets();
                }
            };
            ChangeTracker onEventVariableTracker = new ChangeTracker((Control)text, change, this.getCommandFramework());
            onEventVariableTracker.startTracking();
        }
    }

    private void createVariable(EObject ref, String name, int direction) {
        NameDialog nameDialog;
        Variable variable = BPELFactory.eINSTANCE.createVariable();
        if (name == null) {
            name = this.plainLabelWordFor(direction);
        }
        Message messageType = null;
        XSDElementDeclaration elementType = null;
        EObject type = ModelHelper.getVariableType(this.getInput(), direction);
        if (type != null && type instanceof Message && (messageType = (Message)type).getEParts().size() == 1) {
            Part part = (Part)messageType.getEParts().get(0);
            elementType = part.getElementDeclaration();
        }
        if ((nameDialog = new NameDialog(this.inputVariableComposite.getShell(), Messages.VariableSelectorDialog_New_Variable_4, Messages.VariableSelectorDialog_Variable_Name_5, name, BPELUtil.getNCNameValidator())).open() == 1) {
            return;
        }
        variable.setName(nameDialog.getValue());
        if (elementType != null) {
            variable.setXSDElement(elementType);
        } else if (messageType != null) {
            variable.setMessageType(messageType);
        }
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new AddVariableCommand(ref, variable));
        cmd.add((Command)new SetVariableCommand((EObject)this.getInput(), variable, direction));
        this.getCommandFramework().execute((Command)cmd);
    }

    private void createVariableForPartMapping(EObject ref, EObject model, Part part, boolean isFromPart) {
        Variable variable = BPELFactory.eINSTANCE.createVariable();
        if (part.getTypeDefinition() != null) {
            variable.setType(part.getTypeDefinition());
        } else if (part.getElementDeclaration() != null) {
            variable.setXSDElement(part.getElementDeclaration());
        }
        NameDialog nameDialog = new NameDialog(this.inputVariableComposite.getShell(), Messages.VariableSelectorDialog_New_Variable_4, Messages.VariableSelectorDialog_Variable_Name_5, null, BPELUtil.getNCNameValidator());
        if (nameDialog.open() == 1) {
            return;
        }
        variable.setName(nameDialog.getValue());
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new AddVariableCommand(ref, variable));
        if (isFromPart) {
            cmd.add((Command)new AddFromPartCommand(model, variable, part));
        } else {
            cmd.add((Command)new AddToPartCommand(model, variable, part));
        }
        this.getCommandFramework().execute((Command)cmd);
    }

    private void createWidgets(Composite composite) {
        this.parentComposite = composite;
        this.usePartMappingCheckbox = this.fWidgetFactory.createButton(composite, "Use WSDL Message Parts Mapping", 32);
        this.usePartMappingCheckbox.addSelectionListener((SelectionListener)new UsePartMappingCheckboxSelectionListener());
        this.nonPartMappingComposite = this.createFlatFormComposite(composite);
        Composite ref = this.createInputVariableWidgets(null, this.nonPartMappingComposite);
        this.createOutputVariableWidgets(ref, this.nonPartMappingComposite);
        this.partMappingComposite = this.createFlatFormComposite(composite);
        FlatFormData ffd = new FlatFormData();
        ffd.top = new FlatFormAttachment(0, 0);
        ffd.left = new FlatFormAttachment(0, 5);
        this.usePartMappingCheckbox.setLayoutData((Object)ffd);
        ffd = new FlatFormData();
        ffd.top = new FlatFormAttachment((Control)this.usePartMappingCheckbox, 4);
        ffd.left = new FlatFormAttachment(0, 0);
        ffd.right = new FlatFormAttachment(100, 0);
        this.partMappingComposite.setLayoutData((Object)ffd);
        ffd = new FlatFormData();
        ffd.top = new FlatFormAttachment((Control)this.usePartMappingCheckbox, 4);
        ffd.left = new FlatFormAttachment(0, 0);
        ffd.right = new FlatFormAttachment(100, 0);
        this.nonPartMappingComposite.setLayoutData((Object)ffd);
    }

    private void findAndSetOrCreateVariable(String text, int direction) {
        text = text.trim();
        Object model = this.getInput();
        SetVariableCommand cmd = new SetVariableCommand((EObject)this.getInput(), null, direction);
        if (text.length() > 0) {
            Variable variable = (Variable)ModelHelper.findElementByName(ModelHelper.getContainingScope(model), text, Variable.class);
            if (variable == null) {
                this.createVariable((EObject)this.getInput(), text, direction);
                return;
            }
            cmd.setNewValue((EObject)variable);
        }
        this.getCommandFramework().execute((Command)cmd);
    }

    private boolean getDisplayFault() {
        Reply reply;
        Object model = this.getModel();
        return model instanceof Reply && (reply = (Reply)model).getFaultName() != null;
    }

    private boolean isInvoke() {
        return this.getInput() instanceof Invoke;
    }

    private boolean isReply() {
        return this.getInput() instanceof Reply;
    }

    private boolean isReceive() {
        return this.getInput() instanceof Receive || this.getInput() instanceof OnMessage || this.getInput() instanceof OnEvent;
    }

    private String plainLabelWordFor(int direction) {
        if (this.isInvoke()) {
            return direction == 0 || direction == 4 ? Messages.InvokeImplDetails_Request_3_Plain : Messages.InvokeImplDetails_Response_4_Plain;
        }
        return direction == 0 || direction == 4 ? Messages.InvokeImplDetails_Response_4_Plain : Messages.InvokeImplDetails_Request_3_Plain;
    }

    @Override
    public void refresh() {
        super.refresh();
        boolean showPartMappingComposite = this.usePartMappingCheckbox.getSelection();
        this.updateWidgets(showPartMappingComposite);
        if (showPartMappingComposite) {
            this.updatePartMappingWidgets();
        } else {
            this.updateInputVariableWidgets();
            this.updateOutputVariableWidgets();
        }
    }

    private boolean shouldUsePartMapping(EObject model) {
        boolean shouldUsePartMapping = false;
        if (model instanceof Reply || model instanceof Invoke) {
            shouldUsePartMapping = true;
            if (ModelHelper.getVariable(model, 0) != null) {
                return false;
            }
        }
        if (model instanceof Receive || model instanceof Invoke || model instanceof OnMessage || model instanceof OnEvent) {
            shouldUsePartMapping = true;
            if (ModelHelper.getVariable(model, 1) != null) {
                return false;
            }
        }
        return shouldUsePartMapping;
    }

    private void updateInputVariableWidgets() {
        this.inputVariableComposite.setVisible(!this.isReply());
        if (this.getInput() instanceof OnEvent) {
            this.inputVariableButton.setVisible(false);
        }
        if (this.isReply()) {
            return;
        }
        if (this.isInvoke()) {
            this.inputVariableLabel.setText(Messages.InvokeImplSection_22);
        } else {
            this.inputVariableLabel.setText(Messages.InvokeImplSection_23);
        }
        Variable inputVar = ModelHelper.getVariable(this.getInput(), this.isInvoke() ? 0 : 1);
        if (inputVar != null) {
            this.inputVariableText.setText(inputVar.getName());
        } else {
            this.inputVariableText.setText("");
        }
        this.fInputVariableFilter.clear();
        EObject type = ModelHelper.getVariableType(this.getInput(), this.isInvoke() ? 0 : 1);
        if (type != null && type instanceof Message) {
            this.fInputVariableFilter.setType((Message)type);
        }
    }

    private void updateOutputVariableWidgets() {
        this.outputVariableComposite.setVisible(!this.isReceive());
        if (this.isReceive()) {
            return;
        }
        if (this.isInvoke()) {
            this.outputVariableLabel.setText(Messages.InvokeImplSection_13);
        } else {
            this.outputVariableLabel.setText(Messages.InvokeImplSection_23);
        }
        Variable outputVar = ModelHelper.getVariable(this.getInput(), this.isInvoke() ? 1 : 0);
        if (outputVar != null) {
            this.outputVariableText.setText(outputVar.getName());
        } else {
            this.outputVariableText.setText("");
        }
        this.fOutputVariableFilter.clear();
        EObject type = ModelHelper.getVariableType(this.getInput(), this.isInvoke() ? 1 : 0);
        if (type != null && type instanceof Message) {
            this.fOutputVariableFilter.setType((Message)type);
        }
    }

    private void updatePartMappingWidgets() {
        ModelLabelProvider labelProvider = new ModelLabelProvider();
        Object model = this.getModel();
        boolean showInputs = ModelHelper.isMessageActivity(model, this.isInvoke() ? 0 : 1);
        boolean showFaults = this.getDisplayFault();
        boolean showOutputs = !showFaults && ModelHelper.isMessageActivity(model, this.isInvoke() ? 1 : 0);
        Operation operation = ModelHelper.getOperation(model);
        if (operation != null && !operation.eIsProxy()) {
            ToParts toParts;
            FlatFormData data;
            String faultName;
            this.usePartMappingCheckbox.setEnabled(true);
            List<Object> inputParts = Collections.emptyList();
            if (showInputs) {
                inputParts = PartMappingUtil.getPartsForPartMapping(operation, 5, null);
            }
            List<Object> outputParts = Collections.emptyList();
            if (showOutputs) {
                outputParts = PartMappingUtil.getPartsForPartMapping(operation, 8, null);
            }
            List<Part> faultParts = Collections.emptyList();
            if (showFaults && (faultName = ModelHelper.getFaultName(model)) != null) {
                faultParts = PartMappingUtil.getPartsForPartMapping(operation, 3, faultName);
            }
            Group refGroup = null;
            if (inputParts.size() > 0) {
                FromParts fromParts = ModelHelper.getFromParts(model);
                data = new FlatFormData();
                data.left = new FlatFormAttachment(0, 5);
                data.right = new FlatFormAttachment(100, -5);
                data.top = refGroup != null ? new FlatFormAttachment(refGroup, 4) : new FlatFormAttachment(0, 4);
                refGroup = this.fWidgetFactory.createGroup(this.partMappingComposite, "Input(s)");
                refGroup.setLayoutData((Object)data);
                refGroup.setLayout((Layout)new FlatFormLayout());
                this.createPartMappingRows(labelProvider, (EObject)model, (List<Part>)inputParts, refGroup, (EObject)fromParts, true);
            }
            if (outputParts.size() > 0) {
                toParts = ModelHelper.getToParts(model);
                data = new FlatFormData();
                data.left = new FlatFormAttachment(0, 5);
                data.right = new FlatFormAttachment(100, -5);
                data.top = refGroup != null ? new FlatFormAttachment(refGroup, 4) : new FlatFormAttachment(0, 4);
                refGroup = this.fWidgetFactory.createGroup(this.partMappingComposite, "Output(s)");
                refGroup.setLayoutData((Object)data);
                refGroup.setLayout((Layout)new FlatFormLayout());
                this.createPartMappingRows(labelProvider, (EObject)model, (List<Part>)outputParts, refGroup, (EObject)toParts, false);
            }
            if (faultParts.size() > 0) {
                toParts = ModelHelper.getToParts(model);
                data = new FlatFormData();
                data.left = new FlatFormAttachment(0, 5);
                data.right = new FlatFormAttachment(100, -5);
                data.top = refGroup != null ? new FlatFormAttachment(refGroup, 4) : new FlatFormAttachment(0, 4);
                refGroup = this.fWidgetFactory.createGroup(this.partMappingComposite, "Fault(s)");
                refGroup.setLayoutData((Object)data);
                refGroup.setLayout((Layout)new FlatFormLayout());
                this.createPartMappingRows(labelProvider, (EObject)model, faultParts, refGroup, (EObject)toParts, false);
            }
            this.parentComposite.layout(true);
        } else {
            this.usePartMappingCheckbox.setEnabled(false);
        }
    }

    private void updateWidgets(boolean showPartMappingComposite) {
        if (this.partMappingComposite != null) {
            this.partMappingComposite.dispose();
        }
        this.partMappingComposite = this.createFlatFormComposite(this.parentComposite);
        FlatFormData ffd = new FlatFormData();
        ffd.top = new FlatFormAttachment((Control)this.usePartMappingCheckbox, 4);
        ffd.left = new FlatFormAttachment(0, 0);
        ffd.right = new FlatFormAttachment(100, 0);
        this.partMappingComposite.setLayoutData((Object)ffd);
        if (!showPartMappingComposite) {
            this.usePartMappingCheckbox.setSelection(false);
            this.partMappingComposite.setVisible(false);
            this.nonPartMappingComposite.setVisible(true);
        } else {
            this.usePartMappingCheckbox.setSelection(true);
            this.partMappingComposite.setVisible(true);
            this.nonPartMappingComposite.setVisible(false);
        }
    }

    private class UsePartMappingCheckboxSelectionListener
    implements SelectionListener {
        private UsePartMappingCheckboxSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CompoundCommand ccmd = new CompoundCommand();
            if (ModelHelper.isMessageActivity(InvokeVariableSection.this.getModel(), 1)) {
                ccmd.add((Command)new SetVariableCommand((EObject)InvokeVariableSection.this.getModel(), null, 1));
            }
            if (ModelHelper.isMessageActivity(InvokeVariableSection.this.getModel(), 0)) {
                ccmd.add((Command)new SetVariableCommand((EObject)InvokeVariableSection.this.getModel(), null, 0));
            }
            ccmd.add((Command)new AutoUndoCommand((EObject)InvokeVariableSection.this.getInput()){

                @Override
                public void doExecute() {
                    try {
                        ModelHelper.setToParts(InvokeVariableSection.this.getInput(), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    try {
                        ModelHelper.setFromParts(InvokeVariableSection.this.getInput(), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            });
            InvokeVariableSection.this.getCommandFramework().execute((Command)ccmd);
        }
    }
}

