/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.persistance;

import java.io.IOException;
import java.util.Optional;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracePersistenceAdapter
implements org.eclipse.capra.core.adapters.TracePersistenceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(TracePersistenceAdapter.class);
    private static final String DEFAULT_PROJECT_NAME = "__WorkspaceTraceModels";
    private static final String DEFAULT_TRACE_MODEL_NAME = "traceModel.xmi";
    private static final String DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME = "artifactWrappers.xmi";
    private static final URI DEFAULT_TRACE_MODEL_URI = URI.createPlatformResourceURI((String)"__WorkspaceTraceModels/traceModel.xmi", (boolean)true);
    private static final URI DEFAULT_ARTIFACT_MODEL_URI = URI.createPlatformResourceURI((String)"__WorkspaceTraceModels/artifactWrappers.xmi", (boolean)true);

    private Optional<EObject> loadModel(ResourceSet resourceSet, String modelName) {
        Resource resource;
        URI uri = URI.createPlatformResourceURI((String)("__WorkspaceTraceModels/" + modelName), (boolean)true);
        Resource resource2 = resource = resourceSet.getResource(uri, false) != null ? resourceSet.getResource(uri, false) : resourceSet.createResource(uri);
        if (!resource.isLoaded()) {
            try {
                resource.load(null);
            }
            catch (IOException e) {
                LOG.error("Could not load trace model", (Throwable)e);
                return Optional.empty();
            }
        }
        try {
            EList contents = (EList)TransactionUtil.runExclusive((TransactionalEditingDomain)EditingDomainHelper.getEditingDomain(), (RunnableWithResult)new RunnableWithResult.Impl<EList<EObject>>(){

                public void run() {
                    this.setResult(resource.getContents());
                }
            });
            return contents.isEmpty() ? Optional.empty() : Optional.of((EObject)contents.get(0));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public EObject getTraceModel(ResourceSet resourceSet) {
        TraceMetaModelAdapter adapter = (TraceMetaModelAdapter)ExtensionPointHelper.getTraceMetamodelAdapter().orElseThrow();
        return this.loadModel(resourceSet, DEFAULT_TRACE_MODEL_NAME).orElse(adapter.createModel());
    }

    private IProject ensureProjectExists(String defaultProjectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(defaultProjectName);
        if (!project.exists()) {
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    public void saveTracesAndArtifacts(final EObject traceModel, final EObject artifactModel) {
        try {
            Resource resourceForArtifacts;
            ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
            this.ensureProjectExists(DEFAULT_PROJECT_NAME);
            final Resource resourceForTraces = resourceSet.getResource(DEFAULT_TRACE_MODEL_URI, false) != null ? resourceSet.getResource(DEFAULT_TRACE_MODEL_URI, false) : resourceSet.createResource(DEFAULT_TRACE_MODEL_URI);
            Resource resource = resourceForArtifacts = resourceSet.getResource(DEFAULT_ARTIFACT_MODEL_URI, false) != null ? resourceSet.getResource(DEFAULT_ARTIFACT_MODEL_URI, false) : resourceSet.createResource(DEFAULT_ARTIFACT_MODEL_URI);
            if (resourceForTraces.getContents().isEmpty() || resourceForTraces.getContents().isEmpty()) {
                TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
                RecordingCommand cmd = new RecordingCommand(editingDomain, "Save Trace Model"){

                    protected void doExecute() {
                        if (resourceForTraces.getContents().isEmpty()) {
                            resourceForTraces.getContents().add((Object)traceModel);
                        }
                        if (resourceForArtifacts.getContents().isEmpty()) {
                            resourceForArtifacts.getContents().add((Object)artifactModel);
                        }
                    }
                };
                try {
                    ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
                }
                catch (RollbackException rbe) {
                    LOG.warn("Saving trace model has been rolled back.", (Throwable)rbe);
                }
            }
            resourceForArtifacts.save(null);
            resourceForTraces.save(null);
        }
        catch (Exception e) {
            LOG.error("Unable to save trace model!", (Throwable)e);
        }
    }

    public EObject getArtifactWrappers(ResourceSet resourceSet) {
        ArtifactMetaModelAdapter adapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().orElseThrow();
        return this.loadModel(resourceSet, DEFAULT_ARTIFACT_WRAPPER_MODEL_NAME).orElse(adapter.createModel());
    }
}

