/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import java.util.LinkedHashMap;
import java.util.List;
import org.cloudfoundry.client.lib.domain.ApplicationStats;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.BehaviourOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.client.CloudRefreshEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public class UpdateAllOperation
extends BehaviourOperation {
    public UpdateAllOperation(CloudFoundryServerBehaviour behaviour) {
        super(behaviour, null);
    }

    @Override
    public void run(IProgressMonitor monitor) throws CoreException {
        CloudFoundryServer cloudServer = this.getBehaviour().getCloudFoundryServer();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        subMonitor.beginTask(NLS.bind((String)Messages.CloudBehaviourOperations_REFRESHING_APPS_AND_SERVICES, (Object)cloudServer.getServer().getId()), 100);
        List<CloudApplication> applications = this.getBehaviour().getApplications((IProgressMonitor)subMonitor.newChild(50));
        LinkedHashMap<String, CloudApplication> deployedApplicationsByName = new LinkedHashMap<String, CloudApplication>();
        LinkedHashMap<String, ApplicationStats> stats = new LinkedHashMap<String, ApplicationStats>();
        for (CloudApplication application : applications) {
            ApplicationStats sts = this.getBehaviour().getApplicationStats(application.getName(), (IProgressMonitor)subMonitor);
            stats.put(application.getName(), sts);
            deployedApplicationsByName.put(application.getName(), application);
        }
        cloudServer.addAndDeleteModules(deployedApplicationsByName, stats);
        cloudServer.updateModulesState(new int[]{1});
        IModule[] iModuleArray = cloudServer.getServer().getModules();
        int n = iModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule module = iModuleArray[n2];
            CloudFoundryApplicationModule appModule = cloudServer.getExistingCloudModule(module);
            if (appModule != null) {
                appModule.setStatus(null);
                appModule.validateDeploymentInfo();
            }
            ++n2;
        }
        List<CloudService> services = this.getBehaviour().getServices((IProgressMonitor)subMonitor.newChild(20));
        ServerEventHandler.getDefault().fireServerEvent(new CloudRefreshEvent(this.getBehaviour().getCloudFoundryServer(), this.getModule(), 400, services));
        subMonitor.worked(20);
    }
}

