/*******************************************************************************
 * Copyright (c) 2012, 2014 Pivotal Software, Inc. 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Apache License v2.0 which accompanies this distribution. 
 * 
 * The Eclipse Public License is available at 
 * 
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * and the Apache License v2.0 is available at 
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You may elect to redistribute this code under either of these licenses.
 *  
 *  Contributors:
 *     Pivotal Software, Inc. - initial API and implementation
 ********************************************************************************/
package org.eclipse.cft.server.ui.internal.wizards;

import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudSpacesDelegate;
import org.eclipse.cft.server.ui.internal.CloudSpacesSelectionPart;
import org.eclipse.cft.server.ui.internal.ValidationEventHandler;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

/**
 * This is the cloud space selection page in the Cloud Foundry New Server
 * wizard.
 */
public class CloudFoundrySpacesWizardFragment extends WizardFragment {

	private final CloudSpacesDelegate spacesDelegate;

	private final CloudFoundryServer cloudServer;

	private CloudSpacesSelectionPart spacesPart;

	private ValidationEventHandler validationEventHandler;

	private WizardFragmentStatusHandler statusHandler;

	public CloudFoundrySpacesWizardFragment(CloudFoundryServer cloudServer, CloudSpacesDelegate spacesDelegate,
			ValidationEventHandler validationHandler) {
		this.validationEventHandler = validationHandler;
		this.cloudServer = cloudServer;
		this.spacesDelegate = spacesDelegate;
	}

	@Override
	public Composite createComposite(Composite parent, IWizardHandle wizardHandle) {
		// status handler that informs the wizard fragment when to display
		// messages and errors.
		statusHandler = new WizardFragmentStatusHandler(wizardHandle);

		// Add the status handler to the validation event handler so that
		// the wizard can be notified when validation operations are completed,
		// or be notified of any other errors generated by other components
		// firing
		// events to the validation handler.
		validationEventHandler.addStatusHandler(statusHandler);

		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		spacesPart = new CloudSpacesSelectionPart(spacesDelegate, cloudServer, wizardHandle);

		// Register the validation handler into the spaces selection part so
		// that validation can
		// be performed when cloud space selection changes.
		spacesPart.addPartChangeListener(validationEventHandler);

		spacesPart.createPart(composite);

		return composite;
	}

	public boolean isComplete() {
		return validationEventHandler.isOK();
	}

	@Override
	public boolean hasComposite() {
		return true;
	}

	public void enter() {

		if (spacesPart != null) {
			spacesPart.setInput();
		}

		super.enter();
	}
}
