/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-03-01 06:57:43 +0100 (Sat, 01 Mar 2014) $
//  number=$Revision: 9852 $
//  type=he

/**
 * Localized names for the "he" locale.
 */
public class LocalizedNamesImpl_he extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IL",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "UG",
        "UZ",
        "AT",
        "AU",
        "QO",
        "UA",
        "UY",
        "AZ",
        "AE",
        "IT",
        "AX",
        "BS",
        "BV",
        "VI",
        "VG",
        "HM",
        "WF",
        "TC",
        "CX",
        "UM",
        "MP",
        "MH",
        "NF",
        "SC",
        "FO",
        "FK",
        "PN",
        "CK",
        "CC",
        "KY",
        "SB",
        "ID",
        "IS",
        "IR",
        "IE",
        "AL",
        "DZ",
        "SV",
        "AO",
        "AI",
        "AD",
        "AQ",
        "AG",
        "AN",
        "EE",
        "AF",
        "EC",
        "AR",
        "AW",
        "ER",
        "AM",
        "US",
        "ET",
        "BT",
        "BW",
        "BG",
        "BO",
        "BA",
        "BI",
        "BF",
        "BH",
        "BY",
        "BE",
        "BZ",
        "BD",
        "BJ",
        "BB",
        "BN",
        "BR",
        "BM",
        "GS",
        "DJ",
        "JM",
        "JE",
        "GA",
        "GE",
        "GH",
        "GT",
        "GU",
        "GP",
        "GY",
        "GF",
        "GI",
        "GN",
        "GW",
        "GQ",
        "GM",
        "GL",
        "DE",
        "GD",
        "GG",
        "DM",
        "DG",
        "DK",
        "ZA",
        "SS",
        "AC",
        "EU",
        "HT",
        "MV",
        "IC",
        "BQ",
        "IM",
        "CP",
        "IN",
        "VA",
        "NL",
        "HK",
        "HU",
        "HN",
        "GB",
        "DO",
        "CF",
        "PS",
        "VN",
        "VU",
        "VE",
        "ZW",
        "ZM",
        "CI",
        "TJ",
        "TV",
        "TG",
        "TO",
        "TK",
        "TR",
        "TM",
        "TW",
        "TL",
        "TZ",
        "IO",
        "TF",
        "TT",
        "TA",
        "GR",
        "JP",
        "JO",
        "IL",
        "KW",
        "CV",
        "LA",
        "LB",
        "LY",
        "LU",
        "LV",
        "LR",
        "LT",
        "LI",
        "LS",
        "MR",
        "MU",
        "YT",
        "ML",
        "MG",
        "MZ",
        "MD",
        "MN",
        "ME",
        "MS",
        "MC",
        "MM",
        "FM",
        "MW",
        "MY",
        "MT",
        "EG",
        "MO",
        "MK",
        "MX",
        "MA",
        "MQ",
        "NR",
        "NO",
        "NG",
        "NU",
        "NZ",
        "NE",
        "NI",
        "NA",
        "NP",
        "EA",
        "ST",
        "EH",
        "SD",
        "SZ",
        "SJ",
        "SO",
        "SY",
        "SR",
        "SL",
        "CN",
        "SG",
        "SX",
        "SI",
        "SK",
        "WS",
        "AS",
        "SN",
        "BL",
        "SH",
        "VC",
        "LC",
        "MF",
        "PM",
        "KN",
        "SM",
        "ES",
        "RS",
        "LK",
        "OM",
        "IQ",
        "SA",
        "PW",
        "PL",
        "PF",
        "PT",
        "PR",
        "FJ",
        "PH",
        "FI",
        "PA",
        "PG",
        "PK",
        "PY",
        "PE",
        "TD",
        "CL",
        "CZ",
        "FR",
        "CU",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CW",
        "KR",
        "KP",
        "KZ",
        "QA",
        "KG",
        "KI",
        "NC",
        "KH",
        "CM",
        "CA",
        "KE",
        "CY",
        "HR",
        "RE",
        "RW",
        "RO",
        "RU",
        "SE",
        "CH",
        "TH",
        "TN",
        "YE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "העולם");
    namesMap.put("002", "אפריקה");
    namesMap.put("003", "צפון אמריקה");
    namesMap.put("005", "דרום אמריקה");
    namesMap.put("009", "אוקיאניה");
    namesMap.put("011", "מערב אפריקה");
    namesMap.put("013", "מרכז אמריקה");
    namesMap.put("014", "מזרח אפריקה");
    namesMap.put("015", "צפון אפריקה");
    namesMap.put("017", "מרכז אפריקה");
    namesMap.put("018", "דרום יבשת אפריקה");
    namesMap.put("019", "אמריקה");
    namesMap.put("021", "אמריקה הצפונית");
    namesMap.put("029", "קריביים");
    namesMap.put("030", "מזרח אסיה");
    namesMap.put("034", "דרום אסיה");
    namesMap.put("035", "דרום־מזרח אסיה");
    namesMap.put("039", "דרום אירופה");
    namesMap.put("053", "אוסטרלאסיה");
    namesMap.put("054", "מלנזיה");
    namesMap.put("057", "אזור מיקרונזיה");
    namesMap.put("061", "פולינזיה");
    namesMap.put("142", "אסיה");
    namesMap.put("143", "מרכז אסיה");
    namesMap.put("145", "מערב אסיה");
    namesMap.put("150", "אירופה");
    namesMap.put("151", "מזרח אירופה");
    namesMap.put("154", "צפון אירופה");
    namesMap.put("155", "מערב אירופה");
    namesMap.put("419", "אמריקה הלטינית");
    namesMap.put("AC", "האי אסנשן");
    namesMap.put("AD", "אנדורה");
    namesMap.put("AE", "איחוד האמירויות הערביות");
    namesMap.put("AF", "אפגניסטן");
    namesMap.put("AG", "אנטיגואה וברבודה");
    namesMap.put("AI", "אנגילה");
    namesMap.put("AL", "אלבניה");
    namesMap.put("AM", "ארמניה");
    namesMap.put("AN", "אנטילים הולנדיים");
    namesMap.put("AO", "אנגולה");
    namesMap.put("AQ", "אנטארקטיקה");
    namesMap.put("AR", "ארגנטינה");
    namesMap.put("AS", "סמואה האמריקנית");
    namesMap.put("AT", "אוסטריה");
    namesMap.put("AU", "אוסטרליה");
    namesMap.put("AW", "ארובה");
    namesMap.put("AX", "איי אולנד");
    namesMap.put("AZ", "אזרבייג׳ן");
    namesMap.put("BA", "בוסניה והרצגובינה");
    namesMap.put("BB", "ברבדוס");
    namesMap.put("BD", "בנגלדש");
    namesMap.put("BE", "בלגיה");
    namesMap.put("BF", "בורקינה פאסו");
    namesMap.put("BG", "בולגריה");
    namesMap.put("BH", "בחריין");
    namesMap.put("BI", "בורונדי");
    namesMap.put("BJ", "בנין");
    namesMap.put("BL", "סנט ברתולומיאו");
    namesMap.put("BM", "ברמודה");
    namesMap.put("BN", "ברוניי");
    namesMap.put("BO", "בוליביה");
    namesMap.put("BQ", "האיים הקריביים ההולנדיים");
    namesMap.put("BR", "ברזיל");
    namesMap.put("BS", "איי בהאמה");
    namesMap.put("BT", "בהוטן");
    namesMap.put("BV", "איי בובה");
    namesMap.put("BW", "בוטסוואנה");
    namesMap.put("BY", "בלארוס");
    namesMap.put("BZ", "בליז");
    namesMap.put("CA", "קנדה");
    namesMap.put("CC", "איי קוקס (קילינג)");
    namesMap.put("CD", "קונגו - קינשאסה");
    namesMap.put("CF", "הרפובליקה של מרכז אפריקה");
    namesMap.put("CG", "קונגו - ברזאויל");
    namesMap.put("CH", "שווייץ");
    namesMap.put("CI", "חוף השנהב");
    namesMap.put("CK", "איי קוק");
    namesMap.put("CL", "צ׳ילה");
    namesMap.put("CM", "קמרון");
    namesMap.put("CN", "סין");
    namesMap.put("CO", "קולומביה");
    namesMap.put("CP", "האי קליפרטון");
    namesMap.put("CR", "קוסטה ריקה");
    namesMap.put("CU", "קובה");
    namesMap.put("CV", "כף ורדה");
    namesMap.put("CW", "קוראסאו");
    namesMap.put("CX", "איי כריסטמס");
    namesMap.put("CY", "קפריסין");
    namesMap.put("CZ", "צ׳כיה");
    namesMap.put("DE", "גרמניה");
    namesMap.put("DG", "דייגו גרסיה");
    namesMap.put("DJ", "ג׳יבוטי");
    namesMap.put("DK", "דנמרק");
    namesMap.put("DM", "דומיניקה");
    namesMap.put("DO", "הרפובליקה הדומיניקנית");
    namesMap.put("DZ", "אלג׳יריה");
    namesMap.put("EA", "סאוטה ומלייה");
    namesMap.put("EC", "אקוודור");
    namesMap.put("EE", "אסטוניה");
    namesMap.put("EG", "מצרים");
    namesMap.put("EH", "סהרה המערבית");
    namesMap.put("ER", "אריתריאה");
    namesMap.put("ES", "ספרד");
    namesMap.put("ET", "אתיופיה");
    namesMap.put("EU", "האיחוד האירופי");
    namesMap.put("FI", "פינלנד");
    namesMap.put("FJ", "פיג׳י");
    namesMap.put("FK", "איי פוקלנד");
    namesMap.put("FM", "מיקרונזיה");
    namesMap.put("FO", "איי פארו");
    namesMap.put("FR", "צרפת");
    namesMap.put("GA", "גאבון");
    namesMap.put("GB", "הממלכה המאוחדת");
    namesMap.put("GD", "גרנדה");
    namesMap.put("GE", "גאורגיה");
    namesMap.put("GF", "גיאנה הצרפתית");
    namesMap.put("GG", "גרנסי");
    namesMap.put("GH", "גאנה");
    namesMap.put("GI", "גיברלטר");
    namesMap.put("GL", "גרינלנד");
    namesMap.put("GM", "גמביה");
    namesMap.put("GN", "גיניאה");
    namesMap.put("GP", "גוואדלופ");
    namesMap.put("GQ", "גיניאה המשוונית");
    namesMap.put("GR", "יוון");
    namesMap.put("GS", "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים");
    namesMap.put("GT", "גואטמלה");
    namesMap.put("GU", "גואם");
    namesMap.put("GW", "גיניאה-ביסאו");
    namesMap.put("GY", "גיאנה");
    namesMap.put("HK", "הונג קונג - מחוז מנהלי מיוחד של סין");
    namesMap.put("HM", "איי הרד ואיי מקדונלנד");
    namesMap.put("HN", "הונדורס");
    namesMap.put("HR", "קרואטיה");
    namesMap.put("HT", "האיטי");
    namesMap.put("HU", "הונגריה");
    namesMap.put("IC", "האיים הקנריים");
    namesMap.put("ID", "אינדונזיה");
    namesMap.put("IE", "אירלנד");
    namesMap.put("IL", "ישראל");
    namesMap.put("IM", "האי מאן");
    namesMap.put("IN", "הודו");
    namesMap.put("IO", "טריטוריה בריטית באוקיאנוס ההודי");
    namesMap.put("IQ", "עיראק");
    namesMap.put("IR", "איראן");
    namesMap.put("IS", "איסלנד");
    namesMap.put("IT", "איטליה");
    namesMap.put("JE", "ג׳רסי");
    namesMap.put("JM", "ג׳מייקה");
    namesMap.put("JO", "ירדן");
    namesMap.put("JP", "יפן");
    namesMap.put("KE", "קניה");
    namesMap.put("KG", "קירגיזסטן");
    namesMap.put("KH", "קמבודיה");
    namesMap.put("KI", "קיריבאטי");
    namesMap.put("KM", "קומורוס");
    namesMap.put("KN", "סנט קיטס ונוויס");
    namesMap.put("KP", "קוריאה הצפונית");
    namesMap.put("KR", "קוריאה הדרומית");
    namesMap.put("KW", "כווית");
    namesMap.put("KY", "איי קיימן");
    namesMap.put("KZ", "קזחסטן");
    namesMap.put("LA", "לאוס");
    namesMap.put("LB", "לבנון");
    namesMap.put("LC", "סנט לוסיה");
    namesMap.put("LI", "ליכטנשטיין");
    namesMap.put("LK", "סרי לנקה");
    namesMap.put("LR", "ליבריה");
    namesMap.put("LS", "לסוטו");
    namesMap.put("LT", "ליטא");
    namesMap.put("LU", "לוקסמבורג");
    namesMap.put("LV", "לטביה");
    namesMap.put("LY", "לוב");
    namesMap.put("MA", "מרוקו");
    namesMap.put("MC", "מונקו");
    namesMap.put("MD", "מולדובה");
    namesMap.put("ME", "מונטנגרו");
    namesMap.put("MF", "סנט מרטין");
    namesMap.put("MG", "מדגסקר");
    namesMap.put("MH", "איי מרשל");
    namesMap.put("MK", "מקדוניה");
    namesMap.put("ML", "מאלי");
    namesMap.put("MM", "מיאנמאר (בורמה)‎");
    namesMap.put("MN", "מונגוליה");
    namesMap.put("MO", "מקאו - מחוז מנהלי מיוחד של סין");
    namesMap.put("MP", "איי מריאנה הצפוניים");
    namesMap.put("MQ", "מרטיניק");
    namesMap.put("MR", "מאוריטניה");
    namesMap.put("MS", "מונסראט");
    namesMap.put("MT", "מלטה");
    namesMap.put("MU", "מאוריציוס");
    namesMap.put("MV", "האיים המלדיביים");
    namesMap.put("MW", "מלאווי");
    namesMap.put("MX", "מקסיקו");
    namesMap.put("MY", "מלזיה");
    namesMap.put("MZ", "מוזמביק");
    namesMap.put("NA", "נמיביה");
    namesMap.put("NC", "קלדוניה החדשה");
    namesMap.put("NE", "ניז׳ר");
    namesMap.put("NF", "איי נורפוק");
    namesMap.put("NG", "ניגריה");
    namesMap.put("NI", "ניקרגואה");
    namesMap.put("NL", "הולנד");
    namesMap.put("NO", "נורווגיה");
    namesMap.put("NP", "נפאל");
    namesMap.put("NR", "נאורו");
    namesMap.put("NU", "ניווה");
    namesMap.put("NZ", "ניו זילנד");
    namesMap.put("OM", "עומאן");
    namesMap.put("PA", "פנמה");
    namesMap.put("PE", "פרו");
    namesMap.put("PF", "פולינזיה הצרפתית");
    namesMap.put("PG", "פפואה גיניאה החדשה");
    namesMap.put("PH", "פיליפינים");
    namesMap.put("PK", "פקיסטן");
    namesMap.put("PL", "פולין");
    namesMap.put("PM", "סנט פייר ומיקלון");
    namesMap.put("PN", "איי פיטקרן");
    namesMap.put("PR", "פורטו ריקו");
    namesMap.put("PS", "השטחים הפלסטיניים");
    namesMap.put("PT", "פורטוגל");
    namesMap.put("PW", "פאלאו");
    namesMap.put("PY", "פרגוואי");
    namesMap.put("QA", "קטאר");
    namesMap.put("QO", "אוקיאניה פרושה");
    namesMap.put("RE", "ראוניון");
    namesMap.put("RO", "רומניה");
    namesMap.put("RS", "סרביה");
    namesMap.put("RU", "רוסיה");
    namesMap.put("RW", "רואנדה");
    namesMap.put("SA", "ערב הסעודית");
    namesMap.put("SB", "איי שלמה");
    namesMap.put("SC", "איי סיישל");
    namesMap.put("SD", "סודן");
    namesMap.put("SE", "שוודיה");
    namesMap.put("SG", "סינגפור");
    namesMap.put("SH", "סנט הלנה");
    namesMap.put("SI", "סלובניה");
    namesMap.put("SJ", "סוולבארד ויאן מאיין");
    namesMap.put("SK", "סלובקיה");
    namesMap.put("SL", "סיירה לאונה");
    namesMap.put("SM", "סן מרינו");
    namesMap.put("SN", "סנגל");
    namesMap.put("SO", "סומליה");
    namesMap.put("SR", "סורינם");
    namesMap.put("SS", "דרום סודן");
    namesMap.put("ST", "סאו טומה ופרינסיפה");
    namesMap.put("SV", "אל סלבדור");
    namesMap.put("SX", "סינט מארטן");
    namesMap.put("SY", "סוריה");
    namesMap.put("SZ", "סווזילנד");
    namesMap.put("TA", "טריסטן דה קונה");
    namesMap.put("TC", "איי טורקס וקאיקוס");
    namesMap.put("TD", "צ׳אד");
    namesMap.put("TF", "טריטוריות דרומיות של צרפת");
    namesMap.put("TG", "טוגו");
    namesMap.put("TH", "תאילנד");
    namesMap.put("TJ", "טג׳יקיסטן");
    namesMap.put("TK", "טוקלאו");
    namesMap.put("TL", "טימור לסטה");
    namesMap.put("TM", "טורקמניסטן");
    namesMap.put("TN", "תוניסיה");
    namesMap.put("TO", "טונגה");
    namesMap.put("TR", "טורקיה");
    namesMap.put("TT", "טרינידד וטובגו");
    namesMap.put("TV", "טובלו");
    namesMap.put("TW", "טייוואן");
    namesMap.put("TZ", "טנזניה");
    namesMap.put("UA", "אוקראינה");
    namesMap.put("UG", "אוגנדה");
    namesMap.put("UM", "איים לחוף ארצות הברית");
    namesMap.put("US", "ארצות הברית");
    namesMap.put("UY", "אורוגוואי");
    namesMap.put("UZ", "אוזבקיסטן");
    namesMap.put("VA", "הוותיקן");
    namesMap.put("VC", "סנט וינסנט והגרנדינים");
    namesMap.put("VE", "ונצואלה");
    namesMap.put("VG", "איי הבתולה הבריטיים");
    namesMap.put("VI", "איי הבתולה האמריקניים");
    namesMap.put("VN", "וייטנאם");
    namesMap.put("VU", "ונואטו");
    namesMap.put("WF", "איי ווליס ופוטונה");
    namesMap.put("WS", "סמואה");
    namesMap.put("XK", "קוסובו");
    namesMap.put("YE", "תימן");
    namesMap.put("YT", "מאיוט");
    namesMap.put("ZA", "דרום אפריקה");
    namesMap.put("ZM", "זמביה");
    namesMap.put("ZW", "זימבאבווה");
    namesMap.put("ZZ", "אזור לא ידוע");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "העולם",
        "002": "אפריקה",
        "003": "צפון אמריקה",
        "005": "דרום אמריקה",
        "009": "אוקיאניה",
        "011": "מערב אפריקה",
        "013": "מרכז אמריקה",
        "014": "מזרח אפריקה",
        "015": "צפון אפריקה",
        "017": "מרכז אפריקה",
        "018": "דרום יבשת אפריקה",
        "019": "אמריקה",
        "021": "אמריקה הצפונית",
        "029": "קריביים",
        "030": "מזרח אסיה",
        "034": "דרום אסיה",
        "035": "דרום־מזרח אסיה",
        "039": "דרום אירופה",
        "053": "אוסטרלאסיה",
        "054": "מלנזיה",
        "057": "אזור מיקרונזיה",
        "061": "פולינזיה",
        "142": "אסיה",
        "143": "מרכז אסיה",
        "145": "מערב אסיה",
        "150": "אירופה",
        "151": "מזרח אירופה",
        "154": "צפון אירופה",
        "155": "מערב אירופה",
        "419": "אמריקה הלטינית",
        "AC": "האי אסנשן",
        "AD": "אנדורה",
        "AE": "איחוד האמירויות הערביות",
        "AF": "אפגניסטן",
        "AG": "אנטיגואה וברבודה",
        "AI": "אנגילה",
        "AL": "אלבניה",
        "AM": "ארמניה",
        "AN": "אנטילים הולנדיים",
        "AO": "אנגולה",
        "AQ": "אנטארקטיקה",
        "AR": "ארגנטינה",
        "AS": "סמואה האמריקנית",
        "AT": "אוסטריה",
        "AU": "אוסטרליה",
        "AW": "ארובה",
        "AX": "איי אולנד",
        "AZ": "אזרבייג׳ן",
        "BA": "בוסניה והרצגובינה",
        "BB": "ברבדוס",
        "BD": "בנגלדש",
        "BE": "בלגיה",
        "BF": "בורקינה פאסו",
        "BG": "בולגריה",
        "BH": "בחריין",
        "BI": "בורונדי",
        "BJ": "בנין",
        "BL": "סנט ברתולומיאו",
        "BM": "ברמודה",
        "BN": "ברוניי",
        "BO": "בוליביה",
        "BQ": "האיים הקריביים ההולנדיים",
        "BR": "ברזיל",
        "BS": "איי בהאמה",
        "BT": "בהוטן",
        "BV": "איי בובה",
        "BW": "בוטסוואנה",
        "BY": "בלארוס",
        "BZ": "בליז",
        "CA": "קנדה",
        "CC": "איי קוקס (קילינג)",
        "CD": "קונגו - קינשאסה",
        "CF": "הרפובליקה של מרכז אפריקה",
        "CG": "קונגו - ברזאויל",
        "CH": "שווייץ",
        "CI": "חוף השנהב",
        "CK": "איי קוק",
        "CL": "צ׳ילה",
        "CM": "קמרון",
        "CN": "סין",
        "CO": "קולומביה",
        "CP": "האי קליפרטון",
        "CR": "קוסטה ריקה",
        "CU": "קובה",
        "CV": "כף ורדה",
        "CW": "קוראסאו",
        "CX": "איי כריסטמס",
        "CY": "קפריסין",
        "CZ": "צ׳כיה",
        "DE": "גרמניה",
        "DG": "דייגו גרסיה",
        "DJ": "ג׳יבוטי",
        "DK": "דנמרק",
        "DM": "דומיניקה",
        "DO": "הרפובליקה הדומיניקנית",
        "DZ": "אלג׳יריה",
        "EA": "סאוטה ומלייה",
        "EC": "אקוודור",
        "EE": "אסטוניה",
        "EG": "מצרים",
        "EH": "סהרה המערבית",
        "ER": "אריתריאה",
        "ES": "ספרד",
        "ET": "אתיופיה",
        "EU": "האיחוד האירופי",
        "FI": "פינלנד",
        "FJ": "פיג׳י",
        "FK": "איי פוקלנד",
        "FM": "מיקרונזיה",
        "FO": "איי פארו",
        "FR": "צרפת",
        "GA": "גאבון",
        "GB": "הממלכה המאוחדת",
        "GD": "גרנדה",
        "GE": "גאורגיה",
        "GF": "גיאנה הצרפתית",
        "GG": "גרנסי",
        "GH": "גאנה",
        "GI": "גיברלטר",
        "GL": "גרינלנד",
        "GM": "גמביה",
        "GN": "גיניאה",
        "GP": "גוואדלופ",
        "GQ": "גיניאה המשוונית",
        "GR": "יוון",
        "GS": "ג׳ורג׳יה הדרומית ואיי סנדוויץ׳ הדרומיים",
        "GT": "גואטמלה",
        "GU": "גואם",
        "GW": "גיניאה-ביסאו",
        "GY": "גיאנה",
        "HK": "הונג קונג - מחוז מנהלי מיוחד של סין",
        "HM": "איי הרד ואיי מקדונלנד",
        "HN": "הונדורס",
        "HR": "קרואטיה",
        "HT": "האיטי",
        "HU": "הונגריה",
        "IC": "האיים הקנריים",
        "ID": "אינדונזיה",
        "IE": "אירלנד",
        "IL": "ישראל",
        "IM": "האי מאן",
        "IN": "הודו",
        "IO": "טריטוריה בריטית באוקיאנוס ההודי",
        "IQ": "עיראק",
        "IR": "איראן",
        "IS": "איסלנד",
        "IT": "איטליה",
        "JE": "ג׳רסי",
        "JM": "ג׳מייקה",
        "JO": "ירדן",
        "JP": "יפן",
        "KE": "קניה",
        "KG": "קירגיזסטן",
        "KH": "קמבודיה",
        "KI": "קיריבאטי",
        "KM": "קומורוס",
        "KN": "סנט קיטס ונוויס",
        "KP": "קוריאה הצפונית",
        "KR": "קוריאה הדרומית",
        "KW": "כווית",
        "KY": "איי קיימן",
        "KZ": "קזחסטן",
        "LA": "לאוס",
        "LB": "לבנון",
        "LC": "סנט לוסיה",
        "LI": "ליכטנשטיין",
        "LK": "סרי לנקה",
        "LR": "ליבריה",
        "LS": "לסוטו",
        "LT": "ליטא",
        "LU": "לוקסמבורג",
        "LV": "לטביה",
        "LY": "לוב",
        "MA": "מרוקו",
        "MC": "מונקו",
        "MD": "מולדובה",
        "ME": "מונטנגרו",
        "MF": "סנט מרטין",
        "MG": "מדגסקר",
        "MH": "איי מרשל",
        "MK": "מקדוניה",
        "ML": "מאלי",
        "MM": "מיאנמאר (בורמה)‎",
        "MN": "מונגוליה",
        "MO": "מקאו - מחוז מנהלי מיוחד של סין",
        "MP": "איי מריאנה הצפוניים",
        "MQ": "מרטיניק",
        "MR": "מאוריטניה",
        "MS": "מונסראט",
        "MT": "מלטה",
        "MU": "מאוריציוס",
        "MV": "האיים המלדיביים",
        "MW": "מלאווי",
        "MX": "מקסיקו",
        "MY": "מלזיה",
        "MZ": "מוזמביק",
        "NA": "נמיביה",
        "NC": "קלדוניה החדשה",
        "NE": "ניז׳ר",
        "NF": "איי נורפוק",
        "NG": "ניגריה",
        "NI": "ניקרגואה",
        "NL": "הולנד",
        "NO": "נורווגיה",
        "NP": "נפאל",
        "NR": "נאורו",
        "NU": "ניווה",
        "NZ": "ניו זילנד",
        "OM": "עומאן",
        "PA": "פנמה",
        "PE": "פרו",
        "PF": "פולינזיה הצרפתית",
        "PG": "פפואה גיניאה החדשה",
        "PH": "פיליפינים",
        "PK": "פקיסטן",
        "PL": "פולין",
        "PM": "סנט פייר ומיקלון",
        "PN": "איי פיטקרן",
        "PR": "פורטו ריקו",
        "PS": "השטחים הפלסטיניים",
        "PT": "פורטוגל",
        "PW": "פאלאו",
        "PY": "פרגוואי",
        "QA": "קטאר",
        "QO": "אוקיאניה פרושה",
        "RE": "ראוניון",
        "RO": "רומניה",
        "RS": "סרביה",
        "RU": "רוסיה",
        "RW": "רואנדה",
        "SA": "ערב הסעודית",
        "SB": "איי שלמה",
        "SC": "איי סיישל",
        "SD": "סודן",
        "SE": "שוודיה",
        "SG": "סינגפור",
        "SH": "סנט הלנה",
        "SI": "סלובניה",
        "SJ": "סוולבארד ויאן מאיין",
        "SK": "סלובקיה",
        "SL": "סיירה לאונה",
        "SM": "סן מרינו",
        "SN": "סנגל",
        "SO": "סומליה",
        "SR": "סורינם",
        "SS": "דרום סודן",
        "ST": "סאו טומה ופרינסיפה",
        "SV": "אל סלבדור",
        "SX": "סינט מארטן",
        "SY": "סוריה",
        "SZ": "סווזילנד",
        "TA": "טריסטן דה קונה",
        "TC": "איי טורקס וקאיקוס",
        "TD": "צ׳אד",
        "TF": "טריטוריות דרומיות של צרפת",
        "TG": "טוגו",
        "TH": "תאילנד",
        "TJ": "טג׳יקיסטן",
        "TK": "טוקלאו",
        "TL": "טימור לסטה",
        "TM": "טורקמניסטן",
        "TN": "תוניסיה",
        "TO": "טונגה",
        "TR": "טורקיה",
        "TT": "טרינידד וטובגו",
        "TV": "טובלו",
        "TW": "טייוואן",
        "TZ": "טנזניה",
        "UA": "אוקראינה",
        "UG": "אוגנדה",
        "UM": "איים לחוף ארצות הברית",
        "US": "ארצות הברית",
        "UY": "אורוגוואי",
        "UZ": "אוזבקיסטן",
        "VA": "הוותיקן",
        "VC": "סנט וינסנט והגרנדינים",
        "VE": "ונצואלה",
        "VG": "איי הבתולה הבריטיים",
        "VI": "איי הבתולה האמריקניים",
        "VN": "וייטנאם",
        "VU": "ונואטו",
        "WF": "איי ווליס ופוטונה",
        "WS": "סמואה",
        "XK": "קוסובו",
        "YE": "תימן",
        "YT": "מאיוט",
        "ZA": "דרום אפריקה",
        "ZM": "זמביה",
        "ZW": "זימבאבווה",
        "ZZ": "אזור לא ידוע"
    };
  }-*/;
}
