/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.CodewindConsoleFactory;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public class ShowAllLogsAction
extends Action {
    protected CodewindEclipseApplication app;

    public ShowAllLogsAction() {
        super(Messages.ShowAllLogFilesAction);
    }

    public void setApp(CodewindEclipseApplication app) {
        this.app = app;
        boolean enabled = false;
        if (app.getLogInfos() != null && !app.getLogInfos().isEmpty()) {
            for (ProjectLogInfo logInfo : app.getLogInfos()) {
                if (app.getConsole(logInfo) != null) continue;
                enabled = true;
                break;
            }
        }
        this.setEnabled(enabled);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"ShowAllLogsAction ran but no application was selected");
            return;
        }
        if (this.app.getLogInfos() == null || this.app.getLogInfos().isEmpty()) {
            Logger.logError((String)("ShowAllLogsAction ran but there are no logs for the selected application: " + this.app.name));
            return;
        }
        Job job = new Job(NLS.bind((String)Messages.ShowAllLogFilesJobLabel, (Object)this.app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (ProjectLogInfo logInfo : ShowAllLogsAction.this.app.getLogInfos()) {
                        if (ShowAllLogsAction.this.app.getConsole(logInfo) != null) continue;
                        SocketConsole console = CodewindConsoleFactory.createLogFileConsole((CodewindApplication)ShowAllLogsAction.this.app, (ProjectLogInfo)logInfo);
                        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
                        ShowAllLogsAction.this.app.addConsole(console);
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred opening the log files for: " + ShowAllLogsAction.this.app.name + ", with id: " + ShowAllLogsAction.this.app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ShowAllLogFilesError, (Object)ShowAllLogsAction.this.app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }
}

