/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal;

import java.util.ArrayList;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IDEUtil {
    public static int openQuestionCancelDialog(final String title, final String msg) {
        final int[] result = new int[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                String[] buttonLabels = new String[]{Messages.DialogYesButton, Messages.DialogNoButton, Messages.DialogCancelButton};
                MessageDialog dialog = new MessageDialog(shell, title, CodewindUIPlugin.getImage("codewind.png"), msg, 3, buttonLabels, 0);
                result[0] = dialog.open();
            }
        });
        return result[0];
    }

    public static boolean openConfirmDialog(final String title, final String msg) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                result[0] = MessageDialog.openConfirm((Shell)shell, (String)title, (String)msg);
            }
        });
        return result[0];
    }

    public static void setBold(StyledText text) {
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = text.getText().length();
        range.fontStyle = 1;
        text.setStyleRange(range);
    }

    public static void normalizeBackground(Control control, Control parent) {
        control.setBackground(parent.getBackground());
        control.setForeground(parent.getForeground());
    }

    public static void setControlVisibility(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    public static MultiStatus getMultiStatus(String msg, Throwable e) {
        StackTraceElement[] elems;
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (StackTraceElement elem : elems = e.getStackTrace()) {
            statusList.add(new Status(4, "org.eclipse.codewind.ui", elem.toString()));
        }
        return new MultiStatus("org.eclipse.codewind.ui", 4, (IStatus[])statusList.toArray(new Status[statusList.size()]), e.toString(), e);
    }

    public static Font newFont(Shell shell, Font font, int style) {
        FontData[] data = font.getFontData();
        FontData[] newData = new FontData[data.length];
        for (int i = 0; i < data.length; ++i) {
            newData[i] = new FontData(data[i].getName(), data[i].getHeight(), data[i].getStyle() | style);
        }
        return new Font((Device)shell.getDisplay(), newData);
    }
}

