/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.console;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class CodewindConsoleFactory {
    static final String CODEWIND_CONSOLE_TYPE = "codewind-console";

    public static SocketConsole createLogFileConsole(CodewindApplication app, ProjectLogInfo logInfo) {
        String consoleName = NLS.bind((String)Messages.LogFileConsoleName, (Object)app.name, (Object)logInfo.logName);
        SocketConsole console = new SocketConsole(consoleName, logInfo, app);
        CodewindConsoleFactory.onNewConsole(console);
        return console;
    }

    private static void onNewConsole(IOConsole console) {
        IConsole[] existingMCConsoles;
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        for (IConsole existingConsole : existingMCConsoles = consoleManager.getConsoles()) {
            if (!existingConsole.getName().equals(console.getName())) continue;
            consoleManager.removeConsoles(new IConsole[]{existingConsole});
            break;
        }
        Logger.log(String.format("Creating new application console: %s of type %s", console.getName(), console.getClass().getSimpleName()));
        consoleManager.addConsoles(new IConsole[]{console});
    }
}

