/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.ConnectionInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionUtil {
    private static final String CONNECTIONS_CMD = "connections";
    private static final String LIST_OPTION = "list";
    private static final String ADD_OPTION = "add";
    private static final String REMOVE_OPTION = "remove";
    private static final String UPDATE_OPTION = "update";
    private static final String LABEL_OPTION = "--label";
    private static final String URL_OPTION = "--url";
    private static final String USERNAME_OPTION = "--username";
    private static final String ID_KEY = "id";

    public static List<ConnectionInfo> listConnections(IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = ConnectionUtil.runConnectionCmd(new String[]{CONNECTIONS_CMD, LIST_OPTION}, null, null, true, monitor);
        JSONObject resultJson = new JSONObject(result.getOutput());
        return ConnectionInfo.getInfos(resultJson);
    }

    public static String addConnection(String name, String url, String username, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = ConnectionUtil.runConnectionCmd(new String[]{CONNECTIONS_CMD, ADD_OPTION}, new String[]{LABEL_OPTION, name, URL_OPTION, url, USERNAME_OPTION, username}, null, true, monitor);
        JSONObject resultJson = new JSONObject(result.getOutput());
        return resultJson.getString(ID_KEY);
    }

    public static void removeConnection(String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        ConnectionUtil.runConnectionCmd(new String[]{CONNECTIONS_CMD, REMOVE_OPTION}, new String[]{"--conid", conid}, null, false, monitor);
    }

    public static void updateConnection(String conid, String name, String url, String username, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        ConnectionUtil.runConnectionCmd(new String[]{CONNECTIONS_CMD, UPDATE_OPTION}, new String[]{"--conid", conid, LABEL_OPTION, name, URL_OPTION, url, USERNAME_OPTION, username}, null, false, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessHelper.ProcessResult runConnectionCmd(String[] command, String[] options, String[] args, boolean checkOutput, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(new String[]{"--insecure", "--json"}, command, options, args);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            CLIUtil.checkResult(command, result, checkOutput);
            ProcessHelper.ProcessResult processResult = result;
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }
}

