/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;

public class CodewindSourcePathComputer
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        String projectName = config.getAttribute("org.eclipse.codewind.core.internal.projectNameAttr", "");
        if (!projectName.isEmpty()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null || !project.exists()) {
                Logger.logError("Could not find project with name " + projectName + " to add to source path");
                return new ISourceContainer[0];
            }
            ProjectSourceContainer projectSourceContainer = new ProjectSourceContainer(project, true);
            Logger.log("Adding source container from project " + project.getName());
            return new ISourceContainer[]{projectSourceContainer};
        }
        Logger.logError("Could not retrieve project name from launch config " + config.getName());
        return new ISourceContainer[0];
    }
}

