/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdi.Bootstrap;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.launching.JavaRuntime;

public class LaunchUtilities {
    private LaunchUtilities() {
    }

    public static AttachingConnector getAttachingConnector() {
        List<AttachingConnector> connectors = Bootstrap.virtualMachineManager().attachingConnectors();
        for (int i = 0; i < connectors.size(); ++i) {
            AttachingConnector c = connectors.get(i);
            if (!"com.sun.jdi.SocketAttach".equals(c.name())) continue;
            return c;
        }
        return null;
    }

    public static Map<String, Connector.Argument> configureConnector(Map<String, Connector.Argument> argsToConfigure, String host, int portNumber) {
        Connector.StringArgument hostArg = (Connector.StringArgument)argsToConfigure.get("hostname");
        hostArg.setValue(host);
        Connector.IntegerArgument portArg = (Connector.IntegerArgument)argsToConfigure.get("port");
        portArg.setValue(portNumber);
        Connector.IntegerArgument timeoutArg = (Connector.IntegerArgument)argsToConfigure.get("timeout");
        if (timeoutArg != null) {
            int timeout = Platform.getPreferencesService().getInt("org.eclipse.jdt.launching", JavaRuntime.PREF_CONNECT_TIMEOUT, 20000, null);
            timeoutArg.setValue(timeout);
        }
        return argsToConfigure;
    }

    public static IDebugTarget createLocalJDTDebugTarget(ILaunch launch, int port, IProcess process, VirtualMachine vm, String name, boolean allowTerminate) {
        return JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)name, (IProcess)process, (boolean)allowTerminate, (boolean)true, (boolean)true);
    }

    public static void setDebugTimeout(VirtualMachine vm) {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(JDIDebugPlugin.getUniqueIdentifier());
        int timeOut = node.getInt(JDIDebugModel.PREF_REQUEST_TIMEOUT, 0);
        if (timeOut <= 0) {
            return;
        }
        if (vm instanceof org.eclipse.jdi.VirtualMachine) {
            org.eclipse.jdi.VirtualMachine vm2 = (org.eclipse.jdi.VirtualMachine)vm;
            vm2.setRequestTimeout(timeOut);
        }
    }
}

