/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
import { IWatchService } from "./IWatchService";
import { ProjectToWatch } from "./ProjectToWatch";
import { WatchEventEntry } from "./WatchEventEntry";
/**
 * This class works with the VSCode resource workbench monitoring functionality
 * to identify file/folder changes, and pass them to the FW core code.
 *
 * Specifically, a WatchEventEntry is created for each file/folder change, and the passes it to this class.
 * Next, this class passes it to the appropriate VSCWatchedPath, which then
 * processes it and forwards it to the core FW code.
 *
 * See IWatchService for more information on watch services.
 */
export declare class VSCodeResourceWatchService implements IWatchService {
    private readonly _projIdToWatchedPaths;
    private _parent;
    private _disposed;
    constructor();
    addPath(fileToMonitor: string, ptw: ProjectToWatch): void;
    removePath(fileToMonitor: string, oldProjectToWatch: ProjectToWatch): void;
    receiveWatchEntries(cwProjectId: string, entries: WatchEventEntry[]): void;
    internal_handleEvent(event: WatchEventEntry): void;
    setParent(parent: FileWatcher): void;
    readonly parent: FileWatcher;
    dispose(): void;
    generateDebugState(): string;
}
