/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileChangeEventBatchUtil } from "./FileChangeEventBatchUtil";
import { FileWatcher } from "./FileWatcher";
import { ProjectToWatch } from "./ProjectToWatch";
import { IWatchService } from "./IWatchService";
/**
 * Information maintained for each project that is being monitored by the watcher.
 * This includes information on what to watch/filter (the ProjectToWatch object),
 * the batch util (one batch util object exists per project), and which watch
 * service (internal/external) is being used for this project.
 */
export declare class ProjectObject {
    private _batchUtil;
    private _projectToWatch;
    private readonly _watchService;
    private readonly _cliState;
    constructor(projectId: string, projectToWatch: ProjectToWatch, watchService: IWatchService, parent: FileWatcher);
    updateProjectToWatch(newProjectToWatch: ProjectToWatch): void;
    informCwctlOfFileChangesAsync(): void;
    readonly projectToWatch: ProjectToWatch;
    readonly batchUtil: FileChangeEventBatchUtil;
    readonly watchService: IWatchService;
}
