/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.intellij.core.messages.CodewindCoreBundle;

public class ProcessHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessResult waitForProcess(Process p, int pollingDelay, int timeout) throws IOException, TimeoutException {
        int BUFFER_STEP = 1024;
        byte[] buf = new byte[1024];
        InputStream in = null;
        InputStream err = null;
        StringBuilder inBuilder = new StringBuilder();
        StringBuilder errBuilder = new StringBuilder();
        int iter = timeout * 1000 / pollingDelay;
        int work = 50;
        try {
            in = p.getInputStream();
            err = p.getErrorStream();
            int i = 0;
            while (true) {
                if (i >= iter) break;
                try {
                    Thread.sleep(pollingDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                inBuilder.append(ProcessHelper.readInput(in, buf));
                errBuilder.append(ProcessHelper.readInput(err, buf));
                try {
                    int exitValue = p.exitValue();
                    inBuilder.append(ProcessHelper.readInput(in, buf));
                    errBuilder.append(ProcessHelper.readInput(err, buf));
                    ProcessResult processResult = new ProcessResult(exitValue, inBuilder.toString(), errBuilder.toString());
                    return processResult;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        p.destroy();
        throw new TimeoutException("Process did not complete and had to be terminated");
    }

    private static String readInput(InputStream stream, byte[] buffer) throws IOException {
        StringBuilder builder = new StringBuilder();
        int n = stream.available();
        while (n > 0) {
            int len = stream.read(buffer, 0, Math.min(n, buffer.length));
            builder.append(new String(buffer, 0, len, "UTF-8"));
            n = stream.available();
        }
        return builder.toString();
    }

    public static class ProcessResult {
        private final int exitValue;
        private final String sysOut;
        private final String sysError;

        public ProcessResult(int exitValue, String sysOut, String sysError) {
            this.exitValue = exitValue;
            this.sysOut = sysOut;
            this.sysError = sysError;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public String getOutput() {
            return this.sysOut.toString();
        }

        public String getError() {
            return this.sysError.toString();
        }

        public String getErrorMsg() {
            if (this.sysError != null && !this.sysError.trim().isEmpty()) {
                return this.sysError;
            }
            if (this.sysOut != null && !this.sysOut.trim().isEmpty()) {
                return this.sysOut;
            }
            return CodewindCoreBundle.message("ProcessHelperUnknownError", new Object[0]);
        }
    }
}

