/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.core.connection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.intellij.core.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JSONObjectResult {
    protected final JSONObject result;
    protected final String type;

    public JSONObjectResult(JSONObject result, String type) {
        this.result = result;
        this.type = type;
    }

    protected String getString(String key) {
        String value = null;
        if (this.result.has(key)) {
            try {
                value = this.result.getString(key);
            }
            catch (JSONException e) {
                Logger.logWarning("An error occurred retrieving the value from the " + this.type + " object for key: " + key, e);
            }
        } else {
            Logger.logWarning("The " + this.type + " object did not have the expected key: " + key);
        }
        return value;
    }

    protected boolean getBoolean(String key) {
        boolean value = false;
        if (this.result.has(key)) {
            try {
                value = this.result.getBoolean(key);
            }
            catch (JSONException e) {
                Logger.logWarning("An error occurred retrieving the value from the " + this.type + " object for key: " + key, e);
            }
        } else {
            Logger.logWarning("The " + this.type + " object did not have the expected key: " + key);
        }
        return value;
    }

    protected List<String> getStringArray(String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.result.has(key)) {
            try {
                JSONArray array = this.result.getJSONArray(key);
                for (int i = 0; i < array.length(); ++i) {
                    list.add(array.getString(i));
                }
            }
            catch (JSONException e) {
                Logger.logWarning("An error occurred retrieving the value from the " + this.type + " object for key: " + key, e);
            }
        } else {
            Logger.logWarning("The " + this.type + " object did not have the expected key: " + key);
        }
        return list;
    }

    protected JSONObject getObject(String key) {
        JSONObject value = null;
        if (this.result.has(key)) {
            try {
                value = this.result.getJSONObject(key);
            }
            catch (JSONException e) {
                Logger.logWarning("An error occurred retrieving the value from the " + this.type + " object for key: " + key, e);
            }
        } else {
            Logger.logWarning("The " + this.type + " object did not have the expected key: " + key);
        }
        return value;
    }

    public String toString() {
        return this.result.toString();
    }
}

