/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.module;

import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.ui.messages.CodewindUIBundle;
import org.eclipse.codewind.intellij.ui.tasks.StartCodewindTask;

public class StartCodewindStep
extends ModuleWizardStep {
    private final JPanel panel = new JPanel();
    private final JLabel label;
    private final JButton button;
    private boolean isStarted;

    public StartCodewindStep() {
        this.panel.setLayout(new BoxLayout(this.panel, 3));
        this.label = new JLabel(CodewindUIBundle.message("CodewindNotStarted", new Object[0]));
        this.label.setAlignmentX(0.0f);
        this.panel.add(this.label);
        this.button = new JButton(CodewindUIBundle.message("StartCodewind", new Object[0]));
        this.panel.add(this.button);
        this.button.addActionListener(e -> {
            LocalConnection localConnection = ConnectionManager.getManager().getLocalConnection();
            localConnection.refreshInstallStatus();
            if (localConnection.getInstallStatus().isStarted()) {
                CoreUtil.openDialog(CoreUtil.DialogType.INFO, CodewindUIBundle.message("CodewindLabel", new Object[0]), CodewindUIBundle.message("CodewindStarted", new Object[0]));
            } else {
                ProgressManager.getInstance().run((Task)new StartCodewindTask(this::onStart));
            }
        });
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public void updateDataModel() {
    }

    public boolean validate() throws ConfigurationException {
        return this.isStarted;
    }

    private void onStart() {
        this.isStarted = true;
        this.button.setEnabled(false);
        String txt = "<html>" + CodewindUIBundle.message("CodewindStarted", new Object[0]) + "</html>";
        this.label.setText(txt);
    }
}

