/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.intellij.ui.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.ui.treeStructure.Tree;
import org.eclipse.codewind.intellij.core.CodewindApplication;
import org.eclipse.codewind.intellij.core.CoreUtil;
import org.eclipse.codewind.intellij.core.connection.ConnectionManager;
import org.eclipse.codewind.intellij.core.connection.LocalConnection;
import org.eclipse.codewind.intellij.ui.tree.CodewindTreeModel;
import org.jetbrains.annotations.NotNull;

public class RefreshTask
extends Task.Backgroundable {
    private final Object component;
    private final Tree tree;

    public RefreshTask(Object component, Tree tree) {
        super(null, "Refresh");
        this.component = component;
        this.tree = tree;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            RefreshTask.$$$reportNull$$$0(0);
        }
        CodewindTreeModel model = (CodewindTreeModel)((Object)this.tree.getModel());
        if (this.component instanceof ConnectionManager) {
            CoreUtil.invokeLater(() -> model.updateAll());
            return;
        }
        if (this.component instanceof LocalConnection) {
            LocalConnection connection = (LocalConnection)this.component;
            connection.refreshInstallStatus();
            if (connection.isConnected()) {
                connection.refreshApps(null);
            }
            CoreUtil.invokeLater(() -> model.updateConnection(connection));
            return;
        }
        if (this.component instanceof CodewindApplication) {
            CodewindApplication application = (CodewindApplication)this.component;
            application.getConnection().refreshApps(application.projectID);
            CoreUtil.invokeLater(() -> model.updateApplication(application));
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/eclipse/codewind/intellij/ui/tasks/RefreshTask", "run"));
    }
}

