/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.messages.CMatchResult;
import org.eclipse.comma.monitoring.lib.messages.CMessageCompositePattern;
import org.eclipse.comma.monitoring.lib.messages.CMessagePattern;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CMessageMultiplicityPattern
extends CMessageCompositePattern {
    private int lower;
    private int upper;
    private CMessagePattern pattern;

    public CMessageMultiplicityPattern() {
        this(null, 1, 1);
    }

    public CMessageMultiplicityPattern(CMessagePattern pattern, int lower, int upper) {
        this.pattern = pattern;
        this.lower = lower;
        this.upper = upper;
    }

    public CMessageMultiplicityPattern setMessagePattern(CMessagePattern mp) {
        this.pattern = mp;
        return this;
    }

    @Override
    public boolean isSkippable() {
        return this.lower == 0;
    }

    @Override
    public CMatchResult match(CObservedMessage observedMessage) {
        if (this.pattern.match(observedMessage)) {
            this.lower = Integer.max(0, this.lower - 1);
            this.upper = Integer.max(-1, this.upper - 1);
            if (this.upper == 0) {
                return CMatchResult.DROP;
            }
            return CMatchResult.MATCH;
        }
        if (this.lower == 0) {
            return CMatchResult.SKIP;
        }
        return CMatchResult.FAIL;
    }

    @Override
    public List<CMessagePattern> getPossibleEvents() {
        ArrayList<CMessagePattern> result = new ArrayList<CMessagePattern>();
        result.add(this.pattern);
        return result;
    }
}

