/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.petrinet.Guard;
import org.eclipse.comma.petrinet.PythonHelper;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

class PTransition {
    private static int nextID = 0;
    final String name = "T" + nextID;
    final Object event;
    final TriggeredTransition trigger;
    private final Guard guard;

    static void resetIDCounter() {
        nextID = 0;
    }

    PTransition() {
        this(null, null, null);
    }

    PTransition(Object event) {
        this(event, null, null);
    }

    PTransition(Object event, TriggeredTransition trigger) {
        this(event, null, trigger);
    }

    PTransition(Guard guard) {
        this(null, guard, null);
    }

    PTransition(Object event, Guard guard) {
        this(event, guard, null);
    }

    PTransition(Object event, Guard guard, TriggeredTransition trigger) {
        this.event = event;
        this.guard = guard;
        this.trigger = trigger;
        ++nextID;
    }

    public String eventName(boolean postfixReply) {
        if (this.event instanceof CommandReply) {
            return String.valueOf(this.trigger.getTrigger().getName()) + (postfixReply ? "_reply" : "");
        }
        if (this.event instanceof CommandReplyWithVars) {
            TriggeredTransition t = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)((EObject)this.event), TriggeredTransition.class);
            return String.valueOf(t.getTrigger().getName()) + (postfixReply ? "_reply" : "");
        }
        if (this.event instanceof EventCall) {
            EventCall e = (EventCall)this.event;
            return e.getEvent().getName();
        }
        if (this.event instanceof EventWithVars) {
            EventWithVars e = (EventWithVars)this.event;
            return e.getEvent().getName();
        }
        if (this.event instanceof TriggeredTransition) {
            TriggeredTransition t = (TriggeredTransition)this.event;
            return t.getTrigger().getName();
        }
        throw new RuntimeException("Not supported");
    }

    String getPythonName(Function<String, String> variablePrefix) {
        String name = this.name;
        if (this.event != null) {
            name = String.valueOf(name) + String.format("_event_%s", this.eventName(true));
        }
        return name;
    }

    String toPython(Function<String, String> variablePrefix, Interface itf, String port) {
        String expr = "";
        if (this.guard != null) {
            List parameters = null;
            Function<String, String> vp = null;
            if (this.event instanceof TriggeredTransition) {
                InterfaceEvent trigger = ((TriggeredTransition)this.event).getTrigger();
                ArrayList params = new ArrayList();
                for (Parameter p2 : trigger.getParameters()) {
                    if (p2.getDirection() == DIRECTION.OUT) continue;
                    params.add(((Variable)((TriggeredTransition)this.event).getParameters().get(trigger.getParameters().indexOf((Object)p2))).getName());
                }
                parameters = params;
                vp = variable -> {
                    for (String v : params) {
                        if (!v.equals(variable)) continue;
                        return "p[" + params.indexOf(v) + "]";
                    }
                    return "";
                };
            } else if (this.event instanceof ActionWithVars) {
                List params;
                parameters = params = ((ActionWithVars)this.event).getParameters().stream().map(p -> p.getName()).collect(Collectors.toList());
                vp = variable -> {
                    for (String v : params) {
                        if (!v.equals(variable)) continue;
                        return "p[" + params.indexOf(v) + "]";
                    }
                    return "gl.";
                };
            }
            expr = String.format(", Expression('%s')", this.guard.toPython(vp, parameters));
        }
        String eventMeta = "";
        if (this.event != null) {
            Function<String, String> variablePrefix2 = variable -> {
                String prefix = this.event instanceof TriggeredTransition ? "" : "gl.";
                return String.valueOf(prefix) + (String)variablePrefix.apply((String)variable);
            };
            String name = this.eventName(false);
            String parameters = PythonHelper.parameters(this.event, this.trigger, variablePrefix2).stream().collect(Collectors.joining(","));
            String kind = this.event instanceof CommandReply ? "Reply" : (this.event instanceof CommandReplyWithVars ? "Reply" : (this.event instanceof EventCall ? "Notification" : (this.event instanceof EventWithVars ? "Notification" : (((TriggeredTransition)this.event).getTrigger() instanceof Signal ? "Signal" : "Command"))));
            eventMeta = String.format(",'event': Event(EventType.%s, '%s', '%s', '%s', [%s])", kind, itf.getName(), port, name, parameters);
        }
        String typeMeta = String.format("'type': '%s'", this.event != null ? "event" : "none");
        String meta = String.format("{%s%s}", typeMeta, eventMeta);
        return String.format("add_transition(Transition('%s'%s), %s)\n", this.getPythonName(variablePrefix), expr, meta);
    }
}

