package org.eclipse.datatools.examples.podreader.cp.ui.properties;

import java.util.Properties;

import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ProfileDetailsPropertyPage;
import org.eclipse.datatools.examples.podreader.cp.PodProfileConstants;
import org.eclipse.datatools.examples.podreader.cp.PodProfilePropertyConstants;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class PodProfilePropertyPage extends ProfileDetailsPropertyPage {

	private Text podDriveText;

	/**
	 * Constructor for FileProfilePropetyPage.
	 */
	public PodProfilePropertyPage() {
		super();
		noDefaultAndApplyButton();
	}

	protected void createCustomContents(Composite parent) {
		Composite content = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout(2, false);
		content.setLayout(layout);

		Label label;

		label = new Label(content, SWT.NULL);
		label.setLayoutData(new GridData());
		label.setText("Pod Drive:");

		podDriveText = new Text(content, SWT.BORDER);
		podDriveText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				handlePathModify();
			}
		});

		initControls();
	}

	public Properties collectProperties() {
		Properties props = new Properties();
		props.setProperty(PodProfilePropertyConstants.POD_FILE_PATH, podDriveText.getText());
		return props;
	}

	private void initControls() {
		IConnectionProfile profile = getConnectionProfile();
		Assert.isTrue(profile.getProviderId().equals(
				PodProfileConstants.POD_PROFILE_ID));
		String path = profile.
						getBaseProperties().getProperty(PodProfilePropertyConstants.POD_FILE_PATH);
		if (path != null) {
			podDriveText.setText(path);
		}
		validate();
		setErrorMessage(null);
	}

	private void handlePathModify() {
		validate();
	}

	private void validate() {
		String errorMessage;
		String path = podDriveText.getText();
		if (path == null || path.length() == 0) {
			errorMessage = "Please specify Pod drive..";
		}
		else {
			errorMessage = null;
		}
		setErrorMessage(errorMessage);
		setValid(errorMessage == null);
	}
}
