/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelEnvironment;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IModelOperation;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IEvaluationStatus;
import org.eclipse.emf.diffmerge.patterns.core.api.status.IModelTransformationStatus;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.operations.InstanceOperation;
import org.eclipse.emf.diffmerge.patterns.core.util.BasicModelUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.HighlightingSpecification;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractFilteredGraphicalUpdateOperation;
import org.eclipse.emf.diffmerge.patterns.diagrams.operations.AbstractGraphicalWrappingInstanceOperation;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.CloseCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.NamingUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsEnginePlugin;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ISemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.templates.engine.operations.RenameTemplateInstanceOperation;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePattern;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.AbstractTableChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.InstanceChoiceDialog;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.InstanceConformityDialog;
import org.eclipse.emf.diffmerge.patterns.ui.util.IUIExtender;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.AbstractInstanceExplorerView;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.PatternWizardDialog;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.update.PatternUpdateWizard;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancePanelDialog
extends InstanceChoiceDialog {
    private static final int BUTTON_WIDTH = 110;
    protected final Object _diagram;
    protected boolean _graphicalUnfolding;
    protected boolean _keepUserNames;
    protected boolean _reuseLayoutAtUpdate;
    protected boolean _reuseStyleAtUpdate;
    protected boolean _showUpdateAdditions;
    protected static boolean __showConformityDetails = false;
    protected String _namingRule;
    protected final HighlightingSpecification _highlightingSpecification;
    protected final List<Object> _graphicalContext;
    private boolean _globalPatternStateChanged;
    protected static List<EStructuralFeature> _selectedFeaturesToIgnore;
    protected Set<EStructuralFeature> _optionalFeaturesToIgnore;
    protected boolean _destructiveInstanceUpdate;
    protected HashMap<Button, EStructuralFeature> _structuralFeaturesCheckBoxesMap;

    public InstancePanelDialog(Shell parentShell_p, EObject referenceElement_p, List<? extends IPatternInstance> instances_p, Object diagram_p, List<Object> graphicalContext_p) {
        super(parentShell_p, Messages.InstancePanelDialog_Header, Messages.InstancePanelDialog_Message, 3, referenceElement_p, instances_p, AbstractTableChoiceDialog.SelectionKind.MULTI, false);
        this._diagram = diagram_p;
        this._graphicalUnfolding = true;
        this._keepUserNames = true;
        this._showUpdateAdditions = true;
        this._reuseLayoutAtUpdate = true;
        this._reuseStyleAtUpdate = true;
        this._namingRule = "";
        this._highlightingSpecification = new HighlightingSpecification();
        this._graphicalContext = Collections.unmodifiableList(graphicalContext_p);
        this._globalPatternStateChanged = false;
        this._optionalFeaturesToIgnore = new LinkedHashSet<EStructuralFeature>();
        this._destructiveInstanceUpdate = false;
    }

    protected String getInstanceExplorerViewID() {
        IUIExtender uiExtender = PatternsUIPlugin.getDefault().getSemanticUIUtil();
        return uiExtender.getInstanceExplorerViewID();
    }

    @Override
    public boolean close() {
        AbstractInstanceExplorerView view;
        boolean result = super.close();
        if (this.globalPatternStateChanged() && (view = this.getInstanceExplorerView()) != null) {
            view.refreshCurrent();
        }
        return result;
    }

    protected void closeCurrentCatalog() {
        List<IPatternInstance> instances = this.getSelectedInstances();
        FOrderedSet catalogs = new FOrderedSet();
        for (IPatternInstance instance : instances) {
            IPattern pattern = instance.getPattern();
            if (pattern == null || !(pattern.getRepository() instanceof PatternRepository)) continue;
            PatternRepository catalog = (PatternRepository)pattern.getRepository();
            catalogs.add(catalog);
        }
        if (!catalogs.isEmpty()) {
            for (PatternRepository current : catalogs) {
                CloseCatalogOperation operation = new CloseCatalogOperation(current);
                this.executeOperation((IModelOperation)operation);
            }
            this.notifyGlobalPatternStateChanged();
            this._viewer.refresh(true);
            this.refresh();
        }
    }

    private void createButtonsArea(Composite parent_p) {
        Group lifeCycleGroup = new Group(parent_p, 0);
        lifeCycleGroup.setText(Messages.InstancePanelDialog_LifeCycle);
        lifeCycleGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        lifeCycleGroup.setLayout((Layout)new GridLayout(2, false));
        this.createFoldUnfoldRow((Composite)lifeCycleGroup);
        this.createRenamingRow((Composite)lifeCycleGroup);
        this.createDeleteRow((Composite)lifeCycleGroup);
        Group syncGroup = new Group(parent_p, 0);
        syncGroup.setText(Messages.InstancePanelDialog_Synchronization);
        syncGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        syncGroup.setLayout((Layout)new GridLayout(1, false));
        this.createIgnoredFeaturesGroup(syncGroup);
        this.createSynchronizationButtons(syncGroup);
        Group repGroup = new Group(parent_p, 0);
        repGroup.setText(Messages.InstancePanelDialog_Representation);
        repGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        repGroup.setLayout((Layout)new GridLayout(2, false));
        this.createShowRow((Composite)repGroup);
        this.createReuseLayoutAndStyleRow((Composite)repGroup);
        this.createHighlightRow((Composite)repGroup);
        this.createRestoreRow((Composite)repGroup);
    }

    private void createSynchronizationButtons(Group group_p) {
        Composite composite = this.createEmptyComposite((Composite)group_p, 2);
        this.createCheckRow(composite);
        this.createUpdateInstanceRow(composite);
        this.createUpdatePatternRow(composite);
    }

    private void createIgnoredFeaturesGroup(Group syncGroup_p) {
        this.initializeIgnoredFeaturesCollections();
        Group ignoredFeatureGroup = new Group((Composite)syncGroup_p, 0);
        ignoredFeatureGroup.setText(Messages.InstancePanelDialog_SynchronizationOptions);
        ignoredFeatureGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this._optionalFeaturesToIgnore != null) {
            ignoredFeatureGroup.setLayout((Layout)new GridLayout(this._optionalFeaturesToIgnore.size(), false));
        } else {
            ignoredFeatureGroup.setLayout((Layout)new GridLayout(10, false));
        }
        for (EStructuralFeature feature : this._optionalFeaturesToIgnore) {
            this.createIgnoredFeatureCheckBox(ignoredFeatureGroup, feature);
        }
    }

    private Button createIgnoredFeatureCheckBox(Group ignoredFeatureGroup_p, EStructuralFeature feature_p) {
        final Button ignoreName = new Button((Composite)ignoredFeatureGroup_p, 32);
        ignoreName.setText(this.toUserFriendlyString(feature_p.getName().toLowerCase()));
        ignoreName.setSelection(this.isIgnoredFeature(_selectedFeaturesToIgnore, feature_p));
        if (this._structuralFeaturesCheckBoxesMap == null) {
            this._structuralFeaturesCheckBoxesMap = new HashMap();
        }
        this._structuralFeaturesCheckBoxesMap.put(ignoreName, feature_p);
        ignoreName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                EStructuralFeature feature;
                if (InstancePanelDialog.this._structuralFeaturesCheckBoxesMap != null && (feature = InstancePanelDialog.this._structuralFeaturesCheckBoxesMap.get(ignoreName)) != null) {
                    InstancePanelDialog.this.updateSelectedFeatures(ignoreName, _selectedFeaturesToIgnore, feature);
                }
            }
        });
        return ignoreName;
    }

    private String toUserFriendlyString(String lowerCase) {
        String result = "";
        result = String.valueOf(result) + lowerCase.substring(0, 1).toUpperCase();
        result = String.valueOf(result) + lowerCase.substring(1, lowerCase.length());
        return result;
    }

    private void updateSelectedFeatures(Button button, List<EStructuralFeature> selectedFeaturesToIgnore_p, EStructuralFeature feature_p) {
        if (button.isEnabled()) {
            if (!selectedFeaturesToIgnore_p.contains(feature_p)) {
                selectedFeaturesToIgnore_p.add(feature_p);
            } else {
                selectedFeaturesToIgnore_p.remove(feature_p);
            }
        }
    }

    private boolean isIgnoredFeature(Collection<EStructuralFeature> ignoredFeatures_p, EStructuralFeature feature_p) {
        for (EStructuralFeature feature : ignoredFeatures_p) {
            if (!feature.equals(feature_p)) continue;
            return true;
        }
        return false;
    }

    private Button createCheckRow(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Check);
        Composite composite = this.createEmptyComposite(parent_p, 3);
        final Label label = new Label(composite, 0);
        label.setText(Messages.InstancePanelDialog_Conformity);
        final Text checkText = new Text(composite, 2056);
        checkText.setLayoutData((Object)new GridData(4, 4, true, false));
        final Button showDetails = new Button(composite, 32);
        showDetails.setText(Messages.InstancePanelDialog_ShowDetails);
        showDetails.setSelection(__showConformityDetails);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.CHECK);
                result.setEnabled(enable);
                label.setEnabled(enable);
                showDetails.setEnabled(enable);
                checkText.setText("");
                checkText.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                BasicModelUpdateSpecification specification = new BasicModelUpdateSpecification(false, _selectedFeaturesToIgnore);
                IEvaluationStatus status = InstancePanelDialog.this.executeInstanceOperation(InstancePanelDialog.this.getSelectedInstance(), InstanceOperation.InstanceOperationKind.CHECK, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.NONE, false, false, false, specification);
                if (status == null) {
                    MessageDialog.openError((Shell)InstancePanelDialog.this.getShell(), (String)Messages.InstancePanelDialog_CheckFailedTitle, (String)Messages.InstancePanelDialog_CheckFailedMessage);
                } else {
                    String singleLineMessage = status.getDescription();
                    String SPACE = " ";
                    singleLineMessage = singleLineMessage.replaceAll("\n", " ");
                    singleLineMessage = singleLineMessage.replaceAll("\r", " ");
                    singleLineMessage = singleLineMessage.replaceAll("\t", " ");
                    checkText.setText(singleLineMessage);
                    if (__showConformityDetails) {
                        InstanceConformityDialog dialog = new InstanceConformityDialog(InstancePanelDialog.this.getShell(), singleLineMessage, InstancePanelDialog.this.getSelectedInstance(), InstancePanelDialog.this._referenceElement, _selectedFeaturesToIgnore);
                        dialog.open();
                    }
                }
            }
        });
        showDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                __showConformityDetails = showDetails.getSelection();
            }
        });
        return result;
    }

    private MenuItem createCloseCatalogMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.InstancePanelDialog_CloseCatalog);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                List<IPatternInstance> instances = InstancePanelDialog.this.getSelectedInstances();
                boolean enable = false;
                for (IPatternInstance instance : instances) {
                    if (instance.getPattern() == null) continue;
                    enable = true;
                    break;
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this.closeCurrentCatalog();
            }
        });
        return result;
    }

    @Override
    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        Control selectionTable = super.createCustomArea(result);
        GridData dataMain = new GridData(4, 4, true, true);
        selectionTable.setLayoutData((Object)dataMain);
        this.enhanceSelectionTable(selectionTable);
        this.createButtonsArea(result);
        this.selectAll();
        return result;
    }

    private Button createDeleteButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Delete);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                List<IPatternInstance> instances = InstancePanelDialog.this.getSelectedInstances();
                if (!instances.isEmpty()) {
                    final LinkedList<Object> wrapper = new LinkedList<Object>();
                    wrapper.add(new Object());
                    MessageDialog dialog = new MessageDialog(InstancePanelDialog.this.getShell(), CorePatternsPlugin.getDefault().getLabel(), null, Messages.InstancePanelDialog_DeleteExplanation, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

                        protected Control createCustomArea(Composite innerParent_p) {
                            Button checkButton = new Button(innerParent_p, 32);
                            checkButton.setText(Messages.InstancePanelDialog_KeepElements);
                            checkButton.setSelection(wrapper.isEmpty());
                            checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent se_p) {
                                    if (wrapper.isEmpty()) {
                                        wrapper.add(new Object());
                                    } else {
                                        wrapper.clear();
                                    }
                                }
                            });
                            return checkButton;
                        }
                    };
                    int answer = dialog.open();
                    if (answer == 0) {
                        InstanceOperation.InstanceOperationKind operationKind = wrapper.isEmpty() ? InstanceOperation.InstanceOperationKind.DELETE : InstanceOperation.InstanceOperationKind.DELETE_WITH_ELEMENTS;
                        AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshKind = operationKind == InstanceOperation.InstanceOperationKind.DELETE_WITH_ELEMENTS ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM : AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.NONE;
                        List<IEvaluationStatus> statuses = InstancePanelDialog.this.executeInstanceOperations(instances, operationKind, refreshKind, false, false, false, null);
                        int nb = Math.min(statuses.size(), instances.size());
                        int i = 0;
                        while (i < nb) {
                            if (statuses.get(i).isOk()) {
                                InstancePanelDialog.this._originalList.remove(instances.get(i));
                            }
                            ++i;
                        }
                        InstancePanelDialog.this.notifyGlobalPatternStateChanged();
                        InstancePanelDialog.this._viewer.refresh();
                    }
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.DELETE));
            }
        });
        return result;
    }

    private Button createDeleteRow(Composite parent_p) {
        Button result = this.createDeleteButton(parent_p);
        new Label(parent_p, 0);
        return result;
    }

    protected Composite createEmptyComposite(Composite parent_p, int columns_p) {
        Composite result = new Composite(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout layout = new GridLayout(columns_p, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        return result;
    }

    private Button createFoldUnfoldButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                InstanceOperation.InstanceOperationKind operationKind = InstancePanelDialog.this.getFoldingOperationKind();
                AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshKind = InstanceOperation.InstanceOperationKind.UNFOLD == operationKind && InstancePanelDialog.this._graphicalUnfolding ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.INSTANCE : AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM;
                InstancePanelDialog.this.executeInstanceOperations(InstancePanelDialog.this.getSelectedInstances(), operationKind, refreshKind, InstancePanelDialog.this._reuseLayoutAtUpdate, InstancePanelDialog.this._reuseStyleAtUpdate, false, null);
                InstancePanelDialog.this.notifyGlobalPatternStateChanged();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                InstanceOperation.InstanceOperationKind operationKind = InstancePanelDialog.this.getFoldingOperationKind();
                result.setEnabled(InstancePanelDialog.this.isApplicable(operationKind));
                String caption = InstanceOperation.InstanceOperationKind.UNFOLD == operationKind ? Messages.InstancePanelDialog_Unfold : Messages.InstancePanelDialog_Fold;
                result.setText(caption);
            }
        });
        return result;
    }

    private Button createGraphicalUnfoldingCheckbox(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.InstancePanelDialog_ShowUnfolded);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.setSelection(this._graphicalUnfolding);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                InstancePanelDialog.this._graphicalUnfolding = !InstancePanelDialog.this._graphicalUnfolding;
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.UNFOLD));
            }
        });
        return result;
    }

    private Button createFoldUnfoldRow(Composite parent_p) {
        Button result = this.createFoldUnfoldButton(parent_p);
        this.createGraphicalUnfoldingCheckbox(parent_p);
        return result;
    }

    private Button createHighlightButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Highlight);
        result.setEnabled(this._diagram != null);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                InstancePanelDialog.this._highlightingSpecification.setAsDefault();
                CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)InstancePanelDialog.this._operationFactory.instantiateHighlightOperation(InstancePanelDialog.this._diagram, InstancePanelDialog.this.getSelectedInstances(), InstancePanelDialog.this._highlightingSpecification.color, 3, InstancePanelDialog.this._highlightingSpecification.coverEdges, InstancePanelDialog.this._highlightingSpecification.coverNodes, InstancePanelDialog.this._highlightingSpecification.coverPorts));
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this._diagram != null && !InstancePanelDialog.this.getSelectedInstances().isEmpty());
            }
        });
        return result;
    }

    private Button createHighlightRow(Composite parent_p) {
        Button result = this.createHighlightButton(parent_p);
        Composite composite = this.createEmptyComposite(parent_p, 5);
        final ColorSelector colorButton = new ColorSelector(composite);
        colorButton.setColorValue(this._highlightingSpecification.color);
        colorButton.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event_p) {
                if (event_p.getNewValue() instanceof RGB) {
                    InstancePanelDialog.this._highlightingSpecification.color = (RGB)event_p.getNewValue();
                }
            }
        });
        final Button coverNodesButton = new Button(composite, 32);
        coverNodesButton.setText(Messages.InstancePanelDialog_Nodes);
        coverNodesButton.setSelection(this._highlightingSpecification.coverNodes);
        final Button coverPortsButton = new Button(composite, 32);
        coverPortsButton.setText(Messages.InstancePanelDialog_Ports);
        coverPortsButton.setSelection(this._highlightingSpecification.coverPorts);
        final Button coverEdgesButton = new Button(composite, 32);
        coverEdgesButton.setText(Messages.InstancePanelDialog_Edges);
        coverEdgesButton.setSelection(this._highlightingSpecification.coverEdges);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this._diagram != null && !InstancePanelDialog.this.getSelectedInstances().isEmpty();
                colorButton.setEnabled(enable);
                coverNodesButton.setEnabled(enable);
                coverPortsButton.setEnabled(enable);
                coverEdgesButton.setEnabled(enable);
            }
        });
        coverNodesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._highlightingSpecification.coverNodes = coverNodesButton.getSelection();
            }
        });
        coverPortsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._highlightingSpecification.coverPorts = coverPortsButton.getSelection();
            }
        });
        coverEdgesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._highlightingSpecification.coverEdges = coverEdgesButton.getSelection();
            }
        });
        return result;
    }

    private Button createReuseLayoutButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_RestoreLayout);
        result.setEnabled(this._diagram != null);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IModelEnvironment env;
                List<IPatternInstance> instances = InstancePanelDialog.this.getSelectedInstances();
                ArrayList<AbstractFilteredGraphicalUpdateOperation> operations = new ArrayList<AbstractFilteredGraphicalUpdateOperation>(instances.size());
                for (IPatternInstance instance : instances) {
                    operations.add(InstancePanelDialog.this._operationFactory.instantiateLayoutReuseOperation(InstancePanelDialog.this._diagram, instance, new HashMap(), new HashMap(), 0, 0, InstancePanelDialog.this._reuseLayoutAtUpdate, false, InstancePanelDialog.this._diagram));
                }
                if (!operations.isEmpty() && (env = CorePatternsPlugin.getDefault().getModelEnvironment()) != null) {
                    for (AbstractFilteredGraphicalUpdateOperation current : operations) {
                        env.execute((IModelOperation)current);
                    }
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this.isLayoutReusePossible());
            }
        });
        return result;
    }

    private void createReuseStyleButton(Composite parent_p) {
        final Button reuseStyleButton = new Button(parent_p, 32);
        reuseStyleButton.setText(Messages.InstancePanelDialog_RestoreStyle);
        reuseStyleButton.setSelection(this._reuseStyleAtUpdate);
        reuseStyleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._reuseStyleAtUpdate = reuseStyleButton.getSelection();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                reuseStyleButton.setEnabled(InstancePanelDialog.this.isLayoutReusePossible());
            }
        });
    }

    private void createReuseLayoutAndStyleRow(Composite parent_p) {
        this.createReuseLayoutButton(parent_p);
        new Label(parent_p, 0);
    }

    private MenuItem createOpenCatalogMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.InstancePanelDialog_OpenCatalog);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                List<IPatternInstance> instances = InstancePanelDialog.this.getSelectedInstances();
                boolean enable = false;
                for (IPatternInstance instance : instances) {
                    if (instance.getPattern() != null) continue;
                    enable = true;
                    break;
                }
                result.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this.resolvePatterns();
            }
        });
        return result;
    }

    private MenuItem createShowInInstanceExplorerMenuItem(Menu menu_p) {
        final MenuItem result = new MenuItem(menu_p, 0);
        result.setText(Messages.InstancePanelDialog_ShowInView);
        result.setImage(PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.PATTERN));
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(!InstancePanelDialog.this._viewer.getSelection().isEmpty());
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                AbstractInstanceExplorerView view = null;
                try {
                    view = (AbstractInstanceExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(InstancePanelDialog.this.getInstanceExplorerViewID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (view != null) {
                    view.setInput(InstancePanelDialog.this._viewer.getSelection());
                }
            }
        });
        return result;
    }

    protected Button createPushButton(Composite parent_p) {
        Button result = new Button(parent_p, 8);
        GridData data = new GridData(4, 4, false, false);
        data.widthHint = 110;
        result.setLayoutData((Object)data);
        return result;
    }

    private Button createRenamingButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Rename);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IPatternInstance instance = InstancePanelDialog.this.getSelectedInstance();
                if (instance != null) {
                    RenameTemplateInstanceOperation coreOperation = new RenameTemplateInstanceOperation(instance, InstancePanelDialog.this._namingRule, InstancePanelDialog.this._keepUserNames, InstancePanelDialog.this._diagram);
                    AbstractGraphicalWrappingInstanceOperation wholeOperation = InstancePanelDialog.this._operationFactory.instantiateGraphicalWrappingInstanceOperation((IModelOperation)coreOperation, instance, InstancePanelDialog.this._diagram, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM);
                    InstancePanelDialog.this.executeOperation(wholeOperation);
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IPatternInstance instance = InstancePanelDialog.this.getSelectedInstance();
                boolean valid = instance != null && instance.getPatternData() instanceof TemplatePatternData;
                result.setEnabled(valid);
            }
        });
        return result;
    }

    private Text createRenamingConfigurationRow(Composite parent_p) {
        Composite composite = this.createEmptyComposite(parent_p, 2);
        this.createRenamingPreservationCheckbox(composite);
        Text result = this.createRenamingText(composite);
        return result;
    }

    private Button createRenamingPreservationCheckbox(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.InstancePanelDialog_KeepUserNames);
        result.setSelection(this._keepUserNames);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._keepUserNames = result.getSelection();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                IPatternInstance instance = InstancePanelDialog.this.getSelectedInstance();
                boolean valid = instance != null && instance.getPatternData() instanceof TemplatePatternData && instance.getPattern() != null;
                result.setEnabled(valid);
                if (instance != null && instance.getPattern() == null) {
                    result.setSelection(true);
                }
            }
        });
        return result;
    }

    private Button createRenamingRow(Composite parent_p) {
        Button result = this.createRenamingButton(parent_p);
        this.createRenamingConfigurationRow(parent_p);
        return result;
    }

    private Text createRenamingText(Composite parent_p) {
        final Text result = new Text(parent_p, 2048);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e_p) {
                InstancePanelDialog.this._namingRule = result.getText();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean valid = !InstancePanelDialog.this.getSelectedInstances().isEmpty();
                result.setEnabled(valid);
                if (valid) {
                    String newText = NamingUtil.getNeutralRenamingRule();
                    TemplatePatternData data = TemplatePatternsUtil.getPatternData((IPatternApplication)InstancePanelDialog.this.getSelectedInstance());
                    if (data != null && (newText = data.getNamingRule()) == null) {
                        newText = "";
                    }
                    result.setText(newText);
                } else {
                    result.setText("");
                }
            }
        });
        return result;
    }

    private Button createRestoreButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Reset);
        result.setEnabled(this._diagram != null);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                CorePatternsPlugin.getDefault().getModelEnvironment().execute((IModelOperation)InstancePanelDialog.this._operationFactory.instantiateRestoreOperation(InstancePanelDialog.this._diagram, InstancePanelDialog.this.getSelectedInstances()));
                if (InstancePanelDialog.this._reuseStyleAtUpdate) {
                    IModelEnvironment env;
                    List<IPatternInstance> instances = InstancePanelDialog.this.getSelectedInstances();
                    ArrayList<AbstractFilteredGraphicalUpdateOperation> operations = new ArrayList<AbstractFilteredGraphicalUpdateOperation>(instances.size());
                    for (IPatternInstance instance : instances) {
                        operations.add(InstancePanelDialog.this._operationFactory.instantiateLayoutReuseOperation(InstancePanelDialog.this._diagram, instance, new HashMap(), new HashMap(), 0, 0, false, InstancePanelDialog.this._reuseStyleAtUpdate, InstancePanelDialog.this._diagram));
                    }
                    if (!operations.isEmpty() && (env = CorePatternsPlugin.getDefault().getModelEnvironment()) != null) {
                        for (AbstractFilteredGraphicalUpdateOperation current : operations) {
                            env.execute((IModelOperation)current);
                        }
                    }
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this._diagram != null && !InstancePanelDialog.this.getSelectedInstances().isEmpty());
            }
        });
        return result;
    }

    private Button createRestoreRow(Composite parent_p) {
        Button result = this.createRestoreButton(parent_p);
        Composite spacecomposite = this.createEmptyComposite(parent_p, 2);
        this.createReuseStyleButton(spacecomposite);
        new Label(spacecomposite, 0);
        return result;
    }

    private Button createShowRow(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_Show);
        result.setSelection(this._diagram != null);
        Composite composite = this.createEmptyComposite(parent_p, 2);
        final Label label = new Label(composite, 0);
        label.setText(Messages.InstancePanelDialog_Status);
        final Text showText = new Text(composite, 2056);
        showText.setLayoutData((Object)new GridData(4, 4, true, false));
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this._diagram != null && !InstancePanelDialog.this.getSelectedInstances().isEmpty();
                result.setEnabled(enable);
                label.setEnabled(enable);
                showText.setText("");
                showText.setEnabled(enable);
            }
        });
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                FOrderedSet subOperations = new FOrderedSet();
                for (IPatternInstance instance : InstancePanelDialog.this.getSelectedInstances()) {
                    AbstractGraphicalWrappingInstanceOperation subOperation = InstancePanelDialog.this._operationFactory.instantiateGraphicalWrappingInstanceOperation(null, instance, InstancePanelDialog.this._diagram, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.INSTANCE);
                    subOperations.add(subOperation);
                }
                if (!subOperations.isEmpty()) {
                    IModelEnvironment env;
                    if (!subOperations.isEmpty() && (env = CorePatternsPlugin.getDefault().getModelEnvironment()) != null) {
                        for (AbstractGraphicalWrappingInstanceOperation current : subOperations) {
                            env.execute((IModelOperation)current);
                        }
                    }
                    int created = 0;
                    for (AbstractGraphicalWrappingInstanceOperation subOperation : subOperations) {
                        created += subOperation.getNewDiagramElements().size();
                    }
                    String status = created == 0 ? Messages.InstancePanelDialog_Unchanged : String.format(Messages.InstancePanelDialog_CreatedNodes, created);
                    showText.setText(status);
                }
            }
        });
        return result;
    }

    private Button createUpdateInstanceButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_UpdateInstance);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                if (_selectedFeaturesToIgnore != null) {
                    BasicModelUpdateSpecification specification = new BasicModelUpdateSpecification(InstancePanelDialog.this._destructiveInstanceUpdate, _selectedFeaturesToIgnore);
                    InstanceOperation.InstanceOperationKind operationKind = InstanceOperation.InstanceOperationKind.UPDATE;
                    AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshKind = InstancePanelDialog.this._showUpdateAdditions ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.INSTANCE : AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM;
                    List<IEvaluationStatus> statuses = InstancePanelDialog.this.executeInstanceOperations(InstancePanelDialog.this.getSelectedInstances(), operationKind, refreshKind, InstancePanelDialog.this._reuseLayoutAtUpdate, InstancePanelDialog.this._reuseStyleAtUpdate, false, specification);
                    InstancePanelDialog.this.notifyGlobalPatternStateChanged();
                    int nbChangesMade = 0;
                    int nbCandidateChanges = 0;
                    for (IEvaluationStatus status : statuses) {
                        if (!(status instanceof IModelTransformationStatus)) continue;
                        IModelTransformationStatus mts = (IModelTransformationStatus)status;
                        if (mts.getNbChangesMade() > -1) {
                            nbChangesMade += mts.getNbChangesMade();
                        }
                        if (mts.getNbCandidateChanges() <= -1) continue;
                        nbCandidateChanges += mts.getNbCandidateChanges();
                    }
                    int nbRemaining = Math.max(0, nbCandidateChanges - nbChangesMade);
                    MessageDialog.openInformation((Shell)InstancePanelDialog.this.getShell(), (String)Messages.InstancePanelDialog_InstanceUpdateHeader, (String)String.format(Messages.InstancePanelDialog_InstanceUpdateSynthesis, nbChangesMade, nbRemaining));
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                InstanceOperation.InstanceOperationKind operationKind = InstanceOperation.InstanceOperationKind.UPDATE;
                result.setEnabled(InstancePanelDialog.this.isApplicable(operationKind));
            }
        });
        return result;
    }

    private Button createUpdateInstanceDestructiveCheckbox(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.InstancePanelDialog_Destructive);
        result.setSelection(this._destructiveInstanceUpdate);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._destructiveInstanceUpdate = result.getSelection();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.UPDATE);
                result.setEnabled(enable);
            }
        });
        return result;
    }

    private Button createUpdateInstanceRow(Composite parent_p) {
        Button result = this.createUpdateInstanceButton(parent_p);
        Composite composite = this.createEmptyComposite(parent_p, 3);
        this.createUpdateInstanceShowCheckbox(composite);
        this.createUpdateInstanceDestructiveCheckbox(composite);
        return result;
    }

    private void initializeIgnoredFeaturesCollections() {
        this._optionalFeaturesToIgnore = new LinkedHashSet<EStructuralFeature>();
        List<IPatternInstance> instances = this.getSelectedInstances();
        if (!instances.isEmpty()) {
            for (IPatternInstance instance : instances) {
                for (EObject obj : instance.getElements()) {
                    ISemanticRuleProvider provider = TemplatePatternsEnginePlugin.getDefault().getSemanticRuleProviderFor((Object)obj);
                    if (provider != null && provider.getOptionalMergeFeatures() != null) {
                        this._optionalFeaturesToIgnore.addAll(provider.getOptionalMergeFeatures());
                    }
                    if (_selectedFeaturesToIgnore != null) continue;
                    _selectedFeaturesToIgnore = new LinkedList<EStructuralFeature>();
                    if (provider.getDefaultOptionalMergeFeatures() == null) continue;
                    for (EStructuralFeature feature : provider.getDefaultOptionalMergeFeatures()) {
                        if (_selectedFeaturesToIgnore.contains(feature)) continue;
                        _selectedFeaturesToIgnore.add(feature);
                    }
                }
            }
        }
    }

    private Button createUpdatePatternButton(Composite parent_p) {
        final Button result = this.createPushButton(parent_p);
        result.setText(Messages.InstancePanelDialog_UpdatePattern);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event_p) {
                IPatternInstance instance = InstancePanelDialog.this.getSelectedInstance();
                if (instance != null) {
                    InstancePanelDialog.this.updatePattern(instance);
                }
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                result.setEnabled(InstancePanelDialog.this.isPatternUpdateApplicable());
            }
        });
        return result;
    }

    private Button createUpdateInstanceShowCheckbox(Composite parent_p) {
        final Button result = new Button(parent_p, 32);
        result.setText(Messages.InstancePanelDialog_ShowAdditions);
        result.setSelection(this._showUpdateAdditions);
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.UPDATE);
                result.setEnabled(enable);
            }
        });
        final Button reuseLayout = new Button(parent_p, 32);
        reuseLayout.setText(Messages.InstancePanelDialog_ReuseLayoutAtUpdate);
        reuseLayout.setSelection(this._reuseLayoutAtUpdate);
        reuseLayout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._reuseLayoutAtUpdate = result.getSelection();
            }
        });
        this._viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event_p) {
                boolean enable = InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.UPDATE) && InstancePanelDialog.this._showUpdateAdditions && InstancePanelDialog.this.isLayoutReusePossible();
                reuseLayout.setEnabled(enable);
            }
        });
        reuseLayout.setVisible(false);
        result.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                InstancePanelDialog.this._showUpdateAdditions = result.getSelection();
                boolean enableLayoutReuse = InstancePanelDialog.this.isApplicable(InstanceOperation.InstanceOperationKind.UPDATE) && InstancePanelDialog.this._showUpdateAdditions && InstancePanelDialog.this.isLayoutReusePossible();
                reuseLayout.setEnabled(enableLayoutReuse);
            }
        });
        return result;
    }

    private Button createUpdatePatternRow(Composite parent_p) {
        Button result = this.createUpdatePatternButton(parent_p);
        new Label(parent_p, 0);
        return result;
    }

    private void enhanceSelectionTable(Control selectionTable_p) {
        Menu menu = new Menu((Control)this.getShell());
        selectionTable_p.setMenu(menu);
        this.createOpenCatalogMenuItem(menu);
        this.createCloseCatalogMenuItem(menu);
        new MenuItem(menu, 2);
        this.createShowInInstanceExplorerMenuItem(menu);
        selectionTable_p.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e_p) {
            }

            public void mouseDown(MouseEvent e_p) {
            }

            public void mouseDoubleClick(MouseEvent e_p) {
                InstancePanelDialog.this.resolvePatterns();
            }
        });
    }

    protected List<IEvaluationStatus> executeInstanceOperations(List<? extends IPatternInstance> instances_p, InstanceOperation.InstanceOperationKind operationKind_p, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind requestKind_p, boolean reuseLayout_p, boolean reuseStyle_p, boolean verbose_p, Object specification_p) {
        ArrayList<IEvaluationStatus> result = new ArrayList<IEvaluationStatus>();
        FOrderedSet instanceOperations = new FOrderedSet();
        if (!instances_p.isEmpty()) {
            boolean delegateDiagramRefresh = requestKind_p == AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.DIAGRAM;
            IPatternInstance last = instances_p.get(instances_p.size() - 1);
            for (IPatternInstance iPatternInstance : instances_p) {
                AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind subRequestKind;
                AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind refreshRequestKind = subRequestKind = delegateDiagramRefresh && iPatternInstance != last ? AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind.NONE : requestKind_p;
                if (!this.isApplicable(operationKind_p, iPatternInstance)) continue;
                instanceOperations.add(this.getInstanceOperation(iPatternInstance, operationKind_p, subRequestKind, specification_p));
            }
        }
        if (!instanceOperations.isEmpty()) {
            IEvaluationStatus localResult;
            IModelEnvironment env;
            if (!instanceOperations.isEmpty() && (env = CorePatternsPlugin.getDefault().getModelEnvironment()) != null) {
                for (IModelOperation current : instanceOperations) {
                    Object obj = env.execute(current);
                    if (obj instanceof Collection) {
                        result.addAll((Collection)obj);
                        continue;
                    }
                    if (!(obj instanceof IEvaluationStatus)) continue;
                    result.add((IEvaluationStatus)obj);
                }
            }
            if (reuseLayout_p || reuseStyle_p) {
                this.reuseAppearenceOnAdditions((Collection<? extends IModelOperation<?>>)instanceOperations, reuseLayout_p, reuseStyle_p);
            }
            IEvaluationStatus iEvaluationStatus = localResult = result.isEmpty() ? null : (IEvaluationStatus)result.get(0);
            if (verbose_p && localResult != null && (!localResult.isOk() || localResult.hasWarnings())) {
                UIUtil.informFromStatus(localResult, this.getShell());
            }
            this.refresh();
        }
        return result;
    }

    protected IEvaluationStatus executeInstanceOperation(IPatternInstance instance_p, InstanceOperation.InstanceOperationKind operationKind_p, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind requestKind_p, boolean reuseLayout_p, boolean reuseStyle_p, boolean verbose_p, Object specification_p) {
        List<IEvaluationStatus> allResults = this.executeInstanceOperations(Collections.singletonList(instance_p), operationKind_p, requestKind_p, reuseLayout_p, reuseStyle_p, verbose_p, specification_p);
        IEvaluationStatus result = allResults.isEmpty() ? null : allResults.get(0);
        return result;
    }

    protected final <E> E executeOperation(final IModelOperation<E> operation_p) {
        final ArrayList wrapper = new ArrayList(1);
        BusyIndicator.showWhile((Display)this.getContents().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                Object result = CorePatternsPlugin.getDefault().getModelEnvironment().execute(operation_p);
                wrapper.add(result);
            }
        });
        return wrapper.get(0);
    }

    @Override
    protected int getColumnWidth(int columnNb_p) {
        return 200;
    }

    protected InstanceOperation.InstanceOperationKind getFoldingOperationKind() {
        InstanceOperation.InstanceOperationKind result = this.isApplicable(InstanceOperation.InstanceOperationKind.UNFOLD) ? InstanceOperation.InstanceOperationKind.UNFOLD : InstanceOperation.InstanceOperationKind.FOLD;
        return result;
    }

    protected IModelOperation<? extends IEvaluationStatus> getInstanceOperation(IPatternInstance instance_p, InstanceOperation.InstanceOperationKind operationKind_p, AbstractGraphicalWrappingInstanceOperation.RefreshRequestKind requestKind_p, Object specification_p) {
        AbstractGraphicalWrappingInstanceOperation result = null;
        InstanceOperation operation = null;
        if (operationKind_p != null) {
            operation = new InstanceOperation(instance_p, operationKind_p, specification_p, this._diagram, null);
        }
        result = this._operationFactory.instantiateGraphicalWrappingInstanceOperation(operation, instance_p, this._diagram, requestKind_p);
        return result;
    }

    @Override
    protected Point getInitialSize() {
        super.getInitialSize();
        return this.getShell().computeSize(-1, -1, true);
    }

    protected AbstractInstanceExplorerView getInstanceExplorerView() {
        AbstractInstanceExplorerView result = null;
        try {
            result = (AbstractInstanceExplorerView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(this.getInstanceExplorerViewID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected IPatternInstance getSelectedInstance() {
        IPatternInstance result = null;
        List<IPatternInstance> selection = this.getSelectedInstances();
        if (selection.size() == 1) {
            result = selection.get(0);
        }
        return result;
    }

    protected List<IPatternInstance> getSelectedInstances() {
        IStructuredSelection selection = (IStructuredSelection)this._viewer.getSelection();
        return selection.toList();
    }

    protected boolean isApplicable(InstanceOperation.InstanceOperationKind operationKind_p) {
        boolean result;
        if (InstanceOperation.InstanceOperationKind.CHECK == operationKind_p) {
            IPatternInstance instance = this.getSelectedInstance();
            result = instance != null && this.isApplicable(operationKind_p, instance);
        } else {
            result = false;
            List<IPatternInstance> instances = this.getSelectedInstances();
            for (IPatternInstance instance : instances) {
                if (!this.isApplicable(operationKind_p, instance)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean globalPatternStateChanged() {
        return this._globalPatternStateChanged;
    }

    protected boolean isApplicable(InstanceOperation.InstanceOperationKind operationKind_p, IPatternInstance instance_p) {
        boolean result = false;
        boolean patternIsKnown = instance_p.getPattern() != null;
        switch (operationKind_p) {
            case UNFOLD: {
                result = patternIsKnown && instance_p.isFolded();
                break;
            }
            case FOLD: 
            case UPDATE: {
                result = patternIsKnown && !instance_p.isFolded();
                break;
            }
            case CHECK: {
                result = patternIsKnown;
                break;
            }
            case DELETE: 
            case DELETE_WITH_ELEMENTS: {
                result = true;
            }
        }
        return result;
    }

    protected boolean isLayoutReusePossible() {
        boolean result;
        boolean bl = result = this._diagram != null;
        if (result) {
            List<IPatternInstance> selected = this.getSelectedInstances();
            boolean bl2 = result = !selected.isEmpty();
            if (result && selected.size() == 1) {
                IPatternInstance instance = selected.get(0);
                result = this.isLayoutReusePossibleOn(instance);
            }
        }
        return result;
    }

    protected boolean isLayoutReusePossibleOn(IPatternInstance instance_p) {
        boolean result = false;
        if (instance_p.getPattern() instanceof TemplatePattern) {
            TemplatePattern pattern = (TemplatePattern)instance_p.getPattern();
            result = !pattern.getLayoutData().isEmpty();
        }
        return result;
    }

    protected boolean isPatternUpdateApplicable() {
        IPatternInstance instance = this.getSelectedInstance();
        return instance != null && instance.getPattern() != null;
    }

    protected void notifyGlobalPatternStateChanged() {
        this._globalPatternStateChanged = true;
    }

    protected void refresh() {
        this._viewer.refresh(true);
        List<IPatternInstance> instances = this.getSelectedInstances();
        StructuredSelection newSelection = new StructuredSelection(instances);
        this._viewer.setSelection((ISelection)newSelection);
    }

    protected boolean resolvePatterns() {
        boolean result = false;
        List<IPatternInstance> instances = this.getSelectedInstances();
        if (!instances.isEmpty()) {
            result = UIUtil.resolvePatternWithUser(this.getShell(), instances);
        }
        if (result) {
            this.notifyGlobalPatternStateChanged();
            this._viewer.refresh(true);
            this.refresh();
        }
        return result;
    }

    protected void reuseAppearenceOnAdditions(Collection<? extends IModelOperation<?>> executedOperations_p, boolean reuseLayout_p, boolean reuseStyle_p) {
        IModelEnvironment env;
        ArrayList<AbstractFilteredGraphicalUpdateOperation> newOperations = new ArrayList<AbstractFilteredGraphicalUpdateOperation>();
        for (IModelOperation<?> executedOperation : executedOperations_p) {
            if (!(executedOperation instanceof AbstractGraphicalWrappingInstanceOperation)) continue;
            AbstractGraphicalWrappingInstanceOperation executedViewpointOperation = (AbstractGraphicalWrappingInstanceOperation)executedOperation;
            IPatternInstance instance = executedViewpointOperation.getInstance();
            Collection diagramElements = executedViewpointOperation.getNewDiagramElements();
            if (instance == null || diagramElements.isEmpty()) continue;
            AbstractFilteredGraphicalUpdateOperation newOperation = this._operationFactory.instantiateLayoutReuseOperation(diagramElements, instance, null, null, 0, 0, reuseLayout_p, reuseStyle_p, this._diagram);
            newOperations.add(newOperation);
        }
        if (!newOperations.isEmpty() && !newOperations.isEmpty() && (env = CorePatternsPlugin.getDefault().getModelEnvironment()) != null) {
            for (IModelOperation iModelOperation : newOperations) {
                env.execute(iModelOperation);
            }
        }
    }

    protected void updatePattern(IPatternInstance instance_p) {
        PatternWizardDialog dialog = new PatternWizardDialog(this.getShell(), new PatternUpdateWizard(instance_p, this._referenceElement, this._graphicalContext, _selectedFeaturesToIgnore));
        int answer = dialog.open();
        if (answer == 0) {
            if (dialog.isSuccessful()) {
                UIUtil.informSuccess(this.getShell());
                this.refresh();
            } else {
                UIUtil.informError(this.getShell());
            }
        }
    }
}

