/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.keywordhandler;

import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class CronHandler
implements EventHandler {
    private final Map<IScript, Long> fScheduledScripts = new HashMap<IScript, Long>();
    private final Map<IScript, Long> fPastExecutions = new HashMap<IScript, Long>();

    public void handleEvent(Event event) {
        IScript script = (IScript)event.getProperty("script");
        String value = (String)event.getProperty("value");
        String oldValue = (String)event.getProperty("oldValue");
        if (!oldValue.isEmpty()) {
            this.fScheduledScripts.remove(script);
        }
        this.planExecution(script, value);
    }

    private static void findNextDate(long lastExecution, List<Integer> acceptedMinutes, List<Integer> acceptedHours, List<Integer> acceptedDayOfMonth, List<Integer> acceptedMonth, List<Integer> acceptedDayOfWeek, List<Integer> acceptedYears) {
        GregorianCalendar lastTime = new GregorianCalendar();
        lastTime.setTimeInMillis(lastExecution);
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar nextTime = new GregorianCalendar();
        nextTime.setTimeInMillis(now.getTimeInMillis());
        nextTime.set(1, acceptedYears.get(0));
        nextTime.set(2, acceptedMonth.get(0));
        nextTime.set(10, acceptedHours.get(0));
        nextTime.set(12, acceptedMinutes.get(0));
        nextTime.set(5, acceptedDayOfMonth.get(0));
        GregorianCalendar tempDate = new GregorianCalendar();
        while (nextTime.before(now)) {
            tempDate.setTimeInMillis(nextTime.getTimeInMillis());
        }
    }

    private static int findNext(Collection<Integer> acceptedValues, int current) {
        int minimum = 10000;
        int next = 10000;
        for (int candidate : acceptedValues) {
            minimum = Math.min(candidate, minimum);
            if (candidate < current || candidate >= next) continue;
            next = candidate;
        }
        return next != 10000 ? next : minimum;
    }

    private void planExecution(IScript script, String scheduledTime) {
    }
}

