/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.editor.VariablesTreeContentProvider;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;

public class VariablesDropSupport
extends ViewerDropAdapter {
    private final TestSuiteModel fModel;

    protected VariablesDropSupport(TreeViewer viewer, TestSuiteModel model) {
        super((Viewer)viewer);
        this.fModel = model;
    }

    public boolean performDrop(Object data) {
        Object target = this.getCurrentTarget();
        Path targetNode = null;
        if (target == null) {
            targetNode = Path.ROOT;
        }
        if (target instanceof TestSuiteModel.Variable) {
            return false;
        }
        if (target instanceof IPath) {
            targetNode = (IPath)target;
        }
        AbstractTreeViewer viewer = (AbstractTreeViewer)super.getViewer();
        IStructuredSelection selection = (IStructuredSelection)data;
        VariablesTreeContentProvider treeContentProvider = (VariablesTreeContentProvider)viewer.getContentProvider();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof TestSuiteModel.Variable) {
                TestSuiteModel.Variable currentVariable = (TestSuiteModel.Variable)element;
                currentVariable.setPath((IPath)targetNode);
            } else if (element instanceof IPath) {
                IPath node = (IPath)element;
                List variables = this.fModel.getVariables();
                targetNode = targetNode.append(node.lastSegment());
                VariablesTreeContentProvider.updatePathGroup(variables, (IPath)targetNode, node);
                treeContentProvider.moveSelectedPath(targetNode.makeRelative(), node);
            }
            ++n2;
        }
        Object[] elements = viewer.getExpandedElements();
        viewer.refresh();
        viewer.setExpandedElements(elements);
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
    }
}

