/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.Logger;
import org.eclipse.ease.ui.scripts.ScriptStorage;

public class FileScriptStorage
extends ScriptStorage {
    public FileScriptStorage(String location) {
        super(location);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean createFile(Path path, String content) {
        URI uri = URI.create(new Path(this.getLocation()).append((IPath)path).toString().replace(" ", "%20"));
        File file = new File(uri);
        if (file.exists() || !file.createNewFile()) return false;
        FileOutputStream outputStream = null;
        outputStream = new FileOutputStream(file);
        outputStream.write(content.getBytes());
        if (outputStream == null) return true;
        try {
            outputStream.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        catch (Exception e) {
            try {
                try {
                    Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not store recorded script.", (Throwable)e);
                    if (outputStream == null) return false;
                }
                catch (Throwable throwable) {
                    if (outputStream == null) throw throwable;
                    try {
                        outputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    outputStream.close();
                    return false;
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (IOException e2) {
                Logger.error((String)"org.eclipse.ease.ui.scripts", (String)"Could not create file", (Throwable)e2);
            }
        }
        return false;
    }

    @Override
    protected boolean createPath(IPath path) {
        File file = new File(URI.create((String.valueOf(this.getLocation()) + "/" + path).replace(" ", "%20")));
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

