/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;

public class TcpsNTAdapter
extends TcpNTAdapter {
    String matchSSLServerCertDNWith;
    boolean fullDNMatch;

    public TcpsNTAdapter(String string, Properties properties) throws NLException {
        super(string, properties);
    }

    public void connect() throws IOException {
        SSLSocketFactory sSLSocketFactory = CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions);
        this.socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.host, this.port);
        String string = (String)this.socketOptions.get(new Integer(2));
        try {
            int n2 = string == null ? 0 : Integer.parseInt(string);
            this.socket.connect(inetSocketAddress, n2);
            String string2 = (String)this.socketOptions.get(new Integer(3));
            if (string2 != null) {
                this.setOption(3, string2);
            }
            this.setSSLSocketOptions();
        }
        catch (NumberFormatException numberFormatException) {
            throw new NetException(505);
        }
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sSLSocket = (SSLSocket)this.socket;
        sSLSocket.setUseClientMode(true);
        TcpsConfigure.configureVersion(sSLSocket, (String)this.socketOptions.get(new Integer(6)));
        TcpsConfigure.configureCipherSuites(sSLSocket, (String)this.socketOptions.get(new Integer(7)));
    }

    public void setOption(int n2, Object object) throws IOException, NetException {
        SSLSocket sSLSocket = (SSLSocket)this.socket;
        switch (n2) {
            case 8: {
                this.setServerDNMatchValue((String[])object);
                break;
            }
            case 7: {
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(n2, object);
            }
        }
    }

    public Object getOption(int n2) throws IOException, NetException {
        SSLSocket sSLSocket = (SSLSocket)this.socket;
        switch (n2) {
            case 2: {
                String string = sSLSocket.getSession().getCipherSuite();
                if (string != null && string.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 5: {
                return sSLSocket.getSession().getCipherSuite();
            }
            case 3: {
                X509Certificate x509Certificate = (X509Certificate)sSLSocket.getSession().getPeerCertificates()[0];
                return x509Certificate.getSubjectDN().getName();
            }
            case 4: {
                return sSLSocket.getSession().getPeerCertificateChain();
            }
            case 6: {
                String string = (String)this.socketOptions.get(new Integer(4));
                if (string == null) {
                    string = System.getProperty("oracle.net.ssl_server_dn_match", "false");
                }
                if (string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE")) {
                    X509Certificate x509Certificate = (X509Certificate)sSLSocket.getSession().getPeerCertificates()[0];
                    String string2 = x509Certificate.getSubjectDN().getName();
                    if (TcpsConfigure.matchServerDN(string2, this.matchSSLServerCertDNWith, this.fullDNMatch)) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "TRUE";
            }
        }
        return super.getOption(n2);
    }

    public void setServerDNMatchValue(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string != null) {
            this.matchSSLServerCertDNWith = string;
            this.fullDNMatch = true;
        } else if (string2 != null) {
            this.matchSSLServerCertDNWith = string2.indexOf(46) != -1 ? "CN=" + string2.substring(0, string2.indexOf(46)) : "CN=" + string2.trim();
        } else if (string3 != null) {
            this.matchSSLServerCertDNWith = string3.indexOf(46) != -1 ? "CN=" + string3.substring(0, string3.indexOf(46)) : "CN=" + string3.trim();
        }
    }
}

