/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.dialog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.dialog.BaseDialogFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.CheckboxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ComboBoxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.HiddenParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ParameterGroupFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.RadioButtonParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.TextBoxParameterFragment;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;

public class ParameterDialogFragment
extends BaseDialogFragment {
    public String getClientId() {
        return "parameterDialog";
    }

    public String getClientName() {
        return "Parameter";
    }

    public String getTitle() {
        return BirtResources.getMessage("birt.viewer.dialog.parameter.title");
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ArrayList<ParameterGroupFragment> fragments = new ArrayList<ParameterGroupFragment>();
        IViewerReportService service = this.getReportService();
        Collection parameters = null;
        BaseAttributeBean attrBean = (BaseAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        options.setOption("locale", attrBean.getLocale());
        options.setOption("timeZone", attrBean.getTimeZone());
        try {
            parameters = service.getParameterDefinitions(attrBean.getReportDesignHandle(request), options, true);
        }
        catch (ReportServiceException e) {
            e.printStackTrace();
        }
        if (parameters != null) {
            Iterator iParameters = parameters.iterator();
            while (iParameters != null && iParameters.hasNext()) {
                Object parameter = iParameters.next();
                if (parameter == null) continue;
                BirtBaseFragment fragment = null;
                if (parameter instanceof ParameterGroupDefinition) {
                    fragment = new ParameterGroupFragment((ParameterGroupDefinition)parameter);
                } else if (parameter instanceof ParameterDefinition) {
                    ParameterDefinition scalarParameter = (ParameterDefinition)parameter;
                    if (!scalarParameter.isHidden()) {
                        switch (scalarParameter.getControlType()) {
                            case 0: {
                                fragment = new TextBoxParameterFragment(scalarParameter);
                                break;
                            }
                            case 1: {
                                fragment = new ComboBoxParameterFragment(scalarParameter);
                                break;
                            }
                            case 2: {
                                fragment = new RadioButtonParameterFragment(scalarParameter);
                                break;
                            }
                            case 3: {
                                fragment = new CheckboxParameterFragment(scalarParameter);
                            }
                        }
                    } else {
                        fragment = new HiddenParameterFragment(scalarParameter);
                    }
                }
                if (fragment == null) continue;
                fragment.setJSPRootPath(this.JSPRootPath);
                fragments.add((ParameterGroupFragment)fragment);
            }
        }
        request.setAttribute("fragments", fragments);
    }
}

