/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.session;

import java.io.File;
import java.io.Serializable;

public class ViewingCache
implements Serializable {
    private static final long serialVersionUID = -348510678864943788L;
    private static final String PREFIX_SUB_DOC_FOLDER = "BIRTDOC";
    private static final String PREFIX_SUB_IMAGE_FOLDER = "BIRTIMG";
    public String documentFolder = null;
    public String imageFolder = null;

    public ViewingCache(String documentFolder, String imageFolder) {
        this.documentFolder = documentFolder;
        this.imageFolder = imageFolder;
        if (!documentFolder.endsWith(File.separator)) {
            this.documentFolder = this.documentFolder + File.separator;
        }
        if (!imageFolder.endsWith(File.separator)) {
            this.imageFolder = this.imageFolder + File.separator;
        }
        this.clearTempFiles();
    }

    public String createDocumentPath(String sessionId, String subSessionId, String filePath) {
        String documentName = null;
        if (filePath == null || filePath.length() == 0) {
            return "";
        }
        String fileSeparator = "\\";
        if (filePath.lastIndexOf(fileSeparator) == -1) {
            fileSeparator = "/";
        }
        documentName = filePath.lastIndexOf(fileSeparator) != -1 ? filePath.substring(filePath.lastIndexOf(fileSeparator) + 1) : filePath;
        return this.documentFolder + this.getSessionSubfolder(PREFIX_SUB_DOC_FOLDER, sessionId, subSessionId) + documentName;
    }

    private String getSessionSubfolder(String prefix, String sessionId, String subSessionId) {
        String folder = "";
        if (sessionId != null) {
            folder = prefix + sessionId + File.separator;
            if (subSessionId != null) {
                folder = folder + subSessionId + File.separator;
            }
        } else {
            folder = "";
        }
        return folder;
    }

    public String getImageTempFolder(String sessionId, String subSessionId) {
        return this.imageFolder + this.getSessionSubfolder(PREFIX_SUB_IMAGE_FOLDER, sessionId, subSessionId);
    }

    public void clearSession(String sessionId, String subSessionId) {
        if (sessionId == null) {
            return;
        }
        ViewingCache.deleteDir(this.documentFolder + this.getSessionSubfolder(PREFIX_SUB_DOC_FOLDER, sessionId, subSessionId));
        ViewingCache.deleteDir(this.imageFolder + this.getSessionSubfolder(PREFIX_SUB_IMAGE_FOLDER, sessionId, subSessionId));
    }

    private void clearTempFiles() {
        int i;
        String[] children;
        File file = new File(this.documentFolder);
        if (file != null && file.isDirectory()) {
            children = file.list();
            for (i = 0; i < children.length; ++i) {
                if (!children[i].startsWith(PREFIX_SUB_DOC_FOLDER)) continue;
                ViewingCache.deleteDir(new File(file, children[i]));
            }
        }
        if ((file = new File(this.imageFolder)) != null && file.isDirectory()) {
            children = file.list();
            for (i = 0; i < children.length; ++i) {
                if (!children[i].startsWith(PREFIX_SUB_IMAGE_FOLDER)) continue;
                ViewingCache.deleteDir(new File(file, children[i]));
            }
        }
    }

    private static boolean deleteDir(String dirName) {
        return ViewingCache.deleteDir(new File(dirName));
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = ViewingCache.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    private static String generateDocumentFromReport(String reportName, String id) {
        if (reportName == null) {
            return null;
        }
        String documentFile = reportName;
        if (reportName.indexOf(46) >= 0) {
            documentFile = reportName.substring(0, reportName.lastIndexOf(46));
        }
        documentFile = id != null && id.length() > 0 ? documentFile + id + ".rptdocument" : documentFile + ".rptdocument";
        return documentFile;
    }

    public String getReportDocument(String reportFile, String sessionId, String subSessionId, String viewerId) {
        if (reportFile == null) {
            return null;
        }
        String documentFile = ViewingCache.generateDocumentFromReport(reportFile, viewerId);
        documentFile = this.createDocumentPath(sessionId, subSessionId, documentFile);
        return documentFile;
    }
}

