/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ejb.ui.internal.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.ejb.ui.internal.actions.AbstractClientJARAction;
import org.eclipse.jst.ejb.ui.internal.plugin.EJBUIPlugin;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientProjectRemovalDataModelProvider;
import org.eclipse.jst.j2ee.project.EJBUtilities;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.ui.UIOperationHandler;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;
import org.eclipse.wst.validation.internal.operations.ValidationOperation;
import org.eclipse.wst.validation.internal.operations.ValidatorSubsetOperation;
import org.eclipse.wst.validation.internal.ui.plugin.ValidationUIPlugin;
import org.osgi.framework.Bundle;

public class EJBClientRemovalAction
extends AbstractClientJARAction {
    public static String LABEL = Platform.getResourceString((Bundle)Platform.getBundle((String)"org.eclipse.jst.ejb.ui"), (String)"%ejb.client.jar.remove.action.description_ui_");

    public EJBClientRemovalAction() {
        this.setText(LABEL);
    }

    protected void primRun(final Shell shell) {
        final IProject ejbProject = this.getProject();
        if (!this.checkClientExists(shell)) {
            return;
        }
        if (!this.checkBinaryProject(shell)) {
            return;
        }
        if (!this.confirmProceed(shell)) {
            return;
        }
        final IProject clientProject = this.getClientProject();
        UIJob clientRemoveJob = new UIJob("Removing EJB Client Project"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                UIOperationHandler opHandler = new UIOperationHandler(shell);
                IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbClientProjectRemovalDataModelProvider());
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.EJB_PROJECT", (Object)ejbProject);
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.EJB_CLIENT_VIEW_PROJECT", (Object)clientProject);
                model.setProperty("IEjbClientProjectRemovalDataModelProperties.OP_HANDLER", (Object)opHandler);
                IStatus status = Status.OK_STATUS;
                try {
                    status = model.getDefaultOperation().execute(monitor, null);
                }
                catch (ExecutionException e) {
                    EJBUIPlugin.logError(e);
                }
                return status;
            }
        };
        clientRemoveJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        clientRemoveJob.setUser(true);
        clientRemoveJob.schedule();
    }

    protected void runValidationOperation(ProgressMonitorDialog dlg) {
        WorkspaceModifyComposedOperation runnable = new WorkspaceModifyComposedOperation();
        ValidatorSubsetOperation sop = new ValidatorSubsetOperation(this.getProject(), true, false);
        sop.setValidators(new String[]{"org.eclipse.jst.j2ee.core.internal.validation.EJBValidator"});
        runnable.addRunnable(ValidationUIPlugin.getRunnableWithProgress((ValidationOperation)sop));
        try {
            dlg.run(true, false, (IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger((String)"org.eclipse.jst.j2ee.ui").logError((Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean checkClientExists(Shell shell) {
        if (this.getClientProject() == null) {
            MessageDialog.openError((Shell)shell, (String)NO_CLIENT_JAR_TITLE, (String)NO_CLIENT_JAR_MSG);
            return false;
        }
        return true;
    }

    private boolean confirmProceed(Shell shell) {
        String message = MessageFormat.format(REMOVE_MESSAGE, this.getClientProject().getName());
        return MessageDialog.openQuestion((Shell)shell, (String)REMOVE_TITLE, (String)message);
    }

    private IProject getClientProject() {
        IProject ejbProject = this.getProject();
        if (ejbProject.exists() && ejbProject.isAccessible()) {
            EJBArtifactEdit edit = null;
            try {
                IVirtualComponent clientComp;
                edit = EJBArtifactEdit.getEJBArtifactEditForRead((IProject)ejbProject);
                if (edit != null && (clientComp = edit.getEJBClientJarModule()) != null) {
                    IProject iProject = clientComp.getProject();
                    return iProject;
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return null;
    }

    private boolean checkBinaryProject(Shell shell) {
        if (JemProjectUtilities.isBinaryProject((IProject)this.getProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_EJB_PROJECT);
            return false;
        }
        if (JemProjectUtilities.isBinaryProject((IProject)this.getClientProject())) {
            MessageDialog.openError((Shell)shell, (String)REMOVE_ERROR_TITLE, (String)BINARY_CLIENT_PROJECT);
            return false;
        }
        return true;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (EJBUtilities.hasEJBClientJARProject((IProject)this.getProject())) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }
}

