/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.CacheMapManager;
import org.eclipse.birt.data.engine.executor.DataSetCacheConfig;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.impl.DataEngineImpl;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.DataSetCacheUtil;
import org.eclipse.birt.data.engine.impl.IEngineExecutionHints;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DataSetCacheManager {
    private IBaseDataSourceDesign dataSourceDesign;
    private IBaseDataSetDesign dataSetDesign;
    private Collection parameterHints;
    private Map appContext;
    private CacheMapManager jvmLevelCacheMapManager;
    private CacheMapManager dteLevelCacheMapManager;
    private CacheMapManager cacheMapManager;
    private IEngineExecutionHints queryExecutionHints;
    private DataEngineContext context;
    private DataEngineSession session;

    public DataSetCacheManager(DataEngineSession session) {
        this.session = session;
        this.context = session.getEngineContext();
        this.queryExecutionHints = ((DataEngineImpl)session.getEngine()).getExecutionHints();
        this.jvmLevelCacheMapManager = new CacheMapManager(true);
        this.dteLevelCacheMapManager = new CacheMapManager(false);
    }

    public IBaseDataSourceDesign getCurrentDataSourceDesign() {
        return this.dataSourceDesign;
    }

    public IBaseDataSetDesign getCurrentDataSetDesign() {
        return this.dataSetDesign;
    }

    public Collection getCurrentParameterHints() {
        if (this.parameterHints != null) {
            return this.parameterHints;
        }
        return new ArrayList();
    }

    public Map getCurrentAppContext() {
        return this.appContext;
    }

    public void setDataSourceAndDataSet(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection parameterHints, Map appContext) {
        this.dataSourceDesign = dataSourceDesign;
        this.dataSetDesign = dataSetDesign;
        this.parameterHints = parameterHints;
        this.appContext = appContext;
    }

    public boolean doesSaveToCache() throws DataException {
        DataSetCacheConfig dscc = this.getDataSetCacheConfig(this.dataSetDesign, this.appContext);
        if (dscc == null) {
            return false;
        }
        this.switchCacheMap(this.dataSetDesign);
        return this.cacheMapManager.doesSaveToCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints), dscc);
    }

    public boolean needsToCache() throws DataException {
        return this.needsToCache(this.dataSetDesign, this.appContext);
    }

    public boolean doesLoadFromCache(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection parameterHints, Map appContext) throws DataException {
        DataSetCacheConfig dscc = this.getDataSetCacheConfig(dataSetDesign, appContext);
        if (dscc == null) {
            return false;
        }
        this.setDataSourceAndDataSet(dataSourceDesign, dataSetDesign, parameterHints, appContext);
        this.switchCacheMap(dataSetDesign);
        return this.cacheMapManager.doesLoadFromCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, dataSetDesign, parameterHints), dscc.getCacheCapability());
    }

    public boolean needsToCache(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        return this.getDataSetCacheConfig(dataSetDesign, appContext) != null;
    }

    private DataSetCacheConfig getDataSetCacheConfig(IBaseDataSetDesign dataSetDesign, Map appContext) throws DataException {
        DataSetCacheConfig result = DataSetCacheUtil.getJVMDataSetCacheConfig(appContext, this.context, dataSetDesign);
        if (result == null) {
            result = DataSetCacheUtil.getDteDataSetCacheConfig(this.queryExecutionHints, dataSetDesign, this.session, appContext);
        }
        return result;
    }

    public int getCacheCapability() throws DataException {
        DataSetCacheConfig dscc = this.getDataSetCacheConfig(this.dataSetDesign, this.appContext);
        if (dscc != null) {
            return dscc.getCacheCapability();
        }
        return 0;
    }

    public int getCacheCountConfig() throws DataException {
        DataSetCacheConfig dscc = this.getDataSetCacheConfig(this.dataSetDesign, this.appContext);
        if (dscc != null) {
            return dscc.getCountConfig();
        }
        return 0;
    }

    public void clearCache(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign) throws DataException {
        if (dataSourceDesign == null || dataSetDesign == null) {
            return;
        }
        DataSourceAndDataSet ds = DataSourceAndDataSet.newInstance(dataSourceDesign, dataSetDesign, null);
        this.jvmLevelCacheMapManager.clearCache(ds);
        this.dteLevelCacheMapManager.clearCache(ds);
    }

    public IDataSetCacheObject getCacheObject() throws DataException {
        this.switchCacheMap(this.dataSetDesign);
        return this.cacheMapManager.getCacheObject(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints));
    }

    public boolean doesLoadFromCache() throws DataException {
        DataSetCacheConfig dscc = this.getDataSetCacheConfig(this.dataSetDesign, this.appContext);
        if (dscc == null) {
            return false;
        }
        this.switchCacheMap(this.dataSetDesign);
        return this.cacheMapManager.doesLoadFromCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints), dscc.getCacheCapability());
    }

    public void resetForTest() {
        this.dataSourceDesign = null;
        this.dataSetDesign = null;
        if (this.cacheMapManager != null) {
            this.cacheMapManager.resetForTest();
        }
    }

    public IResultMetaData getCachedResultMetadata(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws DataException {
        IResultClass resultClass = this.jvmLevelCacheMapManager.getCachedResultClass(DataSourceAndDataSet.newInstance(dataSource, dataSet, null));
        if (resultClass != null) {
            return new ResultMetaData(resultClass);
        }
        return null;
    }

    private void switchCacheMap(IBaseDataSetDesign dataSetDesign) throws DataException {
        this.cacheMapManager = DataSetCacheUtil.getJVMDataSetCacheConfig(this.appContext, this.context, dataSetDesign) != null ? this.jvmLevelCacheMapManager : this.dteLevelCacheMapManager;
    }
}

