/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.olap.OLAPException;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.cursor.AbstractCursorSupport;
import org.eclipse.birt.data.engine.olap.cursor.DrilledAggregationAccessor;
import org.eclipse.birt.data.engine.olap.cursor.EdgeCursorImpl;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.DrilledEdgeAxis;
import org.eclipse.birt.data.engine.olap.impl.query.DrillQueryHelper;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtEdgeView;

public class MergedCubeCursor
extends AbstractCursorSupport
implements CubeCursor {
    private CubeCursor baseCursor;
    private List<EdgeCursor> ordinateEdge = new ArrayList<EdgeCursor>();

    public MergedCubeCursor(CubeCursor baseCursor, BirtCubeView originalView, BirtCubeView baseView, DrillQueryHelper drillQueryHelper) throws IOException, DataException {
        super(null, new DrilledAggregationAccessor(baseCursor, baseView, drillQueryHelper));
        BirtEdgeView metaView;
        this.baseCursor = baseCursor;
        if (baseView.getColumnEdgeView() != null) {
            ArrayList<IAggregationResultSet> drillOnColumnRs = new ArrayList<IAggregationResultSet>();
            metaView = baseView.getColumnEdgeView();
            int i = 0;
            while (i < drillQueryHelper.getCubeViewOnColumnEdge().length) {
                drillOnColumnRs.add(drillQueryHelper.getCubeViewOnColumnEdge()[i].getColumnEdgeView().getEdgeAxis().getRowDataAccessor().getAggregationResultSet());
                ++i;
            }
            DrilledEdgeAxis edgeAxis = new DrilledEdgeAxis(originalView.getColumnEdgeView().getEdgeAxis().getRowDataAccessor().getAggregationResultSet(), drillOnColumnRs, metaView, null, originalView.getColumnEdgeView().getEdgeDefinition().getDrillFilter());
            EdgeCursorImpl columnEdgeCursor = new EdgeCursorImpl(metaView, false, edgeAxis, this);
            edgeAxis.populateEdgeInfo(false);
            this.ordinateEdge.add(columnEdgeCursor);
            originalView.getColumnEdgeView().setEdgeCursor(columnEdgeCursor);
            originalView.getColumnEdgeView().setEdgeAxis(edgeAxis);
        }
        if (baseView.getRowEdgeView() != null) {
            ArrayList<IAggregationResultSet> drillOnRowRs = new ArrayList<IAggregationResultSet>();
            metaView = baseView.getRowEdgeView();
            int i = 0;
            while (i < drillQueryHelper.getCubeViewOnRowEdge().length) {
                drillOnRowRs.add(drillQueryHelper.getCubeViewOnRowEdge()[i].getRowEdgeView().getEdgeAxis().getRowDataAccessor().getAggregationResultSet());
                ++i;
            }
            DrilledEdgeAxis edgeAxis = new DrilledEdgeAxis(originalView.getRowEdgeView().getEdgeAxis().getRowDataAccessor().getAggregationResultSet(), drillOnRowRs, metaView, null, originalView.getRowEdgeView().getEdgeDefinition().getDrillFilter());
            EdgeCursorImpl rowEdgeCursor = new EdgeCursorImpl(metaView, false, edgeAxis, this);
            edgeAxis.populateEdgeInfo(false);
            this.ordinateEdge.add(rowEdgeCursor);
            originalView.getRowEdgeView().setEdgeCursor(rowEdgeCursor);
            originalView.getRowEdgeView().setEdgeAxis(edgeAxis);
        }
    }

    public List getOrdinateEdge() throws OLAPException {
        return this.ordinateEdge;
    }

    public Collection getPageEdge() throws OLAPException {
        return this.baseCursor.getPageEdge();
    }

    public void synchronizePages() throws OLAPException {
        this.baseCursor.synchronizePages();
    }
}

