/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayAccess;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BlockComment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.CharacterLiteral;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConditionalExpression;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionExpression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.FunctionRef;
import org.eclipse.wst.jsdt.core.dom.FunctionRefParameter;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.InferredType;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.InstanceofExpression;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.LineComment;
import org.eclipse.wst.jsdt.core.dom.ListExpression;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParenthesizedExpression;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.RegularExpressionLiteral;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperFieldAccess;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;

public class BreakpointLocationFinder
extends ASTVisitor {
    public static final String DEBUGGER = "debugger";
    public static final int UNKNOWN = -1;
    public static final int LINE = 0;
    public static final int FUNCTION = 1;
    private int location = -1;
    private JavaScriptUnit jsunit = null;
    private String functionName = null;
    private int offset = -1;
    private boolean found = false;
    private boolean resolvedbindings = false;
    private ArrayList labels = new ArrayList();
    private int linenumber = -1;

    public BreakpointLocationFinder(JavaScriptUnit jsunit, int linenumber, boolean resolvedbindings) {
        this.jsunit = jsunit;
        this.linenumber = linenumber;
        this.resolvedbindings = resolvedbindings;
    }

    int lineNumber(int offset) {
        int lineNumber = this.jsunit.getLineNumber(offset);
        return lineNumber < 1 ? 1 : lineNumber;
    }

    String getLabel() {
        if (this.labels == null || this.labels.isEmpty()) {
            return null;
        }
        return (String)this.labels.get(this.labels.size() - 1);
    }

    void nestLabel(String label) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        this.labels.add(label);
    }

    void popLabel() {
        if (this.labels == null || this.labels.isEmpty()) {
            return;
        }
        this.labels.remove(this.labels.size() - 1);
    }

    boolean visit(ASTNode node, boolean isCode) {
        if (this.found) {
            return false;
        }
        int startPosition = node.getStartPosition();
        int endLine = this.lineNumber(startPosition + node.getLength() - 1);
        if (endLine < this.linenumber) {
            return false;
        }
        int startLine = this.lineNumber(startPosition);
        if (isCode && this.linenumber <= startLine) {
            this.linenumber = startLine;
            this.found = true;
            this.offset = startPosition;
            this.location = 0;
            return false;
        }
        return true;
    }

    public int getLocation() {
        return this.location;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getLineNumber() {
        return this.linenumber;
    }

    public void preVisit(ASTNode node) {
        super.preVisit(node);
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ArrayAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayCreation node) {
        return this.visit((ASTNode)node, node.getInitializer() == null);
    }

    public boolean visit(ArrayInitializer node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ArrayType node) {
        return false;
    }

    public boolean visit(Assignment node) {
        if (this.visit((ASTNode)node, false)) {
            IVariableBinding binding;
            int startLine;
            Expression leftHandSide = node.getLeftHandSide();
            if (leftHandSide instanceof Name && this.linenumber < (startLine = this.lineNumber(node.getStartPosition())) && this.resolvedbindings && (binding = (IVariableBinding)((Name)leftHandSide).resolveBinding()) != null && (!binding.isField() || Modifier.isStatic((int)binding.getModifiers()))) {
                node.getRightHandSide().accept((ASTVisitor)this);
            }
            return true;
        }
        return false;
    }

    public boolean visit(Block node) {
        if (this.visit((ASTNode)node, false)) {
            if (node.statements().isEmpty() && node.getParent().getNodeType() == 31) {
                int offset = node.getStartPosition();
                this.linenumber = this.lineNumber(offset + node.getLength() - 1);
                this.found = true;
                this.location = 0;
                this.offset = offset;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean visit(BlockComment node) {
        return false;
    }

    public boolean visit(BooleanLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(BreakStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(CatchClause node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(CharacterLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ClassInstanceCreation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ConditionalExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ContinueStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(DoStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(EmptyStatement node) {
        return false;
    }

    public boolean visit(EnhancedForStatement node) {
        if (this.visit((ASTNode)node, false)) {
            node.getExpression().accept((ASTVisitor)this);
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ExpressionStatement node) {
        SimpleName name;
        if (this.found) {
            return false;
        }
        Expression child = node.getExpression();
        if (child.getNodeType() == 42 && (name = (SimpleName)child).getFullyQualifiedName().equals(DEBUGGER)) {
            this.location = -1;
            return false;
        }
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(FieldAccess node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(FieldDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List frags = node.fragments();
            if (frags.size() == 1) {
                int offset = ((VariableDeclarationFragment)frags.get(0)).getName().getStartPosition();
                if (this.lineNumber(offset) == this.linenumber) {
                    this.location = 0;
                    this.offset = offset;
                    this.found = true;
                    return false;
                }
            } else {
                Iterator iter = frags.iterator();
                while (iter.hasNext()) {
                    ((VariableDeclarationFragment)iter.next()).accept((ASTVisitor)this);
                }
            }
        }
        return false;
    }

    public boolean visit(ForInStatement node) {
        if (this.visit((ASTNode)node, true)) {
            node.getBody().accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(ForStatement node) {
        return this.visit((ASTNode)node, node.initializers().isEmpty() && node.getExpression() == null && node.updaters().isEmpty());
    }

    public boolean visit(FunctionDeclaration node) {
        int nameOffset = node.getStartPosition();
        if (this.lineNumber(nameOffset) == this.linenumber) {
            this.location = 1;
            this.found = true;
            this.functionName = node.getName() == null ? null : node.getName().getIdentifier();
            this.offset = nameOffset;
            return false;
        }
        Block body = node.getBody();
        if (body != null) {
            body.accept((ASTVisitor)this);
        }
        return false;
    }

    public boolean visit(FunctionExpression node) {
        node.getMethod().accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(FunctionInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(FunctionRef node) {
        return false;
    }

    public boolean visit(FunctionRefParameter node) {
        return false;
    }

    public boolean visit(IfStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(ImportDeclaration node) {
        return false;
    }

    public boolean visit(InferredType node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(InfixExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(Initializer node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(InstanceofExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(JavaScriptUnit node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(JSdoc node) {
        return false;
    }

    public boolean visit(LabeledStatement node) {
        this.nestLabel(node.getLabel().getFullyQualifiedName());
        return this.visit((ASTNode)node, false);
    }

    public void endVisit(LabeledStatement node) {
        this.popLabel();
    }

    public boolean visit(LineComment node) {
        return false;
    }

    public boolean visit(ListExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(MemberRef node) {
        return false;
    }

    public boolean visit(Modifier node) {
        return false;
    }

    public boolean visit(NullLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(NumberLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ObjectLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ObjectLiteralField node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(ParenthesizedExpression node) {
        return true;
    }

    public boolean visit(PostfixExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PrefixExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(PrimitiveType node) {
        return false;
    }

    public boolean visit(QualifiedName node) {
        this.visit((ASTNode)node, true);
        return false;
    }

    public boolean visit(QualifiedType node) {
        return false;
    }

    public boolean visit(RegularExpressionLiteral node) {
        return false;
    }

    public boolean visit(ReturnStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SimpleName node) {
        return this.visit((ASTNode)node, !node.getFullyQualifiedName().equals(this.getLabel()));
    }

    public boolean visit(SimpleType node) {
        return false;
    }

    public boolean visit(SingleVariableDeclaration node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(StringLiteral node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperConstructorInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperFieldAccess node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(SwitchCase node) {
        return false;
    }

    public boolean visit(SwitchStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TagElement node) {
        return false;
    }

    public boolean visit(TextElement node) {
        return false;
    }

    public boolean visit(ThisExpression node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(ThrowStatement node) {
        return this.visit((ASTNode)node, true);
    }

    public boolean visit(TryStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeDeclaration node) {
        if (this.visit((ASTNode)node, false)) {
            List bdecls = node.bodyDeclarations();
            Iterator iter = bdecls.iterator();
            while (iter.hasNext()) {
                ((BodyDeclaration)iter.next()).accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(TypeDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(TypeLiteral node) {
        return false;
    }

    public boolean visit(UndefinedLiteral node) {
        return false;
    }

    public boolean visit(VariableDeclarationExpression node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(VariableDeclarationFragment node) {
        Expression init = node.getInitializer();
        if (this.visit((ASTNode)node, false) && init != null) {
            int offset;
            int startLine;
            init.accept((ASTVisitor)this);
            if (!this.found && this.linenumber == (startLine = this.lineNumber(offset = node.getName().getStartPosition()))) {
                this.linenumber = startLine;
                this.found = true;
                this.location = 0;
                this.offset = offset;
                return false;
            }
        }
        return false;
    }

    public boolean visit(VariableDeclarationStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(WhileStatement node) {
        return this.visit((ASTNode)node, false);
    }

    public boolean visit(WithStatement node) {
        return this.visit((ASTNode)node, false);
    }
}

