/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupStore
implements IBackupStore {
    private static final String ROOTCHAR = "_";
    private final File backupRoot;
    private String backupName;
    private String dummyName;
    private ServerSocket socket = null;
    private long backupCounter;
    private long restoreCounter;
    private boolean closed;
    private static long msCounter = 0L;

    public BackupStore() {
        this(null, ".p2bu");
    }

    public BackupStore(File buParentDirectory, String prefix) {
        if (buParentDirectory == null) {
            buParentDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        this.backupRoot = buParentDirectory;
        String unique = this.genUnique();
        this.dummyName = new StringBuffer(String.valueOf(prefix)).append("d_").append(unique).toString();
        this.backupName = new StringBuffer(String.valueOf(prefix)).append(ROOTCHAR).append(unique).toString();
        this.backupCounter = 0L;
        this.restoreCounter = 0L;
        this.closed = false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getBackupName() {
        return this.backupName;
    }

    public File getBackupRoot() {
        return this.backupRoot;
    }

    @Override
    public boolean backup(File file) throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException("Can not perform backup()");
        }
        if (!file.exists()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            return this.backupDirectory(file);
        }
        File buRoot = this.backupRoot;
        File buDir = new File(buRoot, this.backupName);
        File buFile = new File(buDir, this.makeRelativeFromRoot(file = this.makeParentCanonical(file)).getPath());
        if (buFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buFile.getAbsolutePath()));
        }
        if (buFile.exists()) {
            return false;
        }
        buFile.getParentFile().mkdirs();
        if (buFile.getParentFile().exists() && !buFile.getParentFile().isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_file_directory_mismatch, (Object)buFile.getParentFile().getAbsolutePath()));
        }
        if (file.renameTo(buFile)) {
            ++this.backupCounter;
            return true;
        }
        Util.copyStream(new FileInputStream(file), true, new FileOutputStream(buFile), true);
        ++this.backupCounter;
        if (!file.delete()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_delete_after_copy_0, (Object)file));
        }
        return true;
    }

    @Override
    public void backupAll(File file) throws IOException {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if ((file = this.makeParentCanonical(file)).isDirectory() && (files = file.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                this.backupAll(files[i]);
                ++i;
            }
        }
        this.backup(file);
    }

    @Override
    public void backupCopyAll(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if ((file = this.makeParentCanonical(file)).isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    this.backupCopyAll(files[i]);
                    ++i;
                }
            }
            if (files == null || files.length == 0) {
                this.backupDirectory(file);
                file.mkdir();
            }
        } else {
            this.backupCopy(file);
        }
    }

    @Override
    public boolean backupCopy(File file) throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException(Messages.BackupStore_backupCopy_closed_store);
        }
        if (!file.exists()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_file_not_found, (Object)file.getAbsolutePath()));
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_can_not_copy_directory, (Object)file.getAbsolutePath()));
        }
        File buDir = new File(this.backupRoot, this.backupName);
        File buFile = new File(buDir, this.makeRelativeFromRoot(file = this.makeParentCanonical(file)).getPath());
        if (buFile.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_file_mismatch, (Object)buFile.getAbsolutePath()));
        }
        if (buFile.exists()) {
            return false;
        }
        buFile.getParentFile().getCanonicalFile().mkdirs();
        if (buFile.getParentFile().exists() && !buFile.getParentFile().isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_file_directory_mismatch, (Object)buFile.getParentFile().getAbsolutePath()));
        }
        Util.copyStream(new FileInputStream(file), true, new FileOutputStream(buFile), true);
        ++this.backupCounter;
        return true;
    }

    @Override
    public boolean backupDirectory(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_not_a_directory, (Object)file.getAbsolutePath()));
        }
        if ((file = this.makeParentCanonical(file)).list().length != 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BackupStore_directory_not_empty, (Object)file.getAbsolutePath()));
        }
        File dummy = new File(file, this.dummyName);
        if (!dummy.createNewFile()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_create_dummy, (Object)dummy.getAbsolutePath()));
        }
        boolean result = this.backup(dummy);
        if (result && !file.delete()) {
            throw new IOException(NLS.bind((String)Messages.BackupStore_can_not_remove, (Object)dummy.getAbsolutePath()));
        }
        return result;
    }

    @Override
    public void restore() throws IOException {
        if (this.closed) {
            throw new ClosedBackupStoreException(Messages.BackupStore_restore_closed_store);
        }
        HashSet<File> unrestorable = new HashSet<File>();
        boolean restored = true;
        if (!this.backupRoot.exists()) {
            BackupStore.logError(NLS.bind((String)Messages.BackupStore_missing_backup_directory, (Object)this.backupRoot.getAbsolutePath()));
            restored = false;
        } else {
            this.restoreRoots(new File(this.backupRoot, this.backupName), unrestorable);
        }
        this.logUnrestorables(unrestorable);
        if (unrestorable.size() > 0) {
            restored = false;
        }
        this.close(restored);
        this.closed = true;
    }

    private void logUnrestorables(Set<File> unrestorable) {
        if (unrestorable != null && unrestorable.size() > 0) {
            for (File file : unrestorable) {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_manual_restore_needed, (Object)file.getAbsolutePath()));
            }
        }
    }

    @Override
    public void discard() {
        if (this.closed) {
            return;
        }
        this.closeSocket();
        this.removeBackups();
        this.closed = true;
    }

    private void close(boolean fullyRestored) throws IOException {
        this.closeSocket();
        if (this.backupCounter != this.restoreCounter) {
            if (!fullyRestored) {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_0_of_1_items_restored, (Object)new Long(this.restoreCounter), (Object)new Long(this.backupCounter)));
            } else {
                BackupStore.logError(NLS.bind((String)Messages.BackupStore_externally_modified_0_of_1_restored, (Object)new Long(this.restoreCounter), (Object)new Long(this.backupCounter)));
                fullyRestored = false;
            }
        }
        if (!fullyRestored) {
            throw new IOException(Messages.BackupStore_errors_while_restoring_see_log);
        }
        this.removeBackups();
    }

    private void closeSocket() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_close_tcp_port, (Object)new Integer(this.socket.getLocalPort())));
            }
        }
    }

    private void removeBackups() {
        File buRoot = new File(this.backupRoot, this.backupName);
        if (!this.fullyDelete(buRoot)) {
            BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_remove_bu_directory, (Object)buRoot.getAbsolutePath()));
        }
    }

    private static void logWarning(String message) {
        LogHelper.log((IStatus)BackupStore.createWarning(message));
    }

    private static IStatus createWarning(String message) {
        return new Status(2, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    private static void logError(String message) {
        LogHelper.log((IStatus)BackupStore.createError(message));
    }

    private static IStatus createError(String message) {
        return new Status(4, "org.eclipse.equinox.p2.touchpoint.natives", message);
    }

    private boolean fullyDelete(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                if (!this.fullyDelete(new File(file, children[i].getName()))) {
                    return false;
                }
                ++i;
            }
        }
        return file.delete();
    }

    /*
     * Unable to fully structure code
     */
    private void restore(File root, File buRoot, Set<File> unrestorable) {
        children = buRoot.listFiles();
        if (children == null) {
            unrestorable.add(buRoot);
            return;
        }
        i = 0;
        while (i < children.length) {
            block13: {
                block14: {
                    block15: {
                        bu = new File(buRoot, children[i].getName());
                        target = new File(root, bu.getName());
                        if (!bu.isDirectory()) break block14;
                        if (target.exists() || target.mkdir()) break block15;
                        unrestorable.add(bu);
                        break block13;
                    }
                    if (!target.exists() || target.isDirectory()) ** GOTO lbl-1000
                    target.delete();
                    if (!target.mkdir()) {
                        unrestorable.add(bu);
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.restore(target, bu, unrestorable);
                    }
                    break block13;
                }
                if (bu.getName().equals(this.dummyName)) {
                    ++this.restoreCounter;
                } else {
                    if (target.exists()) {
                        this.fullyDelete(target);
                    }
                    if (!bu.renameTo(target)) {
                        try {
                            Util.copyStream(new FileInputStream(bu), true, new FileOutputStream(target), true);
                            ++this.restoreCounter;
                        }
                        catch (FileNotFoundException v0) {
                            unrestorable.add(bu);
                            break block13;
                        }
                        catch (IOException v1) {
                            unrestorable.add(bu);
                            break block13;
                        }
                        if (!bu.delete()) {
                            BackupStore.logWarning(NLS.bind((String)Messages.BackupStore_can_not_delete_tmp_file, (Object)bu.getAbsolutePath()));
                        }
                    } else {
                        ++this.restoreCounter;
                    }
                }
            }
            ++i;
        }
    }

    private void restoreRoots(File buRoot, Set<File> unrestorable) {
        File[] children = buRoot.listFiles();
        if (children == null) {
            unrestorable.add(buRoot);
            return;
        }
        int i = 0;
        while (i < children.length) {
            String name;
            String rName = name = children[i].getName();
            String prefix = "";
            while (rName.startsWith(ROOTCHAR)) {
                prefix = new StringBuffer(String.valueOf(prefix)).append(File.separator).toString();
                rName = rName.substring(1);
            }
            rName = prefix.length() < 1 ? new StringBuffer(String.valueOf(rName)).append(":").append(File.separator).toString() : new StringBuffer(String.valueOf(prefix)).append(rName).toString();
            File bu = new File(buRoot, name);
            File target = new File(rName);
            if (!bu.isDirectory()) {
                unrestorable.add(bu);
            } else if (!target.exists() || !target.isDirectory()) {
                unrestorable.add(bu);
            } else {
                this.restore(target, bu, unrestorable);
            }
            ++i;
        }
    }

    private String genUnique() {
        long timePart = System.currentTimeMillis() << 5 | msCounter++ & 0x1FL;
        long ipPart = 0L;
        try {
            byte[] address = InetAddress.getLocalHost().getAddress();
            int i = 0;
            while (i < address.length) {
                ipPart = ipPart << 8 | (long)(address[i] & 0xFF);
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {}
        int port = 0;
        try {
            this.socket = new ServerSocket(0);
            port = this.socket.getLocalPort();
        }
        catch (IOException iOException) {
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException2) {}
            port = new Random().nextInt() & 0xFFFF;
        }
        long aPart = ipPart << 16 | (long)(port & 0xFFFF);
        return new StringBuffer(String.valueOf(Long.toHexString(timePart))).append(ROOTCHAR).append(Long.toHexString(aPart)).toString();
    }

    private File makeRelativeFromRoot(File file) {
        File absolute = file.getAbsoluteFile();
        String path = absolute.getPath();
        String prefix = "";
        while (path.startsWith(File.separator)) {
            prefix = new StringBuffer(String.valueOf(prefix)).append(ROOTCHAR).toString();
            path = path.substring(1);
        }
        if (prefix.length() > 0) {
            path = new StringBuffer(String.valueOf(prefix)).append(File.separator).append(path).toString();
            return new File(path);
        }
        int idx = path.indexOf(":");
        if (idx < 1) {
            throw new InternalError(new StringBuffer("File is neither absolute nor has a drive name: ").append(path).toString());
        }
        path = new StringBuffer(String.valueOf(path.substring(0, idx))).append(path.substring(idx + 1)).toString();
        return new File(path);
    }

    private File makeParentCanonical(File file) throws IOException {
        return new File(file.getParentFile().getCanonicalFile(), file.getName());
    }
}

