/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.wizards.pages.messagewidgets.detailtabs.MessageDataAttributeTabItem;
import org.eclipse.ebam.emf.DataAttributeTransactions;
import org.eclipse.ebam.emf.MessageTransactions;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDataAttributeTabFunctions {
    MessageDataAttributeTabItem itemSelectedPage;
    private static Logger logger = LoggerFactory.getLogger(MessageDataAttributeTabFunctions.class);
    Map<Integer, SbiDomain> idToAttr = new HashMap<Integer, SbiDomain>();
    Map<Integer, Integer> indexToAttrId = new HashMap<Integer, Integer>();
    Map<Integer, Integer> attrIdToIndex = new HashMap<Integer, Integer>();

    public MessageDataAttributeTabFunctions(MessageDataAttributeTabItem item) {
        this.itemSelectedPage = item;
    }

    public void addDataAttributeSelection(TableItem tableItem) throws Exception {
        String expression;
        logger.debug("IN");
        this.disableDataAttributeDetail();
        Integer id = (Integer)tableItem.getData();
        DataAttribute dataAttribute = new DataAttributeTransactions().getDataAttributeById(id);
        String name = dataAttribute.getName();
        if (name == null) {
            name = "";
        }
        if ((expression = dataAttribute.getExpression()) == null) {
            expression = "";
        }
        this.itemSelectedPage.getNameText().setText(name);
        this.itemSelectedPage.getExpressionText().setText(expression);
        String dataType = dataAttribute.getDataType();
        String attrType = dataAttribute.getAttrType();
        Combo dataCombo = this.itemSelectedPage.getDataTypeCombo();
        Combo attrCombo = this.itemSelectedPage.getAttrTypeCombo();
        String[] dataItems = dataCombo.getItems();
        int i = 0;
        while (i < dataItems.length) {
            String nameD = dataItems[i];
            if (nameD.equalsIgnoreCase(dataType)) {
                dataCombo.select(i);
            }
            ++i;
        }
        String[] attrItems = attrCombo.getItems();
        int i2 = 0;
        while (i2 < attrItems.length) {
            String nameD = attrItems[i2];
            if (nameD.equalsIgnoreCase(attrType)) {
                dataCombo.select(i2);
            }
            ++i2;
        }
        this.setPageAfterDataAttributeSelection();
        logger.debug("OUT");
    }

    private void setPageAfterDataAttributeSelection() {
        this.handleEventButtons(true, true, true);
        this.itemSelectedPage.getButtonSaveValue().setVisible(true);
        this.itemSelectedPage.getNameText().setEditable(true);
        this.itemSelectedPage.getNameText().setEditable(true);
    }

    public void eraseDataAttributePush() throws WizardException {
        logger.debug("IN");
        Table table = this.itemSelectedPage.getDataAttributeTable();
        int indexSelected = table.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = table.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            DataAttribute dataAttribute = null;
            try {
                dataAttribute = new DataAttributeTransactions().getDataAttributeById(id);
                new DataAttributeTransactions().deleteDataAttribute(dataAttribute);
            }
            catch (Exception e) {
                logger.error("error in erasing data attribute");
                throw new WizardException(e, "error in erasing data attribute");
            }
            table.remove(indexSelected);
            table.redraw();
            this.setPageAfterEraseButtonPush(table);
        }
        logger.debug("OUT");
    }

    private void setPageAfterEraseButtonPush(Table table) {
        table.setSelection(-1);
        this.disableDataAttributeDetail();
        this.handleEventButtons(true, false, false);
    }

    public void saveValueButtonPush(Integer thresholdId) throws Exception {
        DataAttribute dataAttribute;
        boolean updating = false;
        int selectedIndex = this.itemSelectedPage.getDataAttributeTable().getSelectionIndex();
        if (selectedIndex != -1) {
            updating = true;
            TableItem itemSel = this.itemSelectedPage.getDataAttributeTable().getItem(selectedIndex);
            Integer id = (Integer)itemSel.getData();
            dataAttribute = new DataAttributeTransactions().getDataAttributeById(id);
        } else {
            updating = false;
            dataAttribute = new DataAttribute();
        }
        Integer messageId = this.itemSelectedPage.getSelectedMessageId();
        Message message = new MessageTransactions().getMessageById(messageId);
        String name = this.itemSelectedPage.getNameText().getText();
        String expression = this.itemSelectedPage.getExpressionText().getText();
        String dataType = this.itemSelectedPage.getDataTypeCombo().getText();
        String attrType = this.itemSelectedPage.getAttrTypeCombo().getText();
        dataAttribute.setName(name);
        dataAttribute.setExpression(expression);
        dataAttribute.setDataType(dataType);
        dataAttribute.setAttrType(attrType);
        dataAttribute.setMessage(message);
        if (!updating) {
            new DataAttributeTransactions().createNewDataAttribute(dataAttribute);
            dataAttribute.getAttributeId();
            Table table = this.itemSelectedPage.getDataAttributeTable();
            TableItem tableItem = new TableItem(table, 0);
            Integer id = dataAttribute.getAttributeId();
            tableItem.setData((Object)id);
            tableItem.setText(0, dataAttribute.getName());
            tableItem.setText(1, dataAttribute.getExpression());
        } else {
            new DataAttributeTransactions().mergeDataAttribute(dataAttribute);
            dataAttribute.getAttributeId();
        }
        this.itemSelectedPage.getDataAttributeTable().setSelection(-1);
        this.itemSelectedPage.getDataAttributeTable().redraw();
        this.handleEventButtons(true, false, false);
        logger.debug("OUT");
    }

    public void addAddButtonPush(Integer thresholdId) throws Exception {
        this.fillEmptyValues();
        this.itemSelectedPage.getButtonSaveValue().setVisible(true);
        this.itemSelectedPage.getButtonSaveValue().redraw();
        this.itemSelectedPage.getNameText().setEditable(true);
        this.itemSelectedPage.getDataAttributeTable().setSelection(-1);
    }

    public void fillEmptyValues() {
        this.itemSelectedPage.getNameText().setText("");
        this.itemSelectedPage.getExpressionText().setText("");
        this.itemSelectedPage.getDataTypeCombo().select(0);
        this.itemSelectedPage.getAttrTypeCombo().select(0);
    }

    public void disableDataAttributeDetail() {
        this.itemSelectedPage.getNameText().setEnabled(false);
        this.itemSelectedPage.getExpressionText().setEnabled(false);
        this.itemSelectedPage.getDataTypeCombo().setEnabled(false);
        this.itemSelectedPage.getAttrTypeCombo().setEnabled(false);
    }

    public void enableDataAttributeDetail(TableItem tableItem) {
        this.itemSelectedPage.getNameText().setEnabled(true);
        this.itemSelectedPage.getExpressionText().setEnabled(true);
        this.itemSelectedPage.getDataTypeCombo().setEnabled(true);
        this.itemSelectedPage.getAttrTypeCombo().setEnabled(true);
    }

    public Map<Integer, SbiDomain> getIdToAttr() {
        return this.idToAttr;
    }

    public void setIdToAttr(Map<Integer, SbiDomain> idToAttr) {
        this.idToAttr = idToAttr;
    }

    public Map<Integer, Integer> getIndexToAttrId() {
        return this.indexToAttrId;
    }

    public void setIndexToAttrId(Map<Integer, Integer> indexToAttrId) {
        this.indexToAttrId = indexToAttrId;
    }

    public Map<Integer, Integer> getAttrIdToIndex() {
        return this.attrIdToIndex;
    }

    public void setAttrIdToIndex(Map<Integer, Integer> attrIdToIndex) {
        this.attrIdToIndex = attrIdToIndex;
    }

    public void handleEventButtons(boolean add, boolean erase, boolean save) {
        this.itemSelectedPage.getButtonAdd().setEnabled(add);
        this.itemSelectedPage.getButtonErase().setEnabled(erase);
        this.itemSelectedPage.getButtonSaveValue().setVisible(save);
    }
}

