/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.ide.ui;

import java.lang.reflect.Method;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.ide.ui.AbstractMarkerInterestFilter;
import org.eclipse.ui.views.markers.MarkerItem;

public class MarkerInterestFilter
extends AbstractMarkerInterestFilter {
    private Method markerCategoryMethod = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (!(element instanceof MarkerItem)) return false;
        if (element.getClass().getSimpleName().equals("MarkerCategory")) {
            try {
                Object[] entries;
                if (this.markerCategoryMethod == null) {
                    Class<?> markerCategoryClass = Class.forName("org.eclipse.ui.internal.views.markers.MarkerCategory");
                    this.markerCategoryMethod = markerCategoryClass.getDeclaredMethod("getChildren", new Class[0]);
                    this.markerCategoryMethod.setAccessible(true);
                }
                if ((entries = (Object[])this.markerCategoryMethod.invoke(element, new Object[0])) != null && entries.length == 0) {
                    return false;
                }
                if (entries == null || entries.length == 0) return true;
                Object[] objectArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        return false;
                    }
                    Object markerEntry = objectArray[n2];
                    if (markerEntry.getClass().getSimpleName().equals("MarkerEntry") && this.isInteresting(((MarkerItem)markerEntry).getMarker(), viewer, parent)) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.ide", "Could not access marker view elements."));
            }
            return true;
        }
        if (!element.getClass().getSimpleName().equals("MarkerEntry")) return false;
        return this.isInteresting(((MarkerItem)element).getMarker(), viewer, parent);
    }

    protected boolean isImplicitlyInteresting(IMarker marker) {
        try {
            Object severity = marker.getAttribute("severity");
            return severity != null && severity.equals(2);
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

