/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.orm;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.core.resource.orm.AccessType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class OrmXmlResourceProvider
extends AbstractXmlResourceProvider
implements OrmFileCreationDataModelProperties {
    public static OrmXmlResourceProvider getXmlResourceProvider(IFile file) {
        return OrmXmlResourceProvider.getXmlResourceProvider_(file.getProject(), file.getFullPath().toString());
    }

    public static OrmXmlResourceProvider getXmlResourceProvider(IProject project, String deployLocation) {
        return OrmXmlResourceProvider.getXmlResourceProvider_(project, JptCorePlugin.getDeploymentURI(project, deployLocation));
    }

    public static OrmXmlResourceProvider getDefaultXmlResourceProvider(IProject project) {
        return OrmXmlResourceProvider.getXmlResourceProvider(project, "META-INF/orm.xml");
    }

    private static OrmXmlResourceProvider getXmlResourceProvider_(IProject project, String location) {
        return new OrmXmlResourceProvider(project, (IPath)new Path(location));
    }

    public OrmXmlResourceProvider(IProject project) {
        this(project, (IPath)new Path("META-INF/orm.xml"));
    }

    public OrmXmlResourceProvider(IProject project, IPath filePath) {
        super(project, filePath, JptCorePlugin.ORM_XML_CONTENT_TYPE);
    }

    protected void populateRoot(Object config) {
        IDataModel dataModel = (IDataModel)config;
        XmlEntityMappings entityMappings = OrmFactory.eINSTANCE.createXmlEntityMappings();
        entityMappings.setVersion(dataModel.getStringProperty("JpaFileCreationDataModelProperties.VERSION"));
        this.getResourceContents().add((Object)entityMappings);
        AccessType defaultAccess = (AccessType)((Object)dataModel.getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS"));
        if (defaultAccess != null) {
            XmlPersistenceUnitMetadata puMetadata = OrmFactory.eINSTANCE.createXmlPersistenceUnitMetadata();
            entityMappings.setPersistenceUnitMetadata(puMetadata);
            XmlPersistenceUnitDefaults puDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
            puMetadata.setPersistenceUnitDefaults(puDefaults);
            puDefaults.setAccess(defaultAccess);
        }
    }
}

