/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.data;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.Utility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class ResourceReader {
    private BufferedReader reader;
    private String resourceName;
    private String encoding;
    private Class root;
    private int lineNo;
    static /* synthetic */ Class class$0;

    public ResourceReader(String resourceName, String encoding) throws UnsupportedEncodingException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.impl.ICUData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, "data/" + resourceName, encoding);
    }

    public ResourceReader(String resourceName) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.icu.impl.ICUData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this(clazz, "data/" + resourceName);
    }

    public ResourceReader(Class rootClass, String resourceName, String encoding) throws UnsupportedEncodingException {
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        this._reset();
    }

    public ResourceReader(InputStream is, String resourceName, String encoding) {
        this.root = null;
        this.resourceName = resourceName;
        this.encoding = encoding;
        this.lineNo = -1;
        try {
            InputStreamReader isr = encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, encoding);
            this.reader = new BufferedReader(isr);
            this.lineNo = 0;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public ResourceReader(InputStream is, String resourceName) {
        this(is, resourceName, null);
    }

    public ResourceReader(Class rootClass, String resourceName) {
        this.root = rootClass;
        this.resourceName = resourceName;
        this.encoding = null;
        this.lineNo = -1;
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public String readLine() throws IOException {
        if (this.lineNo == 0) {
            ++this.lineNo;
            String line = this.reader.readLine();
            if (line.charAt(0) == '\uffef' || line.charAt(0) == '\ufeff') {
                line = line.substring(1);
            }
            return line;
        }
        ++this.lineNo;
        return this.reader.readLine();
    }

    public String readLineSkippingComments(boolean trim) throws IOException {
        String line;
        int pos;
        do {
            if ((line = this.readLine()) != null) continue;
            return line;
        } while ((pos = Utility.skipWhitespace(line, 0)) == line.length() || line.charAt(pos) == '#');
        if (trim) {
            line = line.substring(pos);
        }
        return line;
    }

    public String readLineSkippingComments() throws IOException {
        return this.readLineSkippingComments(false);
    }

    public int getLineNumber() {
        return this.lineNo;
    }

    public String describePosition() {
        return String.valueOf(this.resourceName) + ':' + this.lineNo;
    }

    public void reset() {
        try {
            this._reset();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private void _reset() throws UnsupportedEncodingException {
        if (this.lineNo == 0) {
            return;
        }
        InputStream is = ICUData.getStream(this.root, this.resourceName);
        if (is == null) {
            throw new IllegalArgumentException("Can't open " + this.resourceName);
        }
        InputStreamReader isr = this.encoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.encoding);
        this.reader = new BufferedReader(isr);
        this.lineNo = 0;
    }
}

