/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.List;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertyStructure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortHint
extends PropertyStructure {
    public static final String SORT_HINT_STRUCT = "SortHint";
    public static final String COLUMN_NAME_MEMBER = "columnName";
    public static final String POSITION_MEMBER = "position";
    public static final String DIRECTION_MEMBER = "direction";
    public static final String NULL_VALUE_ORDERING_MEMBER = "nullValueOrdering";
    public static final String IS_OPTIONAL_MEMBER = "isOptional";

    @Override
    protected StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new SortHintHandle(valueHandle, index);
    }

    @Override
    public String getStructName() {
        return SORT_HINT_STRUCT;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        Object pos;
        List<SemanticException> list = super.validate(module, element);
        IStructureDefn structureDefn = this.getDefn();
        PropertyDefn propDefn = (PropertyDefn)structureDefn.getMember(COLUMN_NAME_MEMBER);
        String columnName = (String)this.getProperty(module, propDefn);
        if (StringUtil.isBlank(columnName) && (pos = this.getProperty(module, propDefn = (PropertyDefn)structureDefn.getMember(POSITION_MEMBER))) == null) {
            list.add(new PropertyValueException(element, propDefn, (Object)columnName, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }
}

