/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.activity.SimpleRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.validators.ValidationExecutor;
import org.eclipse.birt.report.model.validators.ValidationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveContentRecord
extends SimpleRecord {
    protected Module module = null;
    protected DesignElement content = null;
    protected ContainerContext from = null;
    protected ContainerContext to = null;
    protected int newPosn = 0;
    protected int oldPosn = 0;

    public MoveContentRecord(Module theModule, ContainerContext containerInfor, DesignElement obj, int posn) {
        this.init(theModule, containerInfor, containerInfor, obj, posn);
    }

    public MoveContentRecord(Module theModule, ContainerContext from, ContainerContext to, DesignElement obj, int posn) {
        this.init(theModule, from, to, obj, posn);
    }

    private void init(Module theModule, ContainerContext from, ContainerContext to, DesignElement obj, int posn) {
        this.module = theModule;
        this.from = from;
        this.to = to;
        this.content = obj;
        this.newPosn = posn;
        assert (from != null);
        assert (to != null);
        assert (from.getContainerDefn() != null);
        assert (to.getContainerDefn() != null);
        assert (this.content != null);
        assert (from.contains(this.module, this.content));
        assert (from == to || !to.contains(this.module, this.content));
        this.oldPosn = from.indexOf(this.module, this.content);
        int count = to.getContentCount(this.module);
        this.newPosn = posn == -1 || count < posn ? count : posn;
        this.label = CommandLabelFactory.getCommandLabel("Message.MoveContent");
    }

    @Override
    protected void perform(boolean undo) {
        if (this.from == this.to) {
            int from = undo ? this.newPosn : this.oldPosn;
            int to = undo ? this.oldPosn : this.newPosn;
            this.from.move(this.module, from, to);
        } else if (!undo) {
            this.from.remove(this.module, this.content);
            this.to.add(this.module, this.content, this.newPosn);
        } else {
            this.to.remove(this.module, this.content);
            this.from.add(this.module, this.content, this.oldPosn);
        }
    }

    @Override
    public DesignElement getTarget() {
        if (this.eventTarget != null) {
            return this.eventTarget.getElement();
        }
        return this.to.getElement();
    }

    @Override
    public NotificationEvent getEvent() {
        return null;
    }

    @Override
    public List<ValidationNode> getValidators() {
        List<ValidationNode> list = ValidationExecutor.getValidationNodes(this.from.getElement(), this.from.getTriggerSetForContainerDefn(), false);
        if (this.to != this.from) {
            list.addAll(ValidationExecutor.getValidationNodes(this.to.getElement(), this.to.getTriggerSetForContainerDefn(), false));
        }
        ElementDefn contentDefn = (ElementDefn)this.content.getDefn();
        list.addAll(ValidationExecutor.getValidationNodes(this.content, contentDefn.getTriggerDefnSet(), false));
        return list;
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        if (this.from == this.to) {
            ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
            retValue.addAll(super.getPostTasks());
            NotificationEvent event = null;
            event = this.eventTarget != null ? new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName()) : new ContentEvent(this.from, this.content, 3);
            retValue.add(new NotificationRecordTask(this.getTarget(), event));
            if (!(this.content instanceof TableGroup || this.content instanceof TableRow || this.content instanceof Cell)) {
                return retValue;
            }
            ReportItem compoundElement = LayoutUtil.getCompoundContainer(this.from.getElement());
            if (compoundElement == null) {
                return retValue;
            }
            retValue.add(new LayoutRecordTask(compoundElement.getRoot(), compoundElement));
            return retValue;
        }
        ArrayList<RecordTask> retValue = new ArrayList<RecordTask>();
        retValue.addAll(super.getPostTasks());
        if (this.eventTarget != null) {
            PropertyEvent event = new PropertyEvent(this.eventTarget.getElement(), this.eventTarget.getPropName());
            retValue.add(new NotificationRecordTask(this.from.getElement(), (NotificationEvent)event));
            retValue.add(new NotificationRecordTask(this.to.getElement(), (NotificationEvent)event));
            return retValue;
        }
        ReportItem fromLayout = this.getLayoutElement(this.from);
        ReportItem toLayout = this.getLayoutElement(this.to);
        if (fromLayout != null) {
            retValue.add(new LayoutRecordTask(this.module, fromLayout));
        }
        if (toLayout != null && toLayout != fromLayout) {
            retValue.add(new LayoutRecordTask(this.module, toLayout));
        }
        ContentEvent event = null;
        boolean isDo = this.isDo();
        ContentEvent styleSelectorEvent = null;
        int action = isDo ? 2 : 1;
        event = new ContentEvent(this.from, this.content, action);
        if (!isDo) {
            styleSelectorEvent = event;
        }
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        retValue.add(new NotificationRecordTask(this.from.getElement(), (NotificationEvent)event));
        action = isDo ? 1 : 2;
        event = new ContentEvent(this.to, this.content, action);
        if (isDo) {
            styleSelectorEvent = event;
        }
        if (this.state == 1) {
            event.setSender(this.sender);
        }
        retValue.add(new NotificationRecordTask(this.to.getElement(), (NotificationEvent)event));
        if (this.isSelector(this.content)) {
            assert (styleSelectorEvent != null);
            retValue.add(new NotificationRecordTask(this.content, event, this.from.getElement().getRoot()));
        }
        return retValue;
    }

    private boolean isSelector(DesignElement content) {
        if (!(content instanceof StyleElement)) {
            return false;
        }
        return MetaDataDictionary.getInstance().getPredefinedStyle(content.getName()) != null;
    }

    boolean isDo() {
        return this.state == 1 || this.state == 3;
    }

    private ReportItem getLayoutElement(ContainerContext focus) {
        DesignElement container = focus.getElement();
        if (container instanceof TableItem || container instanceof GridItem || container instanceof TableGroup || container instanceof TableRow) {
            ReportItem compoundElement = LayoutUtil.getCompoundContainer(container);
            return compoundElement;
        }
        return null;
    }
}

