/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import com.ibm.icu.text.DateFormat;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.mapping.CVSCheckedInChangeSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.mappings.CheckedInChangeSetCollector;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteCompareOperation;
import org.eclipse.team.internal.core.mapping.SyncInfoToDiffConverter;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelParticipantAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.PlatformUI;

class OpenChangeSetAction
extends ResourceModelParticipantAction {
    static /* synthetic */ Class class$0;

    protected OpenChangeSetAction(ISynchronizePageConfiguration configuration) {
        super(CVSUIMessages.OpenCommitSetAction_20, configuration);
        ISelection selection = configuration.getSite().getSelectionProvider().getSelection();
        if (selection != null) {
            this.selectionChanged(selection);
        }
    }

    private ChangeSet getChangeSet(IStructuredSelection selection) {
        TreeSelection ts;
        TreePath[] paths;
        Object o;
        if (selection.size() == 1 && (o = selection.getFirstElement()) instanceof IAdaptable) {
            ChangeSet set;
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.core.subscribers.ChangeSet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((set = (ChangeSet)iAdaptable.getAdapter((Class)clazz)) != null) {
                return set;
            }
        }
        if (selection instanceof TreeSelection && (paths = (ts = (TreeSelection)selection).getPaths()).length > 0) {
            ChangeSet set = this.getChangeSet(paths[0]);
            if (set != null) {
                int i = 1;
                while (i < paths.length) {
                    TreePath path = paths[i];
                    ChangeSet otherSet = this.getChangeSet(path);
                    if (set != otherSet) {
                        return null;
                    }
                    ++i;
                }
            }
            return set;
        }
        return null;
    }

    private ChangeSet getChangeSet(TreePath treePath) {
        Object test = treePath.getFirstSegment();
        if (test instanceof ChangeSet) {
            ChangeSet cs = (ChangeSet)test;
            return cs;
        }
        return null;
    }

    protected boolean isEnabledForSelection(IStructuredSelection selection) {
        ChangeSet set = this.getChangeSet(selection);
        return set != null;
    }

    public void openEditor(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            IDiff[] diffs = this.getSelectedDiffs(monitor);
            if (diffs.length > 0) {
                ICVSRepositoryLocation location = this.getLocation(diffs[0]);
                if (location == null) {
                    throw new CVSException(CVSUIMessages.OpenCommitSetAction_21);
                }
                RemoteCompareOperation.CompareTreeBuilder builder = new RemoteCompareOperation.CompareTreeBuilder(location, null, null);
                if (this.buildTrees(builder, diffs)) {
                    builder.cacheContents(monitor);
                    builder.openCompareEditor(this.getConfiguration().getSite().getPart().getSite().getPage(), this.getCompareTitle(), this.getCompareToolTip());
                }
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private IDiff[] getSelectedDiffs(IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] traversals = this.getResourceTraversals(this.getStructuredSelection(), monitor);
        DiffChangeSet set = (DiffChangeSet)this.getChangeSet(this.getStructuredSelection());
        return set.getDiffTree().getDiffs(traversals);
    }

    private boolean buildTrees(RemoteCompareOperation.CompareTreeBuilder builder, IDiff[] diffs) {
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            if (this.isFileChange(diff)) {
                IFileRevision remoteRevision = Utils.getRemote((IDiff)diff);
                IResourceVariant remote = SyncInfoToDiffConverter.asResourceVariant((IFileRevision)remoteRevision);
                if (remote == null) {
                    IFileRevision predecessorRevision = Utils.getBase((IDiff)diff);
                    IResourceVariant predecessor = SyncInfoToDiffConverter.asResourceVariant((IFileRevision)predecessorRevision);
                    if (predecessor instanceof ICVSRemoteFile) {
                        builder.addToTrees((ICVSRemoteFile)predecessor, null);
                    }
                } else if (remote instanceof ICVSRemoteFile) {
                    try {
                        ICVSRemoteFile predecessor = this.getImmediatePredecessor(remote);
                        builder.addToTrees(predecessor, (ICVSRemoteFile)remote);
                    }
                    catch (TeamException e) {
                        Utils.handle((Throwable)e);
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean isFileChange(IDiff diff) {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        if (resource.getType() == 1) {
            if (diff instanceof IThreeWayDiff) {
                IThreeWayDiff twd = (IThreeWayDiff)diff;
                return twd.getDirection() == 512 || twd.getDirection() == 768;
            }
            return true;
        }
        return false;
    }

    private ICVSRepositoryLocation getLocation(IDiff diff) {
        IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        if (provider instanceof CVSTeamProvider) {
            CVSTeamProvider ctp = (CVSTeamProvider)provider;
            try {
                return ctp.getCVSWorkspaceRoot().getRemoteLocation();
            }
            catch (CVSException e) {
                CVSUIPlugin.log((CoreException)((Object)e));
            }
        }
        return null;
    }

    private String getCompareTitle() {
        ChangeSet set = this.getChangeSet(this.getStructuredSelection());
        if (set instanceof CVSCheckedInChangeSet) {
            CVSCheckedInChangeSet cics = (CVSCheckedInChangeSet)set;
            String date = DateFormat.getDateTimeInstance().format(cics.getDate());
            return NLS.bind((String)CVSUIMessages.OpenChangeSetAction_0, (Object[])new String[]{cics.getAuthor(), date});
        }
        return CVSUIMessages.OpenChangeSetAction_1;
    }

    private String getCompareToolTip() {
        ChangeSet set = this.getChangeSet(this.getStructuredSelection());
        if (set != null) {
            return set.getName();
        }
        return null;
    }

    private ICVSRemoteFile getImmediatePredecessor(IResourceVariant remote) throws TeamException {
        CheckedInChangeSetCollector changeSetCollector = this.getChangeSetCollector();
        if (changeSetCollector != null) {
            return changeSetCollector.getImmediatePredecessor((ICVSRemoteFile)remote);
        }
        return null;
    }

    private CheckedInChangeSetCollector getChangeSetCollector() {
        return (CheckedInChangeSetCollector)this.getConfiguration().getProperty("org.eclipse.team.cvs.ui.CVSCheckedInCollector");
    }

    public void run() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    OpenChangeSetAction.this.openEditor(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Utils.handle((Throwable)e);
        }
        catch (InterruptedException interruptedException) {}
    }
}

