/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.de.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.data.adapter.api.DataAdapterUtil;
import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.internal.ICrosstabModelListener;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.IReportItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosstabModelUtil
implements ICrosstabConstants {
    private static ThreadLocal<ICrosstabModelListener> modelListener = new ThreadLocal();

    public static void setCrosstabModelListener(ICrosstabModelListener listener) {
        if (listener == null) {
            modelListener.remove();
        } else {
            modelListener.set(listener);
        }
    }

    public static ICrosstabModelListener getCrosstabModelListener() {
        return modelListener.get();
    }

    public static void notifyCreation(int type, Object model) {
        ICrosstabModelListener listener = modelListener.get();
        if (listener != null) {
            listener.onCreated(type, model);
        }
    }

    public static void notifyValidate(int type, Object model) {
        ICrosstabModelListener listener = modelListener.get();
        if (listener != null) {
            listener.onValidate(type, model);
        }
    }

    public static List<IReportItem> getReportItems(List<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IReportItem> values = new ArrayList<IReportItem>();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof DesignElementHandle) {
                values.add(CrosstabUtil.getReportItem((DesignElementHandle)elements.get(i)));
            }
            ++i;
        }
        return values;
    }

    public static int getOppositeAxisType(int axisType) {
        switch (axisType) {
            case 1: {
                return 0;
            }
            case 0: {
                return 1;
            }
        }
        return -1;
    }

    static int getTotalIndex(LevelViewHandle levelView) {
        if (levelView == null) {
            return -1;
        }
        CrosstabReportItemHandle crosstab = levelView.getCrosstab();
        if (crosstab == null) {
            return -1;
        }
        int axisType = levelView.getAxisType();
        int levelIndex = levelView.getIndex();
        int dimensionIndex = ((DimensionViewHandle)levelView.getContainer()).getIndex();
        int result = levelIndex;
        int i = 0;
        while (i < dimensionIndex) {
            DimensionViewHandle dimension = crosstab.getDimension(axisType, i);
            result += dimension.getLevelCount();
            ++i;
        }
        return result;
    }

    public static boolean isValidAxisType(int axisType) {
        return axisType == 1 || axisType == 0;
    }

    public static int getAllLevelCount(CrosstabReportItemHandle crosstab, int axisType) {
        if (crosstab == null) {
            return 0;
        }
        int count = 0;
        int i = 0;
        while (i < crosstab.getDimensionCount(axisType)) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, i);
            count += dimensionView.getLevelCount();
            ++i;
        }
        return count;
    }

    public static LevelViewHandle getPrecedingLevel(LevelViewHandle levelView) {
        if (levelView == null) {
            return null;
        }
        DimensionViewHandle dimensionView = (DimensionViewHandle)levelView.getContainer();
        if (dimensionView == null) {
            return null;
        }
        int index = levelView.getIndex();
        if (index - 1 >= 0) {
            return dimensionView.getLevel(index - 1);
        }
        CrosstabViewHandle crosstabView = (CrosstabViewHandle)dimensionView.getContainer();
        if (crosstabView == null) {
            return null;
        }
        index = dimensionView.getIndex();
        int i = index - 1;
        while (i >= 0) {
            dimensionView = crosstabView.getDimension(i);
            int levelCount = dimensionView.getLevelCount();
            if (levelCount > 0) {
                return dimensionView.getLevel(levelCount - 1);
            }
            --i;
        }
        return null;
    }

    public static LevelViewHandle getInnerMostLevel(CrosstabReportItemHandle crosstab, int axisType) {
        if (crosstab == null) {
            return null;
        }
        int dimensionIndex = crosstab.getDimensionCount(axisType) - 1;
        while (dimensionIndex >= 0) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, dimensionIndex);
            int totalLevels = dimensionView.getLevelCount();
            if (totalLevels > 0) {
                return dimensionView.getLevel(totalLevels - 1);
            }
            --dimensionIndex;
        }
        return null;
    }

    public static void addMeasureAggregations(CrosstabReportItemHandle crosstab, String leftDimension, String leftLevel, int axisType, String rightDimension, String rightLevel, List<MeasureViewHandle> measures, List<String> functions) throws SemanticException {
        if (crosstab == null || !CrosstabModelUtil.isValidAxisType(axisType) || measures == null) {
            return;
        }
        if (functions == null || functions.size() != measures.size()) {
            return;
        }
        String rowDimension = null;
        String rowLevel = null;
        String colDimension = null;
        String colLevel = null;
        if (axisType == 0) {
            rowDimension = leftDimension;
            rowLevel = leftLevel;
            colDimension = rightDimension;
            colLevel = rightLevel;
        } else if (axisType == 1) {
            rowDimension = rightDimension;
            rowLevel = rightLevel;
            colDimension = leftDimension;
            colLevel = leftLevel;
        }
        int i = 0;
        while (i < measures.size()) {
            MeasureViewHandle measureView = measures.get(i);
            if (measureView.getCrosstab() == crosstab) {
                CrosstabModelUtil.addDataItem(crosstab, measureView, functions.get(i), rowDimension, rowLevel, colDimension, colLevel);
            }
            ++i;
        }
    }

    public static void addDataItem(CrosstabReportItemHandle crosstab, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel) throws SemanticException {
        CrosstabModelUtil.addDataItem(crosstab, null, measureView, function, rowDimension, rowLevel, colDimension, colLevel, true);
    }

    public static void addDataItem(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, MeasureViewHandle measureView, String function, String rowDimension, String rowLevel, String colDimension, String colLevel, boolean forceAdd) throws SemanticException {
        if (crosstab == null || measureView == null) {
            return;
        }
        if (cell == null) {
            cell = measureView.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell == null && forceAdd) {
            cell = measureView.addAggregation(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell != null && !(measureView instanceof ComputedMeasureViewHandle)) {
            String name = CrosstabModelUtil.generateComputedColumnName(measureView, colLevel, rowLevel);
            ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)crosstab.getModelHandle(), (String)name);
            String dataType = measureView.getDataType();
            column.setDataType(dataType);
            column.setExpression(ExpressionUtil.createJSMeasureExpression((String)measureView.getCubeMeasureName()));
            column.setAggregateFunction(function != null ? function : CrosstabModelUtil.getDefaultMeasureAggregationFunction(measureView));
            if (rowLevel != null) {
                column.addAggregateOn(rowLevel);
            }
            if (colLevel != null) {
                column.addAggregateOn(colLevel);
            }
            ComputedColumnHandle columnHandle = ((ReportItemHandle)crosstab.getModelHandle()).addColumnBinding(column, false);
            if (cell.getContents().size() == 0) {
                DataItemHandle dataItem = crosstab.getModuleHandle().getElementFactory().newDataItem(null);
                dataItem.setResultSetColumn(columnHandle.getName());
                cell.addContent((DesignElementHandle)dataItem);
            } else if (cell.getContents().size() == 1 && cell.getContents().get(0) instanceof DataItemHandle) {
                DataItemHandle dataItem = (DataItemHandle)cell.getContents().get(0);
                dataItem.setResultSetColumn(columnHandle.getName());
            }
        }
    }

    public static String generateComputedColumnName(MeasureViewHandle measureView, String aggregationOnColumn, String aggregationOnRow) {
        String name = "";
        String temp = measureView.getCubeMeasureName();
        if (temp != null && temp.length() > 0) {
            name = String.valueOf(name) + temp;
        }
        if (aggregationOnRow != null && aggregationOnRow.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnRow : String.valueOf(name) + aggregationOnRow;
        }
        if (aggregationOnColumn != null && aggregationOnColumn.length() > 0) {
            name = name.length() > 0 ? String.valueOf(name) + "_" + aggregationOnColumn : String.valueOf(name) + aggregationOnColumn;
        }
        if (name.length() <= 0) {
            name = "measure";
        }
        return name;
    }

    public static String getDefaultMeasureAggregationFunction(MeasureViewHandle mv) {
        String func;
        if (mv != null && mv.getCubeMeasure() != null && (func = mv.getCubeMeasure().getFunction()) != null) {
            return DataAdapterUtil.getRollUpAggregationName((String)func);
        }
        return "sum";
    }

    public static String getAggregationFunction(CrosstabReportItemHandle crosstab, AggregationCellHandle cell) {
        assert (crosstab != null);
        assert (cell != null);
        assert (cell.getCrosstab() == crosstab);
        ReportItemHandle crosstabModel = (ReportItemHandle)crosstab.getModelHandle();
        List contents = cell.getContents();
        int index = 0;
        while (index < contents.size()) {
            String columnName;
            ComputedColumnHandle columnHandle;
            DesignElementHandle content = (DesignElementHandle)contents.get(index);
            if (content instanceof DataItemHandle && (columnHandle = crosstabModel.findColumnBinding(columnName = ((DataItemHandle)content).getResultSetColumn())) != null && columnHandle.getAggregateFunction() != null) {
                return columnHandle.getAggregateFunction();
            }
            ++index;
        }
        return null;
    }

    public static void setAggregationFunction(CrosstabReportItemHandle crosstab, AggregationCellHandle cell, String function) throws SemanticException {
        assert (crosstab != null);
        assert (cell != null);
        assert (cell.getCrosstab() == crosstab);
        ReportItemHandle crosstabModel = (ReportItemHandle)crosstab.getModelHandle();
        List contents = cell.getContents();
        int index = 0;
        while (index < contents.size()) {
            String columnName;
            ComputedColumnHandle columnHandle;
            DesignElementHandle content = (DesignElementHandle)contents.get(index);
            if (content instanceof DataItemHandle && (columnHandle = crosstabModel.findColumnBinding(columnName = ((DataItemHandle)content).getResultSetColumn())) != null) {
                columnHandle.setAggregateFunction(function);
            }
            ++index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrosstabCellHandle locateColumnWidthCell(CrosstabReportItemHandle crosstabItem, CrosstabCellHandle cell) {
        if (crosstabItem == null || cell == null || cell.getCrosstab() != crosstabItem) return null;
        boolean isMeasureHorizontal = "horizontal".equals(crosstabItem.getMeasureDirection());
        if (cell instanceof AggregationCellHandle) {
            AggregationCellHandle aggCell = (AggregationCellHandle)cell;
            MeasureViewHandle mv = null;
            if ("detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) {
                if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getCell();
                return ((MeasureViewHandle)cell.getContainer()).getCell();
            }
            mv = isMeasureHorizontal ? (MeasureViewHandle)aggCell.getContainer() : crosstabItem.getMeasure(0);
            String colDimension = aggCell.getDimensionName(1);
            String colLevel = aggCell.getLevelName(1);
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle == null) {
                return mv.getCell();
            }
            DimensionViewHandle colDimHandle = (DimensionViewHandle)colLevelHandle.getContainer();
            if (colLevelHandle.getCubeLevelName().equals(colLevel) && colDimHandle.getCubeDimensionName().equals(colDimension)) {
                return mv.getCell();
            }
            String rowDimension = null;
            String rowLevel = null;
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle == null) return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
            rowLevel = rowLevelHandle.getCubeLevelName();
            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell.getContainer() instanceof MeasureViewHandle) {
            if (isMeasureHorizontal) {
                MeasureViewHandle mv = (MeasureViewHandle)cell.getContainer();
                int headerPos = cell.getModelHandle().getIndex();
                if (headerPos <= 0) return mv.getCell();
                List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstabItem, 1);
                Collections.reverse(levels);
                String rowDimension = null;
                String rowLevel = null;
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle != null) {
                    rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                    rowLevel = rowLevelHandle.getCubeLevelName();
                }
                int realIndex = 1;
                int i = 1;
                while (i < levels.size()) {
                    LevelViewHandle lv = levels.get(i);
                    if (CrosstabModelUtil.isAggregationOn(mv, lv.getCubeLevelName(), 1)) {
                        if (headerPos == realIndex) {
                            String colDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                            String colLevel = lv.getCubeLevelName();
                            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                        }
                        ++realIndex;
                    }
                    ++i;
                }
                return mv.getAggregationCell(rowDimension, rowLevel, null, null);
            }
            if (!"header".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return null;
        } else {
            if (cell.getContainer() instanceof LevelViewHandle) {
                LevelViewHandle lv = (LevelViewHandle)cell.getContainer();
                boolean isRowLevl = "rows".equals(lv.getContainer().getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
                if (isRowLevl) {
                    if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return cell;
                    return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0).getCell();
                }
                if (crosstabItem.getMeasureCount() == 0) {
                    if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1).getCell();
                    return cell;
                }
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
                String rowDimension = null;
                String rowLevel = null;
                String colDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                String colLevel = lv.getCubeLevelName();
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle != null) {
                    rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                    rowLevel = rowLevelHandle.getCubeLevelName();
                }
                if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                    if (aggCell != null) {
                        return aggCell;
                    }
                    ++i;
                }
                return crosstabItem.getMeasure(0).getCell();
            }
            if (cell.getContainer() instanceof CrosstabViewHandle) {
                boolean isRowGrandTotal = "rows".equals(cell.getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
                if (isRowGrandTotal) {
                    LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                    if (rowLevelHandle == null) return cell;
                    return rowLevelHandle.getCell();
                }
                if (crosstabItem.getMeasureCount() == 0) {
                    return cell;
                }
                String rowDimension = null;
                String rowLevel = null;
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle != null) {
                    rowDimension = ((DimensionViewHandle)rowLevelHandle.getContainer()).getCubeDimensionName();
                    rowLevel = rowLevelHandle.getCubeLevelName();
                }
                if (!isMeasureHorizontal) return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, null, null);
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, null, null);
                    if (aggCell != null) {
                        return aggCell;
                    }
                    ++i;
                }
                return null;
            } else {
                if (!(cell.getContainer() instanceof CrosstabReportItemHandle)) return null;
                LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
                if (rowLevelHandle != null) {
                    return rowLevelHandle.getCell();
                }
                if (isMeasureHorizontal) return cell;
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    MeasureViewHandle mv = crosstabItem.getMeasure(i);
                    if (mv.getHeader() != null) {
                        return mv.getHeader();
                    }
                    ++i;
                }
                return cell;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CrosstabCellHandle locateRowHeightCell(CrosstabReportItemHandle crosstabItem, CrosstabCellHandle cell) {
        if (crosstabItem == null || cell == null || cell.getCrosstab() != crosstabItem) return null;
        boolean isMeasureHorizontal = "horizontal".equals(crosstabItem.getMeasureDirection());
        if (cell instanceof AggregationCellHandle) {
            AggregationCellHandle aggCell = (AggregationCellHandle)cell;
            MeasureViewHandle mv = null;
            if ("detail".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) {
                if (isMeasureHorizontal) return crosstabItem.getMeasure(0).getCell();
                return ((MeasureViewHandle)cell.getContainer()).getCell();
            }
            mv = !isMeasureHorizontal ? (MeasureViewHandle)aggCell.getContainer() : crosstabItem.getMeasure(0);
            String rowDimension = aggCell.getDimensionName(0);
            String rowLevel = aggCell.getLevelName(0);
            LevelViewHandle rowLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0);
            if (rowLevelHandle == null) {
                return mv.getCell();
            }
            DimensionViewHandle rowDimHandle = (DimensionViewHandle)rowLevelHandle.getContainer();
            if (rowLevelHandle.getCubeLevelName().equals(rowLevel) && rowDimHandle.getCubeDimensionName().equals(rowDimension)) {
                return mv.getCell();
            }
            String colDimension = null;
            String colLevel = null;
            LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
            if (colLevelHandle == null) return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
            colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
            colLevel = colLevelHandle.getCubeLevelName();
            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
        }
        if (cell.getContainer() instanceof MeasureViewHandle) {
            if (!isMeasureHorizontal) {
                MeasureViewHandle mv = (MeasureViewHandle)cell.getContainer();
                int headerPos = cell.getModelHandle().getIndex();
                if (headerPos <= 0) return mv.getCell();
                List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstabItem, 0);
                Collections.reverse(levels);
                String colDimension = null;
                String colLevel = null;
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle != null) {
                    colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                    colLevel = colLevelHandle.getCubeLevelName();
                }
                int realIndex = 1;
                int i = 1;
                while (i < levels.size()) {
                    LevelViewHandle lv = levels.get(i);
                    if (CrosstabModelUtil.isAggregationOn(mv, lv.getCubeLevelName(), 0)) {
                        if (headerPos == realIndex) {
                            String rowDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                            String rowLevel = lv.getCubeLevelName();
                            return mv.getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                        }
                        ++realIndex;
                    }
                    ++i;
                }
                return mv.getAggregationCell(null, null, colDimension, colLevel);
            }
            if (!"header".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
            int i = 0;
            while (i < crosstabItem.getMeasureCount()) {
                MeasureViewHandle mv = crosstabItem.getMeasure(i);
                if (mv.getHeader() != null) {
                    return mv.getHeader();
                }
                ++i;
            }
            return null;
        } else {
            if (cell.getContainer() instanceof LevelViewHandle) {
                LevelViewHandle lv = (LevelViewHandle)cell.getContainer();
                boolean isRowLevl = "rows".equals(lv.getContainer().getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
                if (!isRowLevl) {
                    if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return cell;
                    return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1).getCell();
                }
                if (crosstabItem.getMeasureCount() == 0) {
                    if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return CrosstabModelUtil.getInnerMostLevel(crosstabItem, 0).getCell();
                    return cell;
                }
                if (!"aggregationHeader".equals(cell.getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName())) return crosstabItem.getMeasure(0).getCell();
                String colDimension = null;
                String colLevel = null;
                String rowDimension = ((DimensionViewHandle)lv.getContainer()).getCubeDimensionName();
                String rowLevel = lv.getCubeLevelName();
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle != null) {
                    colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                    colLevel = colLevelHandle.getCubeLevelName();
                }
                if (isMeasureHorizontal) {
                    return crosstabItem.getMeasure(0).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                }
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(rowDimension, rowLevel, colDimension, colLevel);
                    if (aggCell != null) {
                        return aggCell;
                    }
                    ++i;
                }
                return crosstabItem.getMeasure(0).getCell();
            }
            if (cell.getContainer() instanceof CrosstabViewHandle) {
                boolean isRowGrandTotal = "rows".equals(cell.getContainer().getModelHandle().getContainerPropertyHandle().getPropertyDefn().getName());
                if (!isRowGrandTotal) {
                    LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                    if (colLevelHandle == null) return cell;
                    return colLevelHandle.getCell();
                }
                if (crosstabItem.getMeasureCount() == 0) {
                    return cell;
                }
                String colDimension = null;
                String colLevel = null;
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle != null) {
                    colDimension = ((DimensionViewHandle)colLevelHandle.getContainer()).getCubeDimensionName();
                    colLevel = colLevelHandle.getCubeLevelName();
                }
                if (isMeasureHorizontal) {
                    return crosstabItem.getMeasure(0).getAggregationCell(null, null, colDimension, colLevel);
                }
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    AggregationCellHandle aggCell = crosstabItem.getMeasure(i).getAggregationCell(null, null, colDimension, colLevel);
                    if (aggCell != null) {
                        return aggCell;
                    }
                    ++i;
                }
                return null;
            } else {
                if (!(cell.getContainer() instanceof CrosstabReportItemHandle)) return null;
                LevelViewHandle colLevelHandle = CrosstabModelUtil.getInnerMostLevel(crosstabItem, 1);
                if (colLevelHandle != null) {
                    return colLevelHandle.getCell();
                }
                if (!isMeasureHorizontal) return cell;
                int i = 0;
                while (i < crosstabItem.getMeasureCount()) {
                    MeasureViewHandle mv = crosstabItem.getMeasure(i);
                    if (mv.getHeader() != null) {
                        return mv.getHeader();
                    }
                    ++i;
                }
                return cell;
            }
        }
    }

    public static List<LevelViewHandle> getAllAggregationLevels(CrosstabReportItemHandle crosstab, int axisType) {
        ArrayList<LevelViewHandle> result = new ArrayList<LevelViewHandle>();
        int i = 0;
        while (i < crosstab.getDimensionCount(axisType)) {
            DimensionViewHandle dimensionView = crosstab.getDimension(axisType, i);
            int j = 0;
            while (j < dimensionView.getLevelCount()) {
                LevelViewHandle levelView = dimensionView.getLevel(j);
                if (levelView.getCubeLevelName() != null && (levelView.isInnerMost() || levelView.getAggregationHeader() != null)) {
                    result.add(levelView);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String getAggregationOnPropName(int axisType) {
        if (axisType == 1) {
            return "aggregationOnColumn";
        }
        if (axisType == 0) {
            return "aggregationOnRow";
        }
        return null;
    }

    public static boolean isAggregationOn(MeasureViewHandle measureView, String levelName, int axisType) {
        if (measureView == null || !CrosstabModelUtil.isValidAxisType(axisType)) {
            return false;
        }
        String propName = CrosstabModelUtil.getAggregationOnPropName(axisType);
        int j = 0;
        while (j < measureView.getAggregationCount()) {
            AggregationCellHandle cell = measureView.getAggregationCell(j);
            String aggregationOn = cell.getModelHandle().getStringProperty(propName);
            if (levelName == null && aggregationOn == null || levelName != null && levelName.equals(aggregationOn)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static int computeAllMeasureHeaderCount(CrosstabReportItemHandle crosstab, MeasureViewHandle measureView) {
        if (crosstab == null || measureView == null) {
            return 0;
        }
        if (measureView instanceof ComputedMeasureViewHandle) {
            return 1;
        }
        int targetAxis = "vertical".equals(crosstab.getMeasureDirection()) ? 0 : 1;
        List<LevelViewHandle> levels = CrosstabModelUtil.getAllAggregationLevels(crosstab, targetAxis);
        if (levels == null || levels.size() == 0) {
            return 1;
        }
        int count = 0;
        LevelViewHandle innerMost = CrosstabModelUtil.getInnerMostLevel(crosstab, targetAxis);
        int i = 0;
        while (i < levels.size()) {
            LevelViewHandle lv = levels.get(i);
            if (lv == innerMost || CrosstabModelUtil.isAggregationOn(measureView, lv.getCubeLevelName(), targetAxis)) {
                ++count;
            }
            ++i;
        }
        if (CrosstabModelUtil.isAggregationOn(measureView, null, targetAxis)) {
            ++count;
        }
        assert (count > 0);
        return count;
    }
}

