/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedListIterator<E>
implements ListIterator<E> {
    private final ListIterator<E> listIterator;
    private final Object mutex;

    public SynchronizedListIterator(List<E> list) {
        this(list.listIterator());
    }

    public SynchronizedListIterator(List<E> list, Object mutex) {
        this(list.listIterator(), mutex);
    }

    public SynchronizedListIterator(ListIterable<E> listIterable) {
        this(listIterable.iterator());
    }

    public SynchronizedListIterator(ListIterable<E> listIterable, Object mutex) {
        this(listIterable.iterator(), mutex);
    }

    public SynchronizedListIterator(ListIterator<E> listIterator) {
        this.listIterator = listIterator;
        this.mutex = this;
    }

    public SynchronizedListIterator(ListIterator<E> listIterator, Object mutex) {
        this.listIterator = listIterator;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasNext() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized E next() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int nextIndex() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.nextIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasPrevious() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.hasPrevious();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized E previous() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.previous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int previousIndex() {
        Object object = this.mutex;
        synchronized (object) {
            return this.listIterator.previousIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove() {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void add(E e) {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void set(E e) {
        Object object = this.mutex;
        synchronized (object) {
            this.listIterator.set(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return StringTools.buildToStringFor(this, this.listIterator);
        }
    }
}

