/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.jpt.utility.model.Model;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemPropertyListValueModelAdapter<E>
extends ItemAspectListValueModelAdapter<E> {
    protected final String[] propertyNames;
    protected final PropertyChangeListener itemPropertyListener;

    public ItemPropertyListValueModelAdapter(ListValueModel<E> listHolder, String ... propertyNames) {
        super(listHolder);
        this.propertyNames = propertyNames;
        this.itemPropertyListener = this.buildItemPropertyListener();
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel<E> collectionHolder, String ... propertyNames) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), propertyNames);
    }

    protected PropertyChangeListener buildItemPropertyListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                ItemPropertyListValueModelAdapter.this.itemAspectChanged(event);
            }

            public String toString() {
                return "item property listener: " + Arrays.asList(ItemPropertyListValueModelAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void engageItem_(Model item) {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            item.addPropertyChangeListener(propertyName, this.itemPropertyListener);
            ++n2;
        }
    }

    @Override
    protected void disengageItem_(Model item) {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            item.removePropertyChangeListener(propertyName, this.itemPropertyListener);
            ++n2;
        }
    }
}

