/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal;

import java.util.ResourceBundle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.wst.css.ui.internal.CSSUIMessages;
import org.eclipse.wst.sse.ui.internal.actions.ActionContributor;

public class ActionContributorCSS
extends ActionContributor {
    private static final String[] EDITOR_IDS = new String[]{"org.eclipse.wst.css.core.csssource.source", "org.eclipse.wst.sse.ui.StructuredTextEditor"};
    protected RetargetTextEditorAction fContentAssist = null;
    protected RetargetTextEditorAction fCleanupDocument = null;
    protected RetargetTextEditorAction fFormatDocument = null;
    protected RetargetTextEditorAction fFormatActiveElements = null;

    public ActionContributorCSS() {
        ResourceBundle resourceBundle = CSSUIMessages.getResourceBundle();
        this.fContentAssist = new RetargetTextEditorAction(resourceBundle, "");
        this.fContentAssist.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fCleanupDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fCleanupDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.cleanup.document");
        this.fFormatDocument = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatDocument.setActionDefinitionId("org.eclipse.wst.sse.ui.format.document");
        this.fFormatActiveElements = new RetargetTextEditorAction(resourceBundle, "");
        this.fFormatActiveElements.setActionDefinitionId("org.eclipse.wst.sse.ui.format.active.elements");
    }

    protected String[] getExtensionIDs() {
        return EDITOR_IDS;
    }

    protected void addToMenu(IMenuManager menu) {
        IMenuManager gotoGroup;
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IAction)this.fToggleInsertModeAction);
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IContributionItem)this.fExpandSelectionToMenu);
            editMenu.add((IContributionItem)this.fCommandsSeparator);
            editMenu.add((IAction)this.fContentAssist);
            editMenu.add((IContributionItem)this.fMenuAdditionsGroupMarker);
        }
        String sourceMenuLabel = CSSUIMessages.SourceMenu_label;
        String sourceMenuId = "sourceMenuId";
        MenuManager sourceMenu = new MenuManager(sourceMenuLabel, sourceMenuId);
        menu.insertAfter("edit", (IContributionItem)sourceMenu);
        sourceMenu.add((IContributionItem)this.fCommandsSeparator);
        sourceMenu.add((IAction)this.fShiftRight);
        sourceMenu.add((IAction)this.fShiftLeft);
        sourceMenu.add((IAction)this.fCleanupDocument);
        sourceMenu.add((IAction)this.fFormatDocument);
        sourceMenu.add((IAction)this.fFormatActiveElements);
        sourceMenu.add((IContributionItem)this.fCommandsSeparator);
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null && (gotoGroup = navigateMenu.findMenuUsingPath("goTo")) != null) {
            gotoGroup.add((IAction)this.fGotoMatchingBracketAction);
        }
    }

    public void setActiveEditor(IEditorPart activeEditor) {
        super.setActiveEditor(activeEditor);
        ITextEditor textEditor = this.getTextEditor(activeEditor);
        this.fContentAssist.setAction(this.getAction(textEditor, "ContentAssistProposals"));
        this.fCleanupDocument.setAction(this.getAction(textEditor, "CleanupDocument"));
        this.fFormatDocument.setAction(this.getAction(textEditor, "FormatDocument"));
        this.fFormatActiveElements.setAction(this.getAction(textEditor, "FormatActiveElements"));
        this.fCleanupDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatDocument.setEnabled(textEditor != null && textEditor.isEditable());
        this.fFormatActiveElements.setEnabled(textEditor != null && textEditor.isEditable());
    }
}

