/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.preferences.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.jsp.ui.internal.preferences.ui.AbstractPropertyPreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.sse.ui.internal.preferences.ui.ScrolledPageContent;
import org.eclipse.wst.validation.ValidationFramework;
import org.osgi.service.prefs.BackingStoreException;

abstract class AbstractValidationSettingsPage
extends AbstractPropertyPreferencePage {
    private List fCombos = new ArrayList();
    private List fExpandables = new ArrayList();
    private SelectionListener fSelectionListener;
    private IPreferencesService fPreferencesService = Platform.getPreferencesService();
    private static final String SETTINGS_EXPANDED = "expanded";
    private ValidationFramework fValidation = ValidationFramework.getDefault();

    protected Combo addComboBox(Composite parent, String label, String key, int[] values, String[] valueLabels, int indent) {
        GridData gd = new GridData(4, 2, true, false, 2, 1);
        gd.horizontalIndent = indent;
        Label labelControl = new Label(parent, 16384);
        labelControl.setFont(JFaceResources.getDialogFont());
        labelControl.setText(label);
        labelControl.setLayoutData((Object)gd);
        Combo comboBox = this.newComboControl(parent, key, values, valueLabels);
        comboBox.setLayoutData((Object)new GridData(256));
        return comboBox;
    }

    protected Combo newComboControl(Composite composite, String key, int[] values, String[] valueLabels) {
        ComboData data = new ComboData(key, values, -1);
        Combo comboBox = new Combo(composite, 8);
        comboBox.setItems(valueLabels);
        comboBox.setData((Object)data);
        comboBox.addSelectionListener(this.getSelectionListener());
        comboBox.setFont(JFaceResources.getDialogFont());
        this.makeScrollableCompositeAware((Control)comboBox);
        int severity = -1;
        if (key != null) {
            severity = this.fPreferencesService.getInt(this.getPreferenceNodeQualifier(), key, 2, this.createPreferenceScopes());
        }
        if (severity == 1 || severity == 2 || severity == -1) {
            data.setSeverity(severity);
            data.originalSeverity = severity;
        }
        if (data.getIndex() >= 0) {
            comboBox.select(data.getIndex());
        }
        this.fCombos.add(comboBox);
        return comboBox;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractValidationSettingsPage.this.controlChanged(e.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected void controlChanged(Widget widget) {
        ComboData data = (ComboData)widget.getData();
        if (!(widget instanceof Combo)) {
            return;
        }
        data.setIndex(((Combo)widget).getSelectionIndex());
    }

    protected void storeValues() {
        if (this.fCombos == null || this.fCombos.size() == 0) {
            return;
        }
        Iterator it = this.fCombos.iterator();
        IScopeContext[] contexts = this.createPreferenceScopes();
        while (it.hasNext()) {
            ComboData data = (ComboData)((Combo)it.next()).getData();
            if (data.getKey() == null) continue;
            contexts[0].getNode(this.getPreferenceNodeQualifier()).putInt(data.getKey(), data.getSeverity());
        }
        int i = 0;
        while (i < contexts.length) {
            try {
                contexts[i].getNode(this.getPreferenceNodeQualifier()).flush();
            }
            catch (BackingStoreException backingStoreException) {}
            ++i;
        }
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    protected ExpandableComposite createStyleSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AbstractValidationSettingsPage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandables.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        return excomposite;
    }

    protected Composite createStyleSectionWithContentComposite(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                AbstractValidationSettingsPage.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        this.fExpandables.add(excomposite);
        this.makeScrollableCompositeAware((Control)excomposite);
        Composite inner = new Composite((Composite)excomposite, 0);
        inner.setFont(excomposite.getFont());
        inner.setLayout((Layout)new GridLayout(nColumns, false));
        excomposite.setClient((Control)inner);
        return inner;
    }

    protected final void expandedStateChanged(ExpandableComposite expandable) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite((Control)expandable);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.reflow(true);
        }
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent parentScrolledComposite = this.getParentScrolledComposite(control);
        if (parentScrolledComposite != null) {
            parentScrolledComposite.adaptChild(control);
        }
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ScrolledPageContent) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledPageContent) {
            return (ScrolledPageContent)parent;
        }
        return null;
    }

    protected void storeSectionExpansionStates(IDialogSettings section) {
        int i = 0;
        while (i < this.fExpandables.size()) {
            ExpandableComposite comp = (ExpandableComposite)this.fExpandables.get(i);
            section.put(SETTINGS_EXPANDED + String.valueOf(i), comp.isExpanded());
            ++i;
        }
    }

    protected void restoreSectionExpansionStates(IDialogSettings settings) {
        int i = 0;
        while (i < this.fExpandables.size()) {
            ExpandableComposite excomposite = (ExpandableComposite)this.fExpandables.get(i);
            if (settings == null) {
                excomposite.setExpanded(i == 0);
            } else {
                excomposite.setExpanded(settings.getBoolean(SETTINGS_EXPANDED + String.valueOf(i)));
            }
            ++i;
        }
    }

    protected void resetSeverities() {
        IEclipsePreferences defaultContext = new DefaultScope().getNode(this.getPreferenceNodeQualifier());
        int i = 0;
        while (i < this.fCombos.size()) {
            ComboData data = (ComboData)((Combo)this.fCombos.get(i)).getData();
            int severity = defaultContext.getInt(data.getKey(), 2);
            data.setSeverity(severity);
            ((Combo)this.fCombos.get(i)).select(data.getIndex());
            ++i;
        }
    }

    protected boolean shouldRevalidateOnSettingsChange() {
        Iterator it = this.fCombos.iterator();
        while (it.hasNext()) {
            ComboData data = (ComboData)((Combo)it.next()).getData();
            if (!data.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean performOk() {
        if (super.performOk() && this.shouldRevalidateOnSettingsChange()) {
            MessageBox mb = new MessageBox(this.getShell(), 197058);
            mb.setText(HTMLUIMessages.Validation_Title);
            String msg = this.getProject() == null ? HTMLUIMessages.Validation_Workspace : HTMLUIMessages.Validation_Project;
            mb.setMessage(msg);
            switch (mb.open()) {
                case 256: {
                    return false;
                }
                case 64: {
                    this.storeValues();
                    ValidateJob job = new ValidateJob(HTMLUIMessages.Validation_jobName);
                    job.schedule();
                }
                case 128: {
                    this.storeValues();
                }
            }
            return true;
        }
        return true;
    }

    private class ComboData {
        private String fKey;
        private int[] fSeverities;
        private int fIndex;
        int originalSeverity = -2;

        public ComboData(String key, int[] severities, int index) {
            this.fKey = key;
            this.fSeverities = severities;
            this.fIndex = index;
        }

        public String getKey() {
            return this.fKey;
        }

        public void setIndex(int index) {
            this.fIndex = index;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public void setSeverity(int severity) {
            int i = 0;
            while (this.fSeverities != null && i < this.fSeverities.length) {
                if (this.fSeverities[i] == severity) {
                    this.setIndex(i);
                    return;
                }
                ++i;
            }
            this.setIndex(-1);
        }

        public int getSeverity() {
            return this.fIndex >= 0 && this.fSeverities != null && this.fIndex < this.fSeverities.length ? this.fSeverities[this.fIndex] : -1;
        }

        boolean isChanged() {
            return this.fSeverities[this.fIndex] != this.originalSeverity;
        }
    }

    private class ValidateJob
    extends Job {
        public ValidateJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            IStatus status = Status.OK_STATUS;
            try {
                IProject[] projects = null;
                if (AbstractValidationSettingsPage.this.getProject() != null) {
                    projects = new IProject[]{AbstractValidationSettingsPage.this.getProject()};
                } else {
                    projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    IEclipsePreferences prefs = null;
                    ArrayList<IProject> projectList = new ArrayList<IProject>();
                    int i = 0;
                    while (i < projects.length) {
                        prefs = new ProjectScope(projects[i]).getNode(AbstractValidationSettingsPage.this.getPreferenceNodeQualifier());
                        if (projects[i].isAccessible() && !prefs.getBoolean(AbstractValidationSettingsPage.this.getProjectSettingsKey(), false)) {
                            projectList.add(projects[i]);
                        }
                        ++i;
                    }
                    projects = projectList.toArray(new IProject[projectList.size()]);
                }
                AbstractValidationSettingsPage.this.fValidation.validate(projects, true, false, monitor);
            }
            catch (CoreException coreException) {
                status = Status.CANCEL_STATUS;
            }
            return status;
        }
    }
}

